/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.modules;

import java.util.List;
import java.util.Set;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.SoarConstants;
import org.jsoar.kernel.lhs.BackTraceInfo;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.WorkingMemory;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;

public class SoarModule {
    private WorkingMemory wm;
    private Decider decider;

    public void initialize(Adaptable context) {
        this.wm = Adaptables.require(this.getClass(), context, WorkingMemory.class);
        this.decider = Adaptables.require(this.getClass(), context, Decider.class);
    }

    public static WmeImpl add_module_wme(WorkingMemory wm, IdentifierImpl id, SymbolImpl attr, SymbolImpl value) {
        Slot my_slot = Slot.make_slot(id, attr, null);
        WmeImpl w = wm.make_wme(id, attr, value, false);
        my_slot.addWme(w);
        wm.add_wme_to_wm(w);
        return w;
    }

    public WmeImpl add_module_wme(IdentifierImpl id, SymbolImpl attr, SymbolImpl value) {
        return SoarModule.add_module_wme(this.wm, id, attr, value);
    }

    public void remove_module_wme(WmeImpl w) {
        Slot my_slot = Slot.find_slot((IdentifierImpl)w.getIdentifier(), (SymbolImpl)w.getAttribute());
        if (my_slot != null) {
            my_slot.removeWme(w);
            if (w.gds != null && w.gds.getGoal() != null) {
                this.decider.gds_invalid_so_remove_goal(w, "While removing a module WME");
            }
            this.wm.remove_wme_from_wm(w);
        }
    }

    public static Instantiation make_fake_instantiation(SymbolImpl state, Set<WmeImpl> conditions, List<WmeImpl.SymbolTriple> actions) {
        Instantiation inst = new Instantiation(null, null, null);
        inst.prevInProdList = null;
        inst.nextInProdList = null;
        inst.match_goal = state.asIdentifier();
        inst.match_goal_level = state.asIdentifier().level;
        inst.backtrace_number = 0;
        inst.in_ms = false;
        inst.GDS_evaluated_already = false;
        inst.preferences_generated = null;
        for (WmeImpl.SymbolTriple a_it : actions) {
            Preference pref = new Preference(PreferenceType.ACCEPTABLE, a_it.id.asIdentifier(), a_it.attr, a_it.value, null);
            pref.o_supported = true;
            pref.inst = inst;
            pref.inst_prev = null;
            pref.inst_next = null;
            pref.inst_next = inst.preferences_generated;
            pref.inst_prev = null;
            if (inst.preferences_generated != null) {
                inst.preferences_generated.inst_prev = pref;
            }
            inst.preferences_generated = pref;
        }
        PositiveCondition cond = null;
        PositiveCondition prev_cond = null;
        for (WmeImpl c_it : conditions) {
            cond = new PositiveCondition();
            cond.prev = prev_cond;
            cond.next = null;
            if (prev_cond != null) {
                prev_cond.next = cond;
            } else {
                inst.top_of_instantiated_conditions = cond;
                inst.bottom_of_instantiated_conditions = cond;
                inst.nots = null;
            }
            cond.id_test = c_it.id;
            cond.attr_test = c_it.attr;
            cond.value_test = c_it.value;
            cond.test_for_acceptable_preference = c_it.acceptable;
            BackTraceInfo conditionBacktraceInfo = cond.bt();
            conditionBacktraceInfo.wme_ = c_it;
            conditionBacktraceInfo.level = c_it.id.level;
            conditionBacktraceInfo.trace = c_it.preference;
            if (cond.bt().trace != null) {
                if (!SoarConstants.DO_TOP_LEVEL_REF_CTS) {
                    if (inst.match_goal_level > 1) {
                        cond.bt().trace.preference_add_ref();
                    }
                } else {
                    cond.bt().trace.preference_add_ref();
                }
            }
            prev_cond = cond;
        }
        return inst;
    }
}

