/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.parser.original;

import org.jsoar.kernel.memory.PreferenceType;

public enum LexemeType {
    EOF("eof"),
    VARIABLE("variable"),
    INTEGER("integer"),
    FLOAT("float"),
    IDENTIFIER("identifier"),
    SYM_CONSTANT("symbolic constant"),
    QUOTED_STRING("quoted string"),
    R_PAREN(")"),
    AT("@"),
    TILDE("~"){

        @Override
        public boolean isPreference() {
            return true;
        }

        @Override
        public PreferenceType getPreferenceType() {
            return PreferenceType.PROHIBIT;
        }
    }
    ,
    UP_ARROW("^"),
    L_BRACE("{"),
    R_BRACE("}"),
    EXCLAMATION_POINT("!"){

        @Override
        public boolean isPreference() {
            return true;
        }

        @Override
        public PreferenceType getPreferenceType() {
            return PreferenceType.REQUIRE;
        }
    }
    ,
    COMMA(","),
    GREATER(">"){

        @Override
        public boolean isPreference() {
            return true;
        }

        @Override
        public int getRelationalTestType() {
            return 3;
        }
    }
    ,
    GREATER_GREATER(">>"),
    GREATER_EQUAL(">="){

        @Override
        public int getRelationalTestType() {
            return 5;
        }
    }
    ,
    L_PAREN("("),
    EQUAL("="){

        @Override
        public boolean isPreference() {
            return true;
        }
    }
    ,
    NOT_EQUAL("<>"){

        @Override
        public int getRelationalTestType() {
            return 1;
        }
    }
    ,
    LESS("<"){

        @Override
        public boolean isPreference() {
            return true;
        }

        @Override
        public int getRelationalTestType() {
            return 2;
        }
    }
    ,
    LESS_EQUAL("<="){

        @Override
        public int getRelationalTestType() {
            return 4;
        }
    }
    ,
    LESS_LESS("<<"),
    LESS_EQUAL_GREATER("<=>"){

        @Override
        public int getRelationalTestType() {
            return 6;
        }
    }
    ,
    PERIOD("."),
    PLUS("+"){

        @Override
        public boolean isPreference() {
            return true;
        }

        @Override
        public PreferenceType getPreferenceType() {
            return PreferenceType.ACCEPTABLE;
        }
    }
    ,
    MINUS("-"){

        @Override
        public boolean isPreference() {
            return true;
        }

        @Override
        public PreferenceType getPreferenceType() {
            return PreferenceType.REJECT;
        }
    }
    ,
    RIGHT_ARROW("-->");

    private final String repr;

    private LexemeType(String repr) {
        this.repr = repr;
    }

    public boolean isPreference() {
        return false;
    }

    public PreferenceType getPreferenceType() {
        throw new UnsupportedOperationException((Object)((Object)this) + " is not appropriate for preference type");
    }

    public int getRelationalTestType() {
        throw new UnsupportedOperationException((Object)((Object)this) + " is not appropriate for a relation type");
    }

    public String repr() {
        return this.repr;
    }
}

