/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.parser.original;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.ListIterator;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.lhs.ComplexTest;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.ConjunctiveTest;
import org.jsoar.kernel.lhs.DisjunctionTest;
import org.jsoar.kernel.lhs.EqualityTest;
import org.jsoar.kernel.lhs.GoalIdTest;
import org.jsoar.kernel.lhs.ImpasseIdTest;
import org.jsoar.kernel.lhs.NegativeCondition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.RelationalTest;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.lhs.ThreeFieldCondition;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.parser.ParserException;
import org.jsoar.kernel.parser.original.Lexeme;
import org.jsoar.kernel.parser.original.LexemeType;
import org.jsoar.kernel.parser.original.Lexer;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.FunctionAction;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.RhsFunctionCall;
import org.jsoar.kernel.rhs.RhsSymbolValue;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionManager;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.LongTermIdentifierSource;
import org.jsoar.kernel.symbols.StringSymbolImpl;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.symbols.VariableGenerator;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.Arguments;
import org.jsoar.util.ByRef;
import org.jsoar.util.DefaultSourceLocation;
import org.jsoar.util.SourceLocation;

class OriginalParserImpl {
    private final Lexer lexer;
    private final Printer printer;
    private final SymbolFactoryImpl syms;
    private final VariableGenerator varGen;
    private int[] placeholder_counter = new int[26];
    private String currentProduction = null;
    private RhsFunctionManager funcs = null;
    private SourceLocation location = DefaultSourceLocation.UNKNOWN;
    private LongTermIdentifierSource ltis = new DefaultLtiSource();

    public OriginalParserImpl(VariableGenerator varGen, Lexer lexer) {
        Arguments.checkNotNull(varGen, "varGen");
        Arguments.checkNotNull(lexer, "lexer");
        this.printer = lexer.getPrinter();
        this.varGen = varGen;
        this.syms = varGen.getSyms();
        this.lexer = lexer;
        this.funcs = new RhsFunctionManager(null);
    }

    public void setRhsFunctions(RhsFunctionManager funcs) {
        this.funcs = funcs != null ? funcs : new RhsFunctionManager(null);
    }

    public void setSourceLocation(SourceLocation location) {
        this.location = location;
    }

    public void setLongTermIdSource(LongTermIdentifierSource ltis) {
        this.ltis = ltis != null ? ltis : new DefaultLtiSource();
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    private void error(String message) throws ParserException {
        if (this.currentProduction != null) {
            message = message + String.format("\n(Ignoring production %s)\n", this.currentProduction);
        }
        throw new ParserException(message);
    }

    private void consume(LexemeType type) throws IOException {
        if (this.currentType() == type) {
            this.lexer.getNextLexeme();
        }
    }

    private void consumeComma() throws IOException {
        this.consume(LexemeType.COMMA);
    }

    private void expect(LexemeType type, String context) throws ParserException, IOException {
        if (this.currentType() != type) {
            this.error("In production '" + (this.currentProduction != null ? this.currentProduction : "unknown") + "', expected " + type.repr() + " " + context + "\n");
            throw new IllegalStateException("Unreachable code");
        }
        this.lexer.getNextLexeme();
    }

    private Lexeme current() {
        return this.lexer.getCurrentLexeme();
    }

    private LexemeType currentType() {
        return this.current().type;
    }

    private SymbolImpl make_symbol_for_current_lexeme(boolean idLti) throws ParserException {
        switch (this.currentType()) {
            case SYM_CONSTANT: {
                return this.syms.createString(this.current().string);
            }
            case VARIABLE: {
                return this.syms.make_variable(this.current().string);
            }
            case INTEGER: {
                return this.syms.createInteger(this.current().int_val);
            }
            case FLOAT: {
                return this.syms.createDouble(this.current().float_val);
            }
            case IDENTIFIER: {
                if (!idLti) {
                    throw new IllegalStateException("Internal error:  ID found in make_symbol_for_current_lexeme");
                }
                return this.getLongTermIdForCurrentLexeme();
            }
        }
        throw new IllegalStateException("bad lexeme type in make_symbol_for_current_lexeme: " + this.current());
    }

    private IdentifierImpl getLongTermIdForCurrentLexeme() throws ParserException {
        assert (this.currentType() == LexemeType.IDENTIFIER);
        try {
            long lti_id = this.ltis.smem_lti_get_id(this.current().id_letter, this.current().id_number);
            if (lti_id == 0L) {
                throw new ParserException("Internal error: invalid long-term identifier found: " + this.current().string);
            }
            return this.ltis.smem_lti_soar_make(lti_id, this.current().id_letter, this.current().id_number, 0);
        }
        catch (SoarException e) {
            throw new ParserException("While retrieving long-term identifier '" + this.current().string + "': " + e.getMessage(), e);
        }
    }

    private boolean parse_lti() throws IOException {
        switch (this.currentType()) {
            case AT: {
                boolean saved = this.lexer.isAllowIds();
                this.lexer.setAllowIds(true);
                this.lexer.getNextLexeme();
                this.lexer.setAllowIds(saved);
                return true;
            }
        }
        return false;
    }

    private void reset_placeholder_variable_generator() {
        for (int i = 0; i < this.placeholder_counter.length; ++i) {
            this.placeholder_counter[i] = 1;
        }
    }

    private Test make_placeholder_test(char first_letter) {
        first_letter = (char)(Character.isLetter(first_letter) ? (int)Character.toLowerCase(first_letter) : 118);
        int n = first_letter - 97;
        int n2 = this.placeholder_counter[n];
        this.placeholder_counter[n] = n2 + 1;
        String namebuf = "<#" + first_letter + n2 + ">";
        Variable new_var = this.syms.make_variable(namebuf);
        new_var.current_binding_value = null;
        return SymbolImpl.makeEqualityTest(new_var);
    }

    private SymbolImpl substitute_for_placeholders_in_symbol(SymbolImpl sym) {
        Variable asVar = sym.asVariable();
        if (asVar == null) {
            return sym;
        }
        if (asVar.name.charAt(1) != '#') {
            return sym;
        }
        if (asVar.current_binding_value == null) {
            String prefix = asVar.name.charAt(2) + "*";
            asVar.current_binding_value = this.varGen.generate_new_variable(prefix);
        }
        return asVar.current_binding_value;
    }

    private Test substitute_for_placeholders_in_test(Test t) {
        if (Tests.isBlank(t)) {
            return t;
        }
        EqualityTest eqTest = t.asEqualityTest();
        if (eqTest != null) {
            return SymbolImpl.makeEqualityTest(this.substitute_for_placeholders_in_symbol(eqTest.getReferent()));
        }
        if (t.asGoalIdTest() != null || t.asImpasseIdTest() != null || t.asDisjunctionTest() != null) {
            return t;
        }
        ConjunctiveTest conjunctive = t.asConjunctiveTest();
        if (conjunctive != null) {
            ListIterator<Test> it = conjunctive.conjunct_list.listIterator();
            while (it.hasNext()) {
                Test child = it.next();
                it.set(this.substitute_for_placeholders_in_test(child));
            }
            return conjunctive;
        }
        RelationalTest relational = t.asRelationalTest();
        if (relational != null) {
            return relational.withNewReferent(this.substitute_for_placeholders_in_symbol(relational.referent));
        }
        throw new IllegalStateException("Unexpected complex test: " + t);
    }

    private void substitute_for_placeholders_in_condition_list(Condition cond) {
        while (cond != null) {
            ConjunctiveNegationCondition ncc;
            ThreeFieldCondition tfc = cond.asThreeFieldCondition();
            if (tfc != null) {
                tfc.id_test = this.substitute_for_placeholders_in_test(tfc.id_test);
                tfc.attr_test = this.substitute_for_placeholders_in_test(tfc.attr_test);
                tfc.value_test = this.substitute_for_placeholders_in_test(tfc.value_test);
            }
            if ((ncc = cond.asConjunctiveNegationCondition()) != null) {
                this.substitute_for_placeholders_in_condition_list(ncc.top);
            }
            cond = cond.next;
        }
    }

    private void substitute_for_placeholders_in_action_list(Action a) {
        while (a != null) {
            MakeAction ma = a.asMakeAction();
            if (ma != null) {
                RhsSymbolValue value;
                RhsSymbolValue attr;
                RhsSymbolValue id = ma.id.asSymbolValue();
                if (id != null) {
                    ma.id = id.setSymbol(this.substitute_for_placeholders_in_symbol(id.sym));
                }
                if ((attr = ma.attr.asSymbolValue()) != null) {
                    ma.attr = attr.setSymbol(this.substitute_for_placeholders_in_symbol(attr.sym));
                }
                if ((value = ma.value.asSymbolValue()) != null) {
                    ma.value = value.setSymbol(this.substitute_for_placeholders_in_symbol(value.sym));
                }
            }
            a = a.next;
        }
    }

    Test parse_relational_test() throws IOException, ParserException {
        boolean use_equality_test = false;
        int test_type = 1;
        LexemeType lexemeType = this.currentType();
        switch (lexemeType) {
            case EQUAL: {
                use_equality_test = true;
                this.lexer.getNextLexeme();
                break;
            }
            case NOT_EQUAL: 
            case LESS: 
            case GREATER: 
            case LESS_EQUAL: 
            case GREATER_EQUAL: 
            case LESS_EQUAL_GREATER: {
                test_type = lexemeType.getRelationalTestType();
                this.lexer.getNextLexeme();
                break;
            }
            default: {
                use_equality_test = true;
            }
        }
        boolean id_lti = this.parse_lti();
        switch (this.currentType()) {
            case SYM_CONSTANT: 
            case VARIABLE: 
            case INTEGER: 
            case FLOAT: 
            case IDENTIFIER: {
                SymbolImpl referent = this.make_symbol_for_current_lexeme(id_lti);
                this.lexer.getNextLexeme();
                return use_equality_test ? SymbolImpl.makeEqualityTest(referent) : new RelationalTest(test_type, referent);
            }
        }
        this.error("Expected variable or constant for test");
        throw new IllegalStateException("Unreachable code");
    }

    DisjunctionTest parse_disjunction_test() throws IOException, ParserException {
        this.expect(LexemeType.LESS_LESS, "to begin disjunction test");
        ArrayList<SymbolImpl> disjuncts = new ArrayList<SymbolImpl>();
        block3: while (this.currentType() != LexemeType.GREATER_GREATER) {
            switch (this.currentType()) {
                case SYM_CONSTANT: 
                case INTEGER: 
                case FLOAT: {
                    disjuncts.add(this.make_symbol_for_current_lexeme(false));
                    this.lexer.getNextLexeme();
                    continue block3;
                }
            }
            this.error("Expected constant or >> while reading disjunction test");
        }
        this.lexer.getNextLexeme();
        return new DisjunctionTest(Collections.unmodifiableList(disjuncts));
    }

    Test parse_simple_test() throws IOException, ParserException {
        if (this.currentType() == LexemeType.LESS_LESS) {
            return this.parse_disjunction_test();
        }
        return this.parse_relational_test();
    }

    Test parse_test() throws IOException, ParserException {
        if (this.currentType() != LexemeType.L_BRACE) {
            return this.parse_simple_test();
        }
        this.lexer.getNextLexeme();
        Test t = null;
        do {
            t = Tests.add_new_test_to_test(t, this.parse_simple_test());
        } while (this.currentType() != LexemeType.R_BRACE);
        this.lexer.getNextLexeme();
        ConjunctiveTest cjt = t.asConjunctiveTest();
        if (cjt != null) {
            Collections.reverse(cjt.conjunct_list);
        }
        return t;
    }

    private void fill_in_id_tests(Condition conds, Test t) {
        PositiveCondition positive_c = null;
        Condition c = conds;
        while (c != null && ((positive_c = c.asPositiveCondition()) == null || positive_c.id_test != null)) {
            c = c.next;
        }
        if (positive_c != null) {
            EqualityTest equality_test_from_t = Tests.copy_of_equality_test_found_in_test(t);
            Condition c2 = conds;
            while (c2 != null) {
                ConjunctiveNegationCondition ncc = c2.asConjunctiveNegationCondition();
                ThreeFieldCondition tfc = c2.asThreeFieldCondition();
                if (ncc != null) {
                    this.fill_in_id_tests(ncc.top, equality_test_from_t);
                } else if (tfc.id_test == null) {
                    tfc.id_test = equality_test_from_t.copy();
                }
                c2 = c2.next;
            }
            positive_c.id_test = t.copy();
            return;
        }
        c = conds;
        while (c != null) {
            ConjunctiveNegationCondition ncc = c.asConjunctiveNegationCondition();
            ThreeFieldCondition tfc = c.asThreeFieldCondition();
            if (ncc != null) {
                this.fill_in_id_tests(ncc.top, t);
            } else if (tfc.id_test == null) {
                tfc.id_test = t.copy();
            }
            c = c.next;
        }
    }

    private void fill_in_attr_tests(Condition conds, Test t) {
        PositiveCondition positive_c = null;
        Condition c = conds;
        while (c != null && ((positive_c = c.asPositiveCondition()) == null || positive_c.attr_test != null)) {
            c = c.next;
        }
        if (positive_c != null) {
            EqualityTest equality_test_from_t = Tests.copy_of_equality_test_found_in_test(t);
            Condition c2 = conds;
            while (c2 != null) {
                ConjunctiveNegationCondition ncc = c2.asConjunctiveNegationCondition();
                ThreeFieldCondition tfc = c2.asThreeFieldCondition();
                if (ncc != null) {
                    this.fill_in_attr_tests(ncc.top, equality_test_from_t);
                } else if (tfc.attr_test == null) {
                    tfc.attr_test = equality_test_from_t.copy();
                }
                c2 = c2.next;
            }
            positive_c.attr_test = t.copy();
            return;
        }
        c = conds;
        while (c != null) {
            ConjunctiveNegationCondition ncc = c.asConjunctiveNegationCondition();
            ThreeFieldCondition tfc = c.asThreeFieldCondition();
            if (ncc != null) {
                this.fill_in_attr_tests(ncc.top, t);
            } else if (tfc.attr_test == null) {
                tfc.attr_test = t.copy();
            }
            c = c.next;
        }
    }

    private Condition negate_condition_list(Condition conds) {
        if (conds.next == null) {
            PositiveCondition pc = conds.asPositiveCondition();
            if (pc != null) {
                return pc.negate();
            }
            NegativeCondition nc = conds.asNegativeCondition();
            if (nc != null) {
                return nc.negate();
            }
            ConjunctiveNegationCondition ncc = conds.asConjunctiveNegationCondition();
            if (ncc != null) {
                return ncc.top;
            }
            throw new IllegalStateException("Unknown condition type: " + conds);
        }
        ConjunctiveNegationCondition tempNcc = new ConjunctiveNegationCondition();
        tempNcc.top = conds;
        Condition last = conds;
        while (last.next != null) {
            last = last.next;
        }
        tempNcc.bottom = last;
        return tempNcc;
    }

    Condition parse_value_test_star(char first_letter) throws IOException, ParserException {
        EnumSet<LexemeType> endOfTest = EnumSet.of(LexemeType.MINUS, LexemeType.UP_ARROW, LexemeType.R_PAREN);
        if (endOfTest.contains((Object)this.currentType())) {
            PositiveCondition c = new PositiveCondition();
            c.value_test = this.make_placeholder_test(first_letter);
            return c;
        }
        Condition last_c = null;
        Condition first_c = null;
        ByRef<Object> value_test = ByRef.create(null);
        do {
            Condition new_conds;
            if (this.currentType() == LexemeType.L_PAREN) {
                new_conds = this.parse_conds_for_one_id(first_letter, value_test);
            } else {
                new_conds = null;
                value_test.value = this.parse_test();
                if (!Tests.test_includes_equality_test_for_symbol((Test)value_test.value, null)) {
                    value_test.value = Tests.add_new_test_to_test((Test)value_test.value, this.make_placeholder_test(first_letter));
                }
            }
            boolean acceptable = false;
            if (this.currentType() == LexemeType.PLUS) {
                acceptable = true;
                this.lexer.getNextLexeme();
            }
            PositiveCondition pc = new PositiveCondition();
            pc.value_test = (Test)value_test.value;
            pc.test_for_acceptable_preference = acceptable;
            new_conds = Condition.insertAtHead(new_conds, pc);
            if (last_c != null) {
                last_c.next = new_conds;
            } else {
                first_c = new_conds;
            }
            new_conds.prev = last_c;
            last_c = new_conds;
            while (last_c.next != null) {
                last_c = last_c.next;
            }
        } while (!endOfTest.contains((Object)this.currentType()));
        return first_c;
    }

    Condition parse_attr_value_tests() throws IOException, ParserException {
        boolean negate_it = false;
        if (this.currentType() == LexemeType.MINUS) {
            negate_it = true;
            this.lexer.getNextLexeme();
        }
        this.expect(LexemeType.UP_ARROW, "followed by attribute");
        Test attr_test = this.parse_test();
        if (!Tests.test_includes_equality_test_for_symbol(attr_test, null)) {
            attr_test = Tests.add_new_test_to_test(attr_test, this.make_placeholder_test('a'));
        }
        Condition first_c = null;
        PositiveCondition last_c = null;
        Test id_test_to_use = null;
        while (this.currentType() == LexemeType.PERIOD) {
            this.lexer.getNextLexeme();
            PositiveCondition c = new PositiveCondition();
            if (last_c != null) {
                last_c.next = c;
            } else {
                first_c = c;
            }
            c.next = null;
            c.prev = last_c;
            last_c = c;
            c.id_test = id_test_to_use != null ? id_test_to_use.copy() : null;
            c.attr_test = attr_test;
            c.value_test = id_test_to_use = this.make_placeholder_test(Tests.first_letter_from_test(attr_test));
            c.test_for_acceptable_preference = false;
            attr_test = this.parse_test();
            if (Tests.test_includes_equality_test_for_symbol(attr_test, null)) continue;
            attr_test = Tests.add_new_test_to_test(attr_test, this.make_placeholder_test('a'));
        }
        Condition new_conds = this.parse_value_test_star(Tests.first_letter_from_test(attr_test));
        this.fill_in_attr_tests(new_conds, attr_test);
        if (id_test_to_use != null) {
            this.fill_in_id_tests(new_conds, id_test_to_use);
        }
        if (last_c != null) {
            last_c.next = new_conds;
        } else {
            first_c = new_conds;
        }
        new_conds.prev = last_c;
        if (negate_it) {
            first_c = this.negate_condition_list(first_c);
        }
        return first_c;
    }

    private Test parse_head_of_conds_for_one_id(char first_letter_if_no_id_given) throws IOException, ParserException {
        this.expect(LexemeType.L_PAREN, "to begin condition element");
        ComplexTest id_goal_impasse_test = null;
        if (this.currentType() == LexemeType.SYM_CONSTANT) {
            if (this.current().string.equals("state")) {
                id_goal_impasse_test = GoalIdTest.INSTANCE;
                this.lexer.getNextLexeme();
                first_letter_if_no_id_given = (char)115;
            } else if (this.current().string.equals("impasse")) {
                id_goal_impasse_test = ImpasseIdTest.INSTANCE;
                this.lexer.getNextLexeme();
                first_letter_if_no_id_given = (char)105;
            } else {
                id_goal_impasse_test = null;
            }
        } else {
            id_goal_impasse_test = null;
        }
        Test id_test = null;
        if (this.currentType() != LexemeType.MINUS && this.currentType() != LexemeType.UP_ARROW && this.currentType() != LexemeType.R_PAREN) {
            id_test = this.parse_test();
            if (!Tests.test_includes_equality_test_for_symbol(id_test, null)) {
                id_test = Tests.add_new_test_to_test(id_test, this.make_placeholder_test(first_letter_if_no_id_given));
            } else {
                EqualityTest check_for_symconstant = Tests.copy_of_equality_test_found_in_test(id_test);
                SymbolImpl sym = ((Test)check_for_symconstant).asEqualityTest().getReferent();
                if (sym.asVariable() == null) {
                    this.error(String.format("Warning: Constant %s in id field test.\n    This will never match.", sym));
                }
            }
        } else {
            id_test = this.make_placeholder_test(first_letter_if_no_id_given);
        }
        id_test = Tests.add_new_test_to_test(id_test, id_goal_impasse_test);
        return id_test;
    }

    private Condition parse_tail_of_conds_for_one_id() throws IOException, ParserException {
        if (this.currentType() == LexemeType.R_PAREN) {
            this.lexer.getNextLexeme();
            PositiveCondition c = new PositiveCondition();
            c.attr_test = this.make_placeholder_test('a');
            c.value_test = this.make_placeholder_test('v');
            c.test_for_acceptable_preference = false;
            return c;
        }
        Condition first_c = null;
        Condition last_c = null;
        Condition new_conds = null;
        while (this.currentType() != LexemeType.R_PAREN) {
            new_conds = this.parse_attr_value_tests();
            if (last_c != null) {
                last_c.next = new_conds;
            } else {
                first_c = new_conds;
            }
            new_conds.prev = last_c;
            last_c = new_conds;
            while (last_c.next != null) {
                last_c = last_c.next;
            }
        }
        this.lexer.getNextLexeme();
        return first_c;
    }

    Condition parse_conds_for_one_id(char first_letter_if_no_id_given, ByRef<Test> dest_id_test) throws IOException, ParserException {
        Test id_test = this.parse_head_of_conds_for_one_id(first_letter_if_no_id_given);
        Condition conds = this.parse_tail_of_conds_for_one_id();
        if (dest_id_test != null) {
            dest_id_test.value = id_test;
            EqualityTest equality_test_from_id_test = Tests.copy_of_equality_test_found_in_test(id_test);
            this.fill_in_id_tests(conds, equality_test_from_id_test);
        } else {
            this.fill_in_id_tests(conds, id_test);
        }
        return conds;
    }

    Condition parse_cond() throws IOException, ParserException {
        boolean negate_it = false;
        if (this.currentType() == LexemeType.MINUS) {
            negate_it = true;
            this.lexer.getNextLexeme();
        }
        Condition c = null;
        if (this.currentType() == LexemeType.L_BRACE) {
            this.lexer.getNextLexeme();
            c = this.parse_cond_plus();
            this.expect(LexemeType.R_BRACE, "to end conjunctive condition");
        } else {
            c = this.parse_conds_for_one_id('s', null);
        }
        if (negate_it) {
            c = this.negate_condition_list(c);
        }
        return c;
    }

    Condition parse_cond_plus() throws IOException, ParserException {
        Condition first_c = null;
        Condition last_c = null;
        do {
            Condition new_conds = this.parse_cond();
            if (last_c != null) {
                last_c.next = new_conds;
            } else {
                first_c = new_conds;
            }
            new_conds.prev = last_c;
            last_c = new_conds;
            while (last_c.next != null) {
                last_c = last_c.next;
            }
        } while (this.currentType() == LexemeType.MINUS || this.currentType() == LexemeType.L_PAREN || this.currentType() == LexemeType.L_BRACE);
        return first_c;
    }

    Condition parse_lhs() throws IOException, ParserException {
        return this.parse_cond_plus();
    }

    RhsFunctionCall parse_function_call_after_lparen(boolean is_stand_alone_action) throws IOException, ParserException {
        StringSymbolImpl fun_name = this.currentType() == LexemeType.PLUS ? this.syms.createString("+") : (this.currentType() == LexemeType.MINUS ? this.syms.createString("-") : this.syms.createString(this.current().string));
        RhsFunctionHandler handler = this.funcs.getHandler(fun_name.getValue());
        if (handler == null && !this.funcs.isDisabled(fun_name.getValue())) {
            this.printer.warn("No RHS function named '%s'\n", fun_name);
        }
        RhsFunctionCall rfc = new RhsFunctionCall(fun_name, is_stand_alone_action);
        this.lexer.getNextLexeme();
        while (this.currentType() != LexemeType.R_PAREN) {
            RhsValue arg_rv = this.parse_rhs_value();
            rfc.addArgument(arg_rv);
        }
        if (handler != null) {
            int max;
            if (is_stand_alone_action && !handler.mayBeStandalone()) {
                this.printer.error("In '%s': Function %s cannot be used as a stand-alone action\n", this.currentProduction, fun_name);
            }
            if (!is_stand_alone_action && !handler.mayBeValue()) {
                this.printer.error("In '%s': Function %s can only be used as a stand-alone action\n", this.currentProduction, fun_name);
            }
            int count = rfc.getArguments().size();
            int min = handler.getMinArguments();
            if (min == (max = handler.getMaxArguments()) && count != min) {
                this.printer.error("'" + fun_name + "' function called with " + count + " arguments. Expected " + min + ".\n");
            } else if (count < min) {
                this.printer.error("'" + fun_name + "' function called with " + count + " arguments. Expected at least " + min + ".\n");
            } else if (count > max) {
                this.printer.error("'" + fun_name + "' function called with " + count + " arguments. Expected at most " + max + ".\n");
            }
        }
        this.lexer.getNextLexeme();
        return rfc;
    }

    RhsValue parse_rhs_value() throws IOException, ParserException {
        if (this.currentType() == LexemeType.L_PAREN) {
            this.lexer.getNextLexeme();
            return this.parse_function_call_after_lparen(false);
        }
        boolean id_lti = this.parse_lti();
        if (this.currentType() == LexemeType.SYM_CONSTANT || this.currentType() == LexemeType.INTEGER || this.currentType() == LexemeType.FLOAT || this.currentType() == LexemeType.VARIABLE || this.currentType() == LexemeType.IDENTIFIER) {
            RhsSymbolValue rv = this.make_symbol_for_current_lexeme(id_lti).toRhsValue();
            this.lexer.getNextLexeme();
            return rv;
        }
        this.error("Illegal value for RHS value");
        throw new IllegalStateException("Unreachable code");
    }

    PreferenceType parse_preference_specifier_without_referent() throws IOException {
        switch (this.currentType()) {
            case AT: 
            case PLUS: 
            case MINUS: 
            case EXCLAMATION_POINT: 
            case TILDE: {
                PreferenceType type = this.currentType().getPreferenceType();
                this.lexer.getNextLexeme();
                this.consumeComma();
                return type;
            }
            case GREATER: {
                return this.parseBetterBest();
            }
            case EQUAL: {
                return this.parseIndifferent();
            }
            case LESS: {
                return this.parseWorseWorst();
            }
        }
        return PreferenceType.ACCEPTABLE;
    }

    private PreferenceType parseBinaryOrUnaryPreference(PreferenceType bin, PreferenceType unary) throws IOException {
        this.lexer.getNextLexeme();
        if (!this.lexer.isEof() && this.currentType() != LexemeType.COMMA && this.currentType() != LexemeType.R_PAREN && this.currentType() != LexemeType.UP_ARROW && !this.currentType().isPreference()) {
            return bin;
        }
        this.consumeComma();
        return unary;
    }

    private PreferenceType parseWorseWorst() throws IOException {
        return this.parseBinaryOrUnaryPreference(PreferenceType.WORSE, PreferenceType.WORST);
    }

    private PreferenceType parseBetterBest() throws IOException {
        return this.parseBinaryOrUnaryPreference(PreferenceType.BETTER, PreferenceType.BEST);
    }

    private PreferenceType parseIndifferent() throws IOException {
        this.lexer.getNextLexeme();
        if (!this.lexer.isEof() && this.currentType() != LexemeType.COMMA && this.currentType() != LexemeType.R_PAREN && this.currentType() != LexemeType.UP_ARROW && !this.currentType().isPreference()) {
            if (this.currentType() == LexemeType.INTEGER || this.currentType() == LexemeType.FLOAT) {
                return PreferenceType.NUMERIC_INDIFFERENT;
            }
            return PreferenceType.BINARY_INDIFFERENT;
        }
        this.consumeComma();
        return PreferenceType.UNARY_INDIFFERENT;
    }

    Action parse_preferences(SymbolImpl id, RhsValue attr, RhsValue value) throws IOException, ParserException {
        boolean saw_plus_sign = this.currentType() == LexemeType.PLUS;
        PreferenceType preference_type = this.parse_preference_specifier_without_referent();
        if (preference_type == PreferenceType.ACCEPTABLE && !saw_plus_sign) {
            this.consumeComma();
        }
        MakeAction prev_a = null;
        do {
            RhsValue referent;
            if (preference_type.isBinary()) {
                referent = this.parse_rhs_value();
                this.consumeComma();
            } else {
                referent = null;
            }
            MakeAction a = new MakeAction();
            a.preference_type = preference_type;
            a.next = prev_a;
            prev_a = a;
            a.id = id.toRhsValue();
            a.attr = attr.copy();
            a.value = value.copy();
            if (preference_type.isBinary()) {
                a.referent = referent;
            }
            boolean bl = saw_plus_sign = this.currentType() == LexemeType.PLUS;
        } while ((preference_type = this.parse_preference_specifier_without_referent()) != PreferenceType.ACCEPTABLE || saw_plus_sign);
        return prev_a;
    }

    Action parse_preferences_soar8_non_operator(SymbolImpl id, RhsValue attr, RhsValue value) throws IOException, ParserException {
        MakeAction a;
        boolean saw_plus_sign = this.currentType() == LexemeType.PLUS;
        PreferenceType preference_type = this.parse_preference_specifier_without_referent();
        if (preference_type == PreferenceType.ACCEPTABLE && !saw_plus_sign) {
            this.consumeComma();
        }
        MakeAction prev_a = null;
        do {
            if (preference_type.isBinary()) {
                this.error(String.format("In Soar8, binary preference illegal for non-operator. (id = %s\t attr = %s\t value = %s)\n", id, attr, value));
            }
            if (preference_type != PreferenceType.ACCEPTABLE && preference_type != PreferenceType.REJECT) {
                this.printer.warn("\nWARNING: in Soar8, the only allowable non-operator preference \nis REJECT - .\nIgnoring specified preferences.\nid = %s\t attr = %s\t value = %s\n", id, attr, value);
            }
            if (preference_type == PreferenceType.REJECT) {
                a = new MakeAction();
                a.next = prev_a;
                prev_a = a;
                a.preference_type = preference_type;
                a.id = id.toRhsValue();
                a.attr = attr.copy();
                a.value = value.copy();
            }
            boolean bl = saw_plus_sign = this.currentType() == LexemeType.PLUS;
        } while ((preference_type = this.parse_preference_specifier_without_referent()) != PreferenceType.ACCEPTABLE || saw_plus_sign);
        if (prev_a == null) {
            a = new MakeAction();
            a.next = prev_a;
            prev_a = a;
            a.preference_type = PreferenceType.ACCEPTABLE;
            a.id = id.toRhsValue();
            a.attr = attr.copy();
            a.value = value.copy();
        }
        return prev_a;
    }

    Action parse_attr_value_make(SymbolImpl id) throws IOException, ParserException {
        Action last;
        Action new_actions;
        this.expect(LexemeType.UP_ARROW, "in RHS make action");
        RhsValue attr = this.parse_rhs_value();
        if (attr == null) {
            return null;
        }
        String szAttribute = String.format("%s", attr);
        Action all_actions = null;
        while (this.currentType() == LexemeType.PERIOD) {
            this.lexer.getNextLexeme();
            char first_letter = Character.toLowerCase(attr.getFirstLetter());
            if (first_letter - 97 < 0) {
                first_letter = 'v';
            }
            int n = first_letter - 97;
            int n2 = this.placeholder_counter[n];
            this.placeholder_counter[n] = n2 + 1;
            String namebuf = "<#" + first_letter + '*' + n2;
            Variable new_var = this.syms.make_variable(namebuf);
            new_var.current_binding_value = null;
            new_actions = !"operator".equals(szAttribute) ? this.parse_preferences_soar8_non_operator(id, attr, new_var.toRhsValue()) : this.parse_preferences(id, attr, new_var.toRhsValue());
            last = new_actions;
            while (last.next != null) {
                last = last.next;
            }
            last.next = all_actions;
            all_actions = new_actions;
            id = new_var;
            attr = this.parse_rhs_value();
            if (attr == null) {
                return null;
            }
            szAttribute = String.format("%s", attr);
        }
        do {
            RhsValue value = this.parse_rhs_value();
            new_actions = !"operator".equals(szAttribute) ? this.parse_preferences_soar8_non_operator(id, attr, value) : this.parse_preferences(id, attr, value);
            last = new_actions;
            while (last.next != null) {
                last = last.next;
            }
            last.next = all_actions;
            all_actions = new_actions;
        } while (this.currentType() != LexemeType.R_PAREN && this.currentType() != LexemeType.UP_ARROW);
        return all_actions;
    }

    Action parse_rhs_action() throws IOException, ParserException {
        this.expect(LexemeType.L_PAREN, "to begin RHS action");
        boolean id_lti = this.parse_lti();
        if (this.currentType() != LexemeType.VARIABLE && this.currentType() != LexemeType.IDENTIFIER) {
            RhsFunctionCall funcall_value = this.parse_function_call_after_lparen(true);
            if (funcall_value == null) {
                return null;
            }
            return new FunctionAction(funcall_value);
        }
        SymbolImpl var = id_lti ? this.getLongTermIdForCurrentLexeme() : this.syms.make_variable(this.current().string);
        this.lexer.getNextLexeme();
        Action all_actions = null;
        Action last = null;
        while (this.currentType() != LexemeType.R_PAREN) {
            Action new_actions;
            last = new_actions = this.parse_attr_value_make(var);
            while (last.next != null) {
                last = last.next;
            }
            last.next = all_actions;
            all_actions = new_actions;
        }
        this.lexer.getNextLexeme();
        return all_actions;
    }

    Action parse_rhs() throws IOException, ParserException {
        Action all_actions = null;
        Action last = null;
        while (!this.lexer.isEof() && this.currentType() != LexemeType.R_PAREN) {
            Action new_actions;
            last = new_actions = this.parse_rhs_action();
            while (last.next != null) {
                last = last.next;
            }
            last.next = all_actions;
            all_actions = new_actions;
        }
        return all_actions;
    }

    private String parseProductionName() throws ParserException, IOException {
        if (this.currentType() != LexemeType.SYM_CONSTANT) {
            this.error("Expected symbol for production name\n");
            throw new IllegalStateException("Unreachable code");
        }
        String name = this.current().string;
        this.lexer.getNextLexeme();
        return name;
    }

    private String parseDocumenation() throws IOException {
        String documentation = null;
        if (this.currentType() == LexemeType.QUOTED_STRING) {
            documentation = this.current().string;
            this.lexer.getNextLexeme();
        }
        return documentation;
    }

    public Production parseProduction() throws IOException, ParserException {
        String name;
        this.reset_placeholder_variable_generator();
        this.currentProduction = name = this.parseProductionName();
        String documentation = this.parseDocumenation();
        Production.Support declared_support = Production.Support.UNDECLARED;
        ProductionType prod_type = ProductionType.USER;
        boolean interrupt_on_match = false;
        while (this.currentType() == LexemeType.SYM_CONSTANT) {
            if (":o-support".equals(this.current().string)) {
                declared_support = Production.Support.DECLARED_O_SUPPORT;
            } else if (":i-support".equals(this.current().string)) {
                declared_support = Production.Support.DECLARED_I_SUPPORT;
            } else if (":chunk".equals(this.current().string)) {
                prod_type = ProductionType.CHUNK;
            } else if (":default".equals(this.current().string)) {
                prod_type = ProductionType.DEFAULT;
            } else if (":template".equals(this.current().string)) {
                prod_type = ProductionType.TEMPLATE;
            } else {
                if (!":interrupt".equals(this.current().string)) break;
                this.printer.warn("WARNING :interrupt is not supported with the current build options...");
                interrupt_on_match = true;
            }
            this.lexer.getNextLexeme();
        }
        Condition lhs = this.parse_lhs();
        this.expect(LexemeType.RIGHT_ARROW, "in production");
        Action rhs = OriginalParserImpl.destructively_reverse_action_list(this.parse_rhs());
        this.varGen.reset(lhs, rhs);
        this.substitute_for_placeholders_in_condition_list(lhs);
        this.substitute_for_placeholders_in_action_list(rhs);
        Condition lhs_top = lhs;
        Condition lhs_bottom = lhs;
        while (lhs_bottom.next != null) {
            lhs_bottom = lhs_bottom.next;
        }
        Production p = Production.newBuilder().type(prod_type).location(this.location).name(name).documentation(documentation).conditions(lhs_top, lhs_bottom).actions(rhs).support(declared_support).interrupt(interrupt_on_match).build();
        return p;
    }

    private static Action destructively_reverse_action_list(Action a) {
        Action prev = null;
        Action current = a;
        while (current != null) {
            Action next = current.next;
            current.next = prev;
            prev = current;
            current = next;
        }
        return prev;
    }

    private static class DefaultLtiSource
    implements LongTermIdentifierSource {
        private DefaultLtiSource() {
        }

        @Override
        public long smem_lti_get_id(char nameLetter, long nameNumber) throws SoarException {
            throw new IllegalStateException("Long term identifiers are not supported by this parser.");
        }

        @Override
        public IdentifierImpl smem_lti_soar_make(long lti, char nameLetter, long nameNumber, int level) {
            throw new IllegalStateException("Long term identifiers are not supported by this parser.");
        }
    }
}

