/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.NegativeCondition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.lhs.ThreeFieldCondition;
import org.jsoar.kernel.rete.VarNames;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.ListHead;

class NodeVarNames {
    private static final boolean ENABLED = Boolean.valueOf(System.getProperty("jsoar.discardVarNames", "false")) == false;
    final NodeVarNames parent;
    final ThreeFieldVarNames fields;
    final NodeVarNames bottom_of_subconditions;

    private NodeVarNames(NodeVarNames parent, Object idVars, Object attrVars, Object valueVars) {
        this.parent = parent;
        this.fields = new ThreeFieldVarNames(idVars, attrVars, valueVars);
        this.bottom_of_subconditions = null;
    }

    static NodeVarNames newInstance(NodeVarNames parent, Object idVars, Object attrVars, Object valueVars) {
        return new NodeVarNames(parent, idVars, attrVars, valueVars);
    }

    private NodeVarNames(NodeVarNames parent, NodeVarNames bottom_of_subconditions) {
        this.parent = parent;
        this.fields = null;
        this.bottom_of_subconditions = bottom_of_subconditions;
    }

    static NodeVarNames createForNcc(NodeVarNames parent, NodeVarNames bottom_of_subconditions) {
        return new NodeVarNames(parent, bottom_of_subconditions);
    }

    static NodeVarNames make_nvn_for_posneg_cond(ThreeFieldCondition cond, NodeVarNames parent_nvn) {
        if (!ENABLED) {
            return null;
        }
        ListHead<Variable> vars_bound = ListHead.newInstance();
        Object idVars = VarNames.add_unbound_varnames_in_test(cond.id_test, null);
        Tests.bind_variables_in_test(cond.id_test, 0, 0, false, vars_bound);
        Object attrVars = VarNames.add_unbound_varnames_in_test(cond.attr_test, null);
        Tests.bind_variables_in_test(cond.attr_test, 0, 0, false, vars_bound);
        Object valueVars = VarNames.add_unbound_varnames_in_test(cond.value_test, null);
        Variable.pop_bindings_and_deallocate_list_of_variables(vars_bound);
        return NodeVarNames.newInstance(parent_nvn, idVars, attrVars, valueVars);
    }

    static NodeVarNames get_nvn_for_condition_list(Condition cond_list, NodeVarNames parent_nvn) {
        if (!ENABLED) {
            return null;
        }
        NodeVarNames New = null;
        ListHead<Variable> vars = ListHead.newInstance();
        Condition cond = cond_list;
        while (cond != null) {
            ConjunctiveNegationCondition ncc;
            NegativeCondition nc;
            PositiveCondition pc = cond.asPositiveCondition();
            if (pc != null) {
                New = NodeVarNames.make_nvn_for_posneg_cond(pc, parent_nvn);
                Tests.bind_variables_in_test(pc.id_test, 0, 0, false, vars);
                Tests.bind_variables_in_test(pc.attr_test, 0, 0, false, vars);
                Tests.bind_variables_in_test(pc.value_test, 0, 0, false, vars);
            }
            if ((nc = cond.asNegativeCondition()) != null) {
                New = NodeVarNames.make_nvn_for_posneg_cond(nc, parent_nvn);
            }
            if ((ncc = cond.asConjunctiveNegationCondition()) != null) {
                New = new NodeVarNames(parent_nvn, NodeVarNames.get_nvn_for_condition_list(ncc.top, parent_nvn));
            }
            parent_nvn = New;
            cond = cond.next;
        }
        Variable.pop_bindings_and_deallocate_list_of_variables(vars);
        return parent_nvn;
    }

    public String toString() {
        return this.fields + "/" + this.bottom_of_subconditions;
    }

    public static class ThreeFieldVarNames {
        final Object id_varnames;
        final Object attr_varnames;
        final Object value_varnames;

        private ThreeFieldVarNames(Object idVarnames, Object attrVarnames, Object valueVarnames) {
            this.id_varnames = idVarnames;
            this.attr_varnames = attrVarnames;
            this.value_varnames = valueVarnames;
        }

        public String toString() {
            return "<" + this.id_varnames + ", " + this.attr_varnames + ", " + this.value_varnames + ">";
        }
    }
}

