/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsoar.kernel.lhs.Condition;

public class PartialMatches {
    private final List<Entry> entries;

    public PartialMatches(List<Entry> entries) {
        this.entries = Collections.unmodifiableList(new ArrayList<Entry>(entries));
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String toString() {
        return this.entries.toString();
    }

    public static class Entry {
        public final Condition condition;
        public final int matches;
        public final List<Entry> negatedSubConditions;

        public Entry(Condition condition, int matches, List<Entry> negatedSubConditions) {
            this.condition = condition;
            this.matches = matches;
            this.negatedSubConditions = negatedSubConditions != null ? Collections.unmodifiableList(new ArrayList<Entry>(negatedSubConditions)) : null;
        }

        public String toString() {
            if (this.negatedSubConditions == null) {
                return String.format("%d %s", this.matches, this.condition);
            }
            return String.format("-{\n%s\n} %d", this.negatedSubConditions, this.matches);
        }
    }
}

