/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.epmem.EpisodicMemory;
import org.jsoar.kernel.epmem.MockEpmem;
import org.jsoar.kernel.learning.rl.ReinforcementLearningParams;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.ConjunctiveTest;
import org.jsoar.kernel.lhs.DisjunctionTest;
import org.jsoar.kernel.lhs.EqualityTest;
import org.jsoar.kernel.lhs.GoalIdTest;
import org.jsoar.kernel.lhs.ImpasseIdTest;
import org.jsoar.kernel.lhs.NegativeCondition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.RelationalTest;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.lhs.ThreeFieldCondition;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.AlphaMemory;
import org.jsoar.kernel.rete.ConditionsAndNots;
import org.jsoar.kernel.rete.LeftToken;
import org.jsoar.kernel.rete.LeftTokenHashTable;
import org.jsoar.kernel.rete.NodeVarNames;
import org.jsoar.kernel.rete.NotStruct;
import org.jsoar.kernel.rete.PartialMatches;
import org.jsoar.kernel.rete.ProductionAddResult;
import org.jsoar.kernel.rete.ReteBuilder;
import org.jsoar.kernel.rete.ReteListener;
import org.jsoar.kernel.rete.ReteNode;
import org.jsoar.kernel.rete.ReteNodeToConditionsResult;
import org.jsoar.kernel.rete.ReteNodeType;
import org.jsoar.kernel.rete.ReteTest;
import org.jsoar.kernel.rete.ReteTestRoutines;
import org.jsoar.kernel.rete.RightMemory;
import org.jsoar.kernel.rete.RightMemoryHashTable;
import org.jsoar.kernel.rete.RightToken;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.rete.VarNames;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.FunctionAction;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.smem.MockSmem;
import org.jsoar.kernel.smem.SemanticMemory;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.util.Arguments;
import org.jsoar.util.ByRef;
import org.jsoar.util.HashTable;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.properties.PropertyManager;

public class Rete {
    private final Trace trace;
    private final SymbolFactoryImpl syms;
    private final boolean discard_chunk_varnames = true;
    private ReteListener listener;
    private final LeftTokenHashTable left_ht = new LeftTokenHashTable();
    private final RightMemoryHashTable right_ht = new RightMemoryHashTable();
    int[] rete_node_counts = new int[256];
    RightToken dummy_top_token;
    private int alpha_mem_id_counter;
    private List<HashTable<AlphaMemory>> alpha_hash_tables;
    private LinkedHashSet<WmeImpl> all_wmes_in_rete = new LinkedHashSet();
    private int beta_node_id_counter;
    ReteNode dummy_top_node;
    private SymbolImpl[] rhs_variable_bindings = new SymbolImpl[0];
    private int highest_rhs_unboundvar_index;
    private Token dummy_matches_node_tokens;
    private final EpisodicMemory episodicMemory;
    private final SemanticMemory semanticMemory;
    private final ReinforcementLearningParams reinforcementLearningParams;

    public Rete(Trace trace, SymbolFactoryImpl syms, EpisodicMemory episodicMemory, SemanticMemory semanticMemory, ReinforcementLearningParams reinforcementLearningParams) {
        Arguments.checkNotNull(trace, "trace");
        Arguments.checkNotNull(syms, "syms");
        Arguments.checkNotNull(episodicMemory, "episodicMemory");
        Arguments.checkNotNull(semanticMemory, "semanticMemory");
        Arguments.checkNotNull(reinforcementLearningParams, "reinforcementLearningParams");
        this.trace = trace;
        this.syms = syms;
        this.episodicMemory = episodicMemory;
        this.semanticMemory = semanticMemory;
        this.reinforcementLearningParams = reinforcementLearningParams;
        this.alpha_hash_tables = new ArrayList<HashTable<AlphaMemory>>(16);
        for (int i = 0; i < 16; ++i) {
            this.alpha_hash_tables.add(new HashTable<AlphaMemory>(0, AlphaMemory.HASH_FUNCTION, AlphaMemory.class));
        }
        this.init_dummy_top_node();
    }

    public Rete(Trace trace, SymbolFactoryImpl syms) {
        this(trace, syms, new MockEpmem(), new MockSmem(), new ReinforcementLearningParams(new PropertyManager(), syms));
    }

    public void setReteListener(ReteListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("listener already set");
        }
        this.listener = listener;
    }

    public SymbolFactoryImpl getSymbols() {
        return this.syms;
    }

    public SymbolImpl getRhsVariableBinding(int index) {
        return this.rhs_variable_bindings[index];
    }

    public void setRhsVariableBinding(int index, SymbolImpl sym) {
        this.rhs_variable_bindings[index] = sym;
        if (this.highest_rhs_unboundvar_index < index) {
            this.highest_rhs_unboundvar_index = index;
        }
    }

    public int getHighestRhsUnboundVariableIndex() {
        return this.highest_rhs_unboundvar_index;
    }

    public Collection<WmeImpl> getAllWmes() {
        return this.all_wmes_in_rete;
    }

    public boolean containsWme(Wme w) {
        return this.all_wmes_in_rete.contains(w);
    }

    public ProductionAddResult add_production_to_rete(Production p) {
        return this.add_production_to_rete(p, null, true, false);
    }

    public ProductionAddResult add_production_to_rete(Production p, Instantiation refracted_inst, boolean warn_on_duplicates, boolean ignore_rhs) {
        ProductionAddResult production_addition_result;
        Condition lhs_top = p.getFirstCondition();
        ByRef<Object> bottom_node = ByRef.create(null);
        ByRef<Integer> bottom_depth = ByRef.create(0);
        ByRef<Object> vars_bound = ByRef.create(null);
        ReteBuilder.build_network_for_condition_list(this, lhs_top, 1, this.dummy_top_node, bottom_node, bottom_depth, vars_bound);
        ArrayList<Variable> rhs_unbound_vars_for_new_prod = new ArrayList<Variable>(3);
        DefaultMarker rhs_unbound_vars_tc = DefaultMarker.create();
        Action a = p.getFirstAction();
        while (a != null) {
            MakeAction ma = a.asMakeAction();
            if (ma != null) {
                ma.value = ReteBuilder.fixup_rhs_value_variable_references(this, ma.value, (Integer)bottom_depth.value, rhs_unbound_vars_for_new_prod, rhs_unbound_vars_tc);
                ma.id = ReteBuilder.fixup_rhs_value_variable_references(this, ma.id, (Integer)bottom_depth.value, rhs_unbound_vars_for_new_prod, rhs_unbound_vars_tc);
                ma.attr = ReteBuilder.fixup_rhs_value_variable_references(this, ma.attr, (Integer)bottom_depth.value, rhs_unbound_vars_for_new_prod, rhs_unbound_vars_tc);
                if (a.preference_type.isBinary()) {
                    ma.referent = ReteBuilder.fixup_rhs_value_variable_references(this, ma.referent, (Integer)bottom_depth.value, rhs_unbound_vars_for_new_prod, rhs_unbound_vars_tc);
                }
            } else {
                FunctionAction fa = a.asFunctionAction();
                RhsValue result = ReteBuilder.fixup_rhs_value_variable_references(this, fa.call, (Integer)bottom_depth.value, rhs_unbound_vars_for_new_prod, rhs_unbound_vars_tc);
                assert (result == fa.call);
            }
            a = a.next;
        }
        Variable.pop_bindings_and_deallocate_list_of_variables((ListHead)vars_bound.value);
        this.update_max_rhs_unbound_variables(rhs_unbound_vars_for_new_prod.size());
        ReteNode p_node = ((ReteNode)bottom_node.value).first_child;
        while (p_node != null) {
            if (p_node.node_type == ReteNodeType.P_BNODE && (ignore_rhs || Action.same_rhs(p_node.b_p().prod.getFirstAction(), p.getFirstAction(), this.reinforcementLearningParams.chunk_stop.get() == ReinforcementLearningParams.ChunkStop.on))) {
                if (warn_on_duplicates) {
                    this.trace.getPrinter().warn("\nIgnoring %s because it is a duplicate of %s ", p.getName(), p_node.b_p().prod.getName());
                }
                return ProductionAddResult.DUPLICATE_PRODUCTION;
            }
            p_node = p_node.next_sibling;
        }
        p_node = ReteNode.make_new_production_node(this, (ReteNode)bottom_node.value, p);
        if (refracted_inst != null) {
            this.listener.startRefraction(this, p, refracted_inst, p_node);
        }
        this.update_node_with_matches_from_above(p_node);
        if (refracted_inst == null) {
            production_addition_result = ProductionAddResult.NO_REFRACTED_INST;
        } else {
            boolean refactedInstMatched = this.listener.finishRefraction(this, p, refracted_inst, p_node);
            ProductionAddResult productionAddResult = production_addition_result = refactedInstMatched ? ProductionAddResult.REFRACTED_INST_MATCHED : ProductionAddResult.REFRACTED_INST_DID_NOT_MATCH;
        }
        if (p.getType() == ProductionType.CHUNK) {
            p.getReteNode().b_p().parents_nvn = null;
            p.clearRhsUnboundVariables();
        } else {
            p.getReteNode().b_p().parents_nvn = NodeVarNames.get_nvn_for_condition_list(lhs_top, null);
            p.setRhsUnboundVariables(rhs_unbound_vars_for_new_prod);
        }
        return production_addition_result;
    }

    public void excise_production_from_rete(Production p) {
        ReteNode p_node = p.getReteNode();
        p.setReteNode(null, null);
        ReteNode parent = p_node.parent;
        p_node.b_p().parents_nvn = null;
        while (p_node.a_np().tokens != null) {
            this.remove_token_and_subtree(p_node.a_np().tokens);
        }
        this.listener.removingProductionNode(this, p_node);
        p_node.remove_node_from_parents_list_of_children();
        if (parent.first_child == null) {
            ReteNode.deallocate_rete_node(this, parent);
        }
    }

    static int addressOf(Object o) {
        return System.identityHashCode(o);
    }

    private static int xor_op(int i, int a, int v) {
        return i ^ a ^ v;
    }

    public void add_wme_to_rete(WmeImpl w) {
        this.all_wmes_in_rete.add(w);
        w.clearRightMemories();
        w.tokens = null;
        int hi = w.id.hash_id;
        int ha = w.attr.hash_id;
        int hv = w.value.hash_id;
        if (w.acceptable) {
            this.add_wme_to_aht(this.alpha_hash_tables.get(8), Rete.xor_op(0, 0, 0), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(9), Rete.xor_op(hi, 0, 0), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(10), Rete.xor_op(0, ha, 0), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(11), Rete.xor_op(hi, ha, 0), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(12), Rete.xor_op(0, 0, hv), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(13), Rete.xor_op(hi, 0, hv), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(14), Rete.xor_op(0, ha, hv), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(15), Rete.xor_op(hi, ha, hv), w);
        } else {
            this.add_wme_to_aht(this.alpha_hash_tables.get(0), Rete.xor_op(0, 0, 0), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(1), Rete.xor_op(hi, 0, 0), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(2), Rete.xor_op(0, ha, 0), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(3), Rete.xor_op(hi, ha, 0), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(4), Rete.xor_op(0, 0, hv), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(5), Rete.xor_op(hi, 0, hv), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(6), Rete.xor_op(0, ha, hv), w);
            this.add_wme_to_aht(this.alpha_hash_tables.get(7), Rete.xor_op(hi, ha, hv), w);
        }
        w.epmem_id = -1L;
        w.epmem_valid = 0L;
        if (this.episodicMemory.epmem_enabled()) {
            IdentifierImpl id = w.value.asIdentifier();
            if (id != null && id.epmem_id != -1L && id.epmem_valid == this.episodicMemory.epmem_validation() && id.smem_lti == 0L) {
                this.episodicMemory.addIdRefCount(id.epmem_id, w);
            }
            if (w.id.asIdentifier().epmem_id != -1L && w.id.asIdentifier().epmem_valid == this.episodicMemory.epmem_validation()) {
                this.episodicMemory.addWme(w.id);
            }
        }
        if (w.id.smem_lti != 0L && !this.semanticMemory.smem_ignore_changes() && this.semanticMemory.smem_enabled() && this.semanticMemory.isMirroringEnabled()) {
            this.semanticMemory.smem_changed_ids().add(w.id);
        }
    }

    public void remove_wme_from_rete(WmeImpl w) {
        if (this.episodicMemory.epmem_enabled()) {
            this.episodicMemory.removeWme(w);
            this.episodicMemory.processIds();
        }
        this.all_wmes_in_rete.remove(w);
        while (w.getRightMemories() != null) {
            RightMemory rm = w.getRightMemories();
            AlphaMemory am = rm.am;
            this.remove_wme_from_alpha_mem(rm);
            if (am.right_mems != null) continue;
            ReteNode next = null;
            ReteNode node = am.beta_nodes;
            while (node != null) {
                next = node.b_posneg().next_from_alpha_mem;
                switch (node.node_type) {
                    case POSITIVE_BNODE: 
                    case UNHASHED_POSITIVE_BNODE: {
                        node.unlink_from_left_mem();
                        break;
                    }
                    case MP_BNODE: 
                    case UNHASHED_MP_BNODE: {
                        node.make_mp_bnode_left_unlinked();
                        break;
                    }
                }
                node = next;
            }
        }
        while (w.tokens != null) {
            Token tok = w.tokens;
            ReteNode node = tok.node;
            if (tok.parent == null) {
                RightToken rt = (RightToken)tok;
                LeftToken left = rt.getLeftToken();
                tok.removeFromWme();
                left.removeNegRightToken(rt);
                if (left.hasNegRightTokens()) continue;
                ReteNode child = node.first_child;
                while (child != null) {
                    this.executeLeftAddition(child, left, null);
                    child = child.next_sibling;
                }
                continue;
            }
            this.remove_token_and_subtree(tok);
        }
    }

    int get_next_alpha_mem_id() {
        return this.alpha_mem_id_counter++;
    }

    void add_wme_to_alpha_mem(WmeImpl w, AlphaMemory am) {
        RightMemory rm = new RightMemory(w, am);
        int hv = am.am_id ^ w.id.hash_id;
        this.right_ht.insertAtHeadOfBucket(hv, rm);
        am.insertRightMemoryAtHead(rm);
        w.addRightMemory(rm);
    }

    void remove_wme_from_alpha_mem(RightMemory rm) {
        WmeImpl w = rm.w;
        AlphaMemory am = rm.am;
        int hv = am.am_id ^ w.id.hash_id;
        this.right_ht.removeFromBucket(hv, rm);
        am.removeRightMemory(rm);
        w.removeRightMemory(rm);
    }

    HashTable<AlphaMemory> table_for_tests(SymbolImpl id, SymbolImpl attr, SymbolImpl value, boolean acceptable) {
        int index = (id != null ? 1 : 0) + (attr != null ? 2 : 0) + (value != null ? 4 : 0) + (acceptable ? 8 : 0);
        return this.alpha_hash_tables.get(index);
    }

    AlphaMemory find_alpha_mem(SymbolImpl id, SymbolImpl attr, SymbolImpl value, boolean acceptable) {
        HashTable<AlphaMemory> ht = this.table_for_tests(id, attr, value, acceptable);
        int hash_value = AlphaMemory.alpha_hash_value(id, attr, value, ht.getLog2Size());
        AlphaMemory am = ht.getBucket(hash_value);
        while (am != null) {
            if (am.id == id && am.attr == attr && am.value == value && am.acceptable == acceptable) {
                return am;
            }
            am = (AlphaMemory)am.next_in_hash_table;
        }
        return null;
    }

    List<AlphaMemory> getAllAlphaMemories() {
        ArrayList<AlphaMemory> result = new ArrayList<AlphaMemory>();
        for (HashTable<AlphaMemory> ht : this.alpha_hash_tables) {
            result.addAll(ht.getAllItems());
        }
        return result;
    }

    AlphaMemory find_or_make_alpha_mem(SymbolImpl id, SymbolImpl attr, SymbolImpl value, boolean acceptable) {
        AlphaMemory am = this.find_alpha_mem(id, attr, value, acceptable);
        if (am != null) {
            ++am.reference_count;
            return am;
        }
        am = new AlphaMemory(this.get_next_alpha_mem_id(), id, attr, value, acceptable);
        HashTable<AlphaMemory> ht = this.table_for_tests(id, attr, value, acceptable);
        ht.add_to_hash_table(am);
        AlphaMemory more_general_am = null;
        if (id != null) {
            more_general_am = this.find_alpha_mem(null, attr, value, acceptable);
        }
        if (more_general_am == null && value != null) {
            more_general_am = this.find_alpha_mem(null, attr, null, acceptable);
        }
        if (more_general_am != null) {
            RightMemory rm = more_general_am.right_mems;
            while (rm != null) {
                if (am.wme_matches_alpha_mem(rm.w)) {
                    this.add_wme_to_alpha_mem(rm.w, am);
                }
                rm = rm.next_in_am;
            }
        } else {
            for (WmeImpl w : this.all_wmes_in_rete) {
                if (!am.wme_matches_alpha_mem(w)) continue;
                this.add_wme_to_alpha_mem(w, am);
            }
        }
        return am;
    }

    void add_wme_to_aht(HashTable<AlphaMemory> ht, int hash_value, WmeImpl w) {
        AlphaMemory am = ht.getBucket(hash_value &= HashTable.masks_for_n_low_order_bits[ht.getLog2Size()]);
        while (am != null) {
            if (am.wme_matches_alpha_mem(w)) {
                this.add_wme_to_alpha_mem(w, am);
                ReteNode next = null;
                ReteNode node = am.beta_nodes;
                while (node != null) {
                    next = node.b_posneg().next_from_alpha_mem;
                    this.executeRightAddition(node, w);
                    node = next;
                }
                return;
            }
            am = (AlphaMemory)am.next_in_hash_table;
        }
    }

    int get_next_beta_node_id() {
        return this.beta_node_id_counter++;
    }

    void init_dummy_top_node() {
        this.dummy_top_node = ReteNode.createDummy();
        this.dummy_top_token = RightToken.createDummy(this.dummy_top_node);
    }

    void update_node_with_matches_from_above(ReteNode child) {
        if (child.node_type.bnode_is_bottom_of_split_mp()) {
            throw new IllegalArgumentException("Internal error: update_node_with_matches_from_above called on split node");
        }
        ReteNode parent = child.parent;
        if (parent.node_type == ReteNodeType.DUMMY_TOP_BNODE) {
            this.executeLeftAddition(child, this.dummy_top_token, null);
            return;
        }
        if (parent.node_type.bnode_is_positive()) {
            if (parent.node_is_right_unlinked()) {
                return;
            }
            ReteNode saved_parents_first_child = parent.first_child;
            ReteNode saved_childs_next_sibling = child.next_sibling;
            parent.first_child = child;
            child.next_sibling = null;
            RightMemory rm = parent.b_posneg().alpha_mem_.right_mems;
            while (rm != null) {
                this.executeRightAddition(parent, rm.w);
                rm = rm.next_in_am;
            }
            parent.first_child = saved_parents_first_child;
            child.next_sibling = saved_childs_next_sibling;
            return;
        }
        Token tok = parent.a_np().tokens;
        while (tok != null) {
            if (!((LeftToken)tok).hasNegRightTokens()) {
                this.executeLeftAddition(child, tok, null);
            }
            tok = tok.next_of_node;
        }
    }

    void update_max_rhs_unbound_variables(int num_for_new_production) {
        if (num_for_new_production > this.rhs_variable_bindings.length) {
            this.rhs_variable_bindings = new SymbolImpl[num_for_new_production];
        }
    }

    private Test add_gensymmed_equality_test(Test t, char first_letter) {
        Variable New = this.syms.getVariableGenerator().generate_new_variable(Character.toString(first_letter));
        EqualityTest eq_test = SymbolImpl.makeEqualityTest(New);
        return Tests.add_new_test_to_test(t, eq_test);
    }

    public static SymbolImpl var_bound_in_reconstructed_conds(Condition cond, int where_field_num, int where_levels_up) {
        while (where_levels_up != 0) {
            --where_levels_up;
            cond = cond.prev;
        }
        ThreeFieldCondition tfc = cond.asThreeFieldCondition();
        if (tfc == null) {
            throw new IllegalStateException("Expected ThreeFieldCondition, got " + cond);
        }
        Test t = where_field_num == 0 ? tfc.id_test : (where_field_num == 1 ? tfc.attr_test : tfc.value_test);
        if (Tests.isBlank(t)) {
            throw new IllegalStateException("Internal error in var_bound_in_reconstructed_conds");
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            return eq.getReferent();
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test c : ct.conjunct_list) {
                EqualityTest eq2 = c.asEqualityTest();
                if (Tests.isBlank(c) || eq2 == null) continue;
                return eq2.getReferent();
            }
        }
        throw new IllegalStateException("Internal error in var_bound_in_reconstructed_conds");
    }

    private void executeLeftAddition(ReteNode node, Token tok, WmeImpl w) {
        switch (node.node_type) {
            case MEMORY_BNODE: {
                this.beta_memory_node_left_addition(node, tok, w);
                break;
            }
            case UNHASHED_MEMORY_BNODE: {
                this.unhashed_beta_memory_node_left_addition(node, tok, w);
                break;
            }
            case MP_BNODE: {
                this.mp_node_left_addition(node, tok, w);
                break;
            }
            case UNHASHED_MP_BNODE: {
                this.unhashed_mp_node_left_addition(node, tok, w);
                break;
            }
            case CN_BNODE: {
                this.cn_node_left_addition(node, tok, w);
                break;
            }
            case CN_PARTNER_BNODE: {
                this.cn_partner_node_left_addition(node, tok, w);
                break;
            }
            case P_BNODE: {
                this.p_node_left_addition(node, tok, w);
                break;
            }
            case NEGATIVE_BNODE: {
                this.negative_node_left_addition(node, tok, w);
                break;
            }
            case UNHASHED_NEGATIVE_BNODE: {
                this.unhashed_negative_node_left_addition(node, tok, w);
                break;
            }
            case DUMMY_MATCHES_BNODE: {
                this.dummy_matches_node_left_addition(node, tok, w);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled node type " + (Object)((Object)node.node_type));
            }
        }
    }

    private void executeRightAddition(ReteNode node, WmeImpl w) {
        switch (node.node_type) {
            case POSITIVE_BNODE: {
                this.positive_node_right_addition(node, w);
                break;
            }
            case UNHASHED_POSITIVE_BNODE: {
                this.unhashed_positive_node_right_addition(node, w);
                break;
            }
            case MP_BNODE: {
                this.mp_node_right_addition(node, w);
                break;
            }
            case UNHASHED_MP_BNODE: {
                this.unhashed_mp_node_right_addition(node, w);
                break;
            }
            case NEGATIVE_BNODE: {
                this.negative_node_right_addition(node, w);
                break;
            }
            case UNHASHED_NEGATIVE_BNODE: {
                this.unhashed_negative_node_right_addition(node, w);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled node type " + (Object)((Object)node.node_type));
            }
        }
    }

    private void beta_memory_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        SymbolImpl referent;
        int levels_up = node.left_hash_loc_levels_up;
        if (levels_up == 1) {
            referent = w.getField(node.left_hash_loc_field_num);
        } else {
            Token t = tok;
            t = tok;
            levels_up -= 2;
            while (levels_up != 0) {
                t = t.parent;
                --levels_up;
            }
            referent = t.w.getField(node.left_hash_loc_field_num);
        }
        int hv = node.node_id ^ referent.hash_id;
        LeftToken New = new LeftToken(node, tok, w, referent);
        this.left_ht.insert_token_into_left_ht(New, hv);
        ListItem next = null;
        ListItem child = node.b_mem().first_linked_child.first;
        while (child != null) {
            next = ((ReteNode)child.item).a_pos().from_beta_mem.next;
            this.positive_node_left_addition((ReteNode)child.item, New, referent);
            child = next;
        }
    }

    private void unhashed_beta_memory_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        int hv = node.node_id;
        LeftToken New = new LeftToken(node, tok, w, null);
        this.left_ht.insert_token_into_left_ht(New, hv);
        ListItem next = null;
        ListItem child = node.b_mem().first_linked_child.first;
        while (child != null) {
            next = ((ReteNode)child.item).a_pos().from_beta_mem.next;
            this.unhashed_positive_node_left_addition((ReteNode)child.item, New);
            child = next;
        }
    }

    private void positive_node_left_addition(ReteNode node, LeftToken New, SymbolImpl hash_referent) {
        AlphaMemory am = node.b_posneg().alpha_mem_;
        if (node.node_is_right_unlinked()) {
            node.relink_to_right_mem();
            if (am.right_mems == null) {
                node.unlink_from_left_mem();
                return;
            }
        }
        int right_hv = am.am_id ^ hash_referent.hash_id;
        RightMemory rm = this.right_ht.right_ht_bucket(right_hv);
        while (rm != null) {
            if (rm.am == am && hash_referent == rm.w.id) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, New, rm.w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    ReteNode child = node.first_child;
                    while (child != null) {
                        this.executeLeftAddition(child, New, rm.w);
                        child = child.next_sibling;
                    }
                }
            }
            rm = rm.next_in_bucket;
        }
    }

    private void unhashed_positive_node_left_addition(ReteNode node, LeftToken New) {
        if (node.node_is_right_unlinked()) {
            node.relink_to_right_mem();
            if (node.b_posneg().alpha_mem_.right_mems == null) {
                node.unlink_from_left_mem();
                return;
            }
        }
        RightMemory rm = node.b_posneg().alpha_mem_.right_mems;
        while (rm != null) {
            boolean failed_a_test = false;
            ReteTest rt = node.b_posneg().other_tests;
            while (rt != null) {
                if (!ReteTestRoutines.match_left_and_right(rt, New, rm.w)) {
                    failed_a_test = true;
                    break;
                }
                rt = rt.next;
            }
            if (!failed_a_test) {
                ReteNode child = node.first_child;
                while (child != null) {
                    this.executeLeftAddition(child, New, rm.w);
                    child = child.next_sibling;
                }
            }
            rm = rm.next_in_am;
        }
    }

    private void mp_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        SymbolImpl referent;
        int levels_up = node.left_hash_loc_levels_up;
        if (levels_up == 1) {
            referent = w.getField(node.left_hash_loc_field_num);
        } else {
            Token t = tok;
            t = tok;
            levels_up -= 2;
            while (levels_up != 0) {
                t = t.parent;
                --levels_up;
            }
            referent = t.w.getField(node.left_hash_loc_field_num);
        }
        int hv = node.node_id ^ referent.hash_id;
        LeftToken New = new LeftToken(node, tok, w, referent);
        this.left_ht.insert_token_into_left_ht(New, hv);
        if (node.mp_bnode_is_left_unlinked()) {
            return;
        }
        AlphaMemory am = node.b_posneg().alpha_mem_;
        if (node.node_is_right_unlinked()) {
            node.relink_to_right_mem();
            if (am.right_mems == null) {
                node.make_mp_bnode_left_unlinked();
                return;
            }
        }
        int right_hv = am.am_id ^ referent.hash_id;
        RightMemory rm = this.right_ht.right_ht_bucket(right_hv);
        while (rm != null) {
            if (rm.am == am && referent == rm.w.id) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, New, rm.w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    ReteNode child = node.first_child;
                    while (child != null) {
                        this.executeLeftAddition(child, New, rm.w);
                        child = child.next_sibling;
                    }
                }
            }
            rm = rm.next_in_bucket;
        }
    }

    private void unhashed_mp_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        int hv = node.node_id;
        LeftToken New = new LeftToken(node, tok, w, null);
        this.left_ht.insert_token_into_left_ht(New, hv);
        if (node.mp_bnode_is_left_unlinked()) {
            return;
        }
        if (node.node_is_right_unlinked()) {
            node.relink_to_right_mem();
            if (node.b_posneg().alpha_mem_.right_mems == null) {
                node.make_mp_bnode_left_unlinked();
                return;
            }
        }
        RightMemory rm = node.b_posneg().alpha_mem_.right_mems;
        while (rm != null) {
            boolean failed_a_test = false;
            ReteTest rt = node.b_posneg().other_tests;
            while (rt != null) {
                if (!ReteTestRoutines.match_left_and_right(rt, New, rm.w)) {
                    failed_a_test = true;
                    break;
                }
                rt = rt.next;
            }
            if (!failed_a_test) {
                ReteNode child = node.first_child;
                while (child != null) {
                    this.executeLeftAddition(child, New, rm.w);
                    child = child.next_sibling;
                }
            }
            rm = rm.next_in_am;
        }
    }

    private void positive_node_right_addition(ReteNode node, WmeImpl w) {
        if (node.node_is_left_unlinked()) {
            node.relink_to_left_mem();
            if (node.parent.a_np().tokens == null) {
                node.unlink_from_right_mem();
                return;
            }
        }
        IdentifierImpl referent = w.id;
        int hv = node.parent.node_id ^ referent.hash_id;
        LeftToken tok = this.left_ht.left_ht_bucket(hv);
        while (tok != null) {
            if (tok.node == node.parent && tok.referent == referent) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, tok, w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    ReteNode child = node.first_child;
                    while (child != null) {
                        this.executeLeftAddition(child, tok, w);
                        child = child.next_sibling;
                    }
                }
            }
            tok = tok.next_in_bucket;
        }
    }

    private void unhashed_positive_node_right_addition(ReteNode node, WmeImpl w) {
        if (node.node_is_left_unlinked()) {
            node.relink_to_left_mem();
            if (node.parent.a_np().tokens == null) {
                node.unlink_from_right_mem();
                return;
            }
        }
        int hv = node.parent.node_id;
        LeftToken tok = this.left_ht.left_ht_bucket(hv);
        while (tok != null) {
            if (tok.node == node.parent) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, tok, w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    ReteNode child = node.first_child;
                    while (child != null) {
                        this.executeLeftAddition(child, tok, w);
                        child = child.next_sibling;
                    }
                }
            }
            tok = tok.next_in_bucket;
        }
    }

    private void mp_node_right_addition(ReteNode node, WmeImpl w) {
        if (node.mp_bnode_is_left_unlinked()) {
            node.make_mp_bnode_left_linked();
            if (node.a_np().tokens == null) {
                node.unlink_from_right_mem();
                return;
            }
        }
        IdentifierImpl referent = w.id;
        int hv = node.node_id ^ referent.hash_id;
        LeftToken tok = this.left_ht.left_ht_bucket(hv);
        while (tok != null) {
            if (tok.node == node && tok.referent == referent) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, tok, w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    ReteNode child = node.first_child;
                    while (child != null) {
                        this.executeLeftAddition(child, tok, w);
                        child = child.next_sibling;
                    }
                }
            }
            tok = tok.next_in_bucket;
        }
    }

    private void unhashed_mp_node_right_addition(ReteNode node, WmeImpl w) {
        if (node.mp_bnode_is_left_unlinked()) {
            node.make_mp_bnode_left_linked();
            if (node.a_np().tokens == null) {
                node.unlink_from_right_mem();
                return;
            }
        }
        int hv = node.node_id;
        LeftToken tok = this.left_ht.left_ht_bucket(hv);
        while (tok != null) {
            if (tok.node == node) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, tok, w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    ReteNode child = node.first_child;
                    while (child != null) {
                        this.executeLeftAddition(child, tok, w);
                        child = child.next_sibling;
                    }
                }
            }
            tok = tok.next_in_bucket;
        }
    }

    private void negative_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        if (node.node_is_right_unlinked()) {
            node.relink_to_right_mem();
        }
        SymbolImpl referent = null;
        int levels_up = node.left_hash_loc_levels_up;
        if (levels_up == 1) {
            referent = w.getField(node.left_hash_loc_field_num);
        } else {
            Token t = tok;
            levels_up -= 2;
            while (levels_up != 0) {
                t = t.parent;
                --levels_up;
            }
            referent = t.w.getField(node.left_hash_loc_field_num);
        }
        int hv = node.node_id ^ referent.hash_id;
        LeftToken New = new LeftToken(node, tok, w, referent);
        this.left_ht.insert_token_into_left_ht(New, hv);
        AlphaMemory am = node.b_posneg().alpha_mem_;
        int right_hv = am.am_id ^ referent.hash_id;
        RightMemory rm = this.right_ht.right_ht_bucket(right_hv);
        while (rm != null) {
            if (rm.am == am && referent == rm.w.id) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, New, rm.w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    RightToken.create(node, null, rm.w, New);
                }
            }
            rm = rm.next_in_bucket;
        }
        if (!New.hasNegRightTokens()) {
            ReteNode child = node.first_child;
            while (child != null) {
                this.executeLeftAddition(child, New, null);
                child = child.next_sibling;
            }
        }
    }

    private void unhashed_negative_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        if (node.node_is_right_unlinked()) {
            node.relink_to_right_mem();
        }
        int hv = node.node_id;
        LeftToken New = new LeftToken(node, tok, w, null);
        this.left_ht.insert_token_into_left_ht(New, hv);
        RightMemory rm = node.b_posneg().alpha_mem_.right_mems;
        while (rm != null) {
            boolean failed_a_test = false;
            ReteTest rt = node.b_posneg().other_tests;
            while (rt != null) {
                if (!ReteTestRoutines.match_left_and_right(rt, New, rm.w)) {
                    failed_a_test = true;
                    break;
                }
                rt = rt.next;
            }
            if (!failed_a_test) {
                RightToken.create(node, null, rm.w, New);
            }
            rm = rm.next_in_am;
        }
        if (!New.hasNegRightTokens()) {
            ReteNode child = node.first_child;
            while (child != null) {
                this.executeLeftAddition(child, New, null);
                child = child.next_sibling;
            }
        }
    }

    private void negative_node_right_addition(ReteNode node, WmeImpl w) {
        IdentifierImpl referent = w.id;
        int hv = node.node_id ^ referent.hash_id;
        LeftToken tok = this.left_ht.left_ht_bucket(hv);
        while (tok != null) {
            if (tok.node == node && tok.referent == referent) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, tok, w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    RightToken.create(node, null, w, tok);
                    while (tok.first_child != null) {
                        this.remove_token_and_subtree(tok.first_child);
                    }
                }
            }
            tok = tok.next_in_bucket;
        }
    }

    private void unhashed_negative_node_right_addition(ReteNode node, WmeImpl w) {
        int hv = node.node_id;
        LeftToken tok = this.left_ht.left_ht_bucket(hv);
        while (tok != null) {
            if (tok.node == node) {
                boolean failed_a_test = false;
                ReteTest rt = node.b_posneg().other_tests;
                while (rt != null) {
                    if (!ReteTestRoutines.match_left_and_right(rt, tok, w)) {
                        failed_a_test = true;
                        break;
                    }
                    rt = rt.next;
                }
                if (!failed_a_test) {
                    RightToken.create(node, null, w, tok);
                    while (tok.first_child != null) {
                        this.remove_token_and_subtree(tok.first_child);
                    }
                }
            }
            tok = tok.next_in_bucket;
        }
    }

    private void cn_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        int hv = node.node_id ^ Rete.addressOf(tok) ^ Rete.addressOf(w);
        LeftToken t = this.left_ht.left_ht_bucket(hv);
        while (t != null) {
            if (t.node == node && t.parent == tok && t.w == w) {
                return;
            }
            t = t.next_in_bucket;
        }
        LeftToken New = new LeftToken(node, tok, w, null);
        this.left_ht.insert_token_into_left_ht(New, hv);
        ReteNode child = node.first_child;
        while (child != null) {
            this.executeLeftAddition(child, New, null);
            child = child.next_sibling;
        }
    }

    private void cn_partner_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        ReteNode partner = node.b_cn().partner;
        RightToken negrm_tok = RightToken.create(node, tok, w, null);
        for (ReteNode temp = node.parent; temp != partner.parent; temp = temp.real_parent_node()) {
            w = tok.w;
            tok = tok.parent;
        }
        int hv = partner.node_id ^ Rete.addressOf(tok) ^ Rete.addressOf(w);
        LeftToken left = null;
        LeftToken tempLeft = this.left_ht.left_ht_bucket(hv);
        while (tempLeft != null) {
            if (tempLeft.node == partner && tempLeft.parent == tok && tempLeft.w == w) {
                left = tempLeft;
                break;
            }
            tempLeft = tempLeft.next_in_bucket;
        }
        if (left == null) {
            left = new LeftToken(partner, tok, w, null);
            this.left_ht.insert_token_into_left_ht(left, hv);
        }
        negrm_tok.setLeftToken(left);
        while (left.first_child != null) {
            this.remove_token_and_subtree(left.first_child);
        }
    }

    private void p_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        LeftToken New = new LeftToken(node, tok, w, null);
        this.listener.p_node_left_addition(this, node, tok, w);
    }

    void remove_token_and_subtree(Token root) {
        Token tok = root;
        while (true) {
            Object t;
            if (tok.first_child != null) {
                tok = tok.first_child;
                continue;
            }
            Token next_value_for_tok = tok.getNextSiblingOrParent();
            ReteNode node = tok.node;
            tok.removeFromNode();
            tok.removeFromParent();
            tok.removeFromWme();
            ReteNodeType node_type = node.node_type;
            if (node_type == ReteNodeType.MP_BNODE || node_type == ReteNodeType.UNHASHED_MP_BNODE) {
                LeftToken lt = (LeftToken)tok;
                int hv = node.node_id ^ (lt.referent != null ? lt.referent.hash_id : 0);
                this.left_ht.remove_token_from_left_ht(lt, hv);
                if (!node.mp_bnode_is_left_unlinked() && node.a_np().tokens == null) {
                    node.unlink_from_right_mem();
                }
            } else if (node_type == ReteNodeType.P_BNODE) {
                this.listener.p_node_left_removal(this, node, tok.parent, tok.w);
            } else if (node_type == ReteNodeType.NEGATIVE_BNODE || node_type == ReteNodeType.UNHASHED_NEGATIVE_BNODE) {
                LeftToken lt = (LeftToken)tok;
                int hv = node.node_id ^ (lt.referent != null ? lt.referent.hash_id : 0);
                this.left_ht.remove_token_from_left_ht(lt, hv);
                if (node.a_np().tokens == null) {
                    node.unlink_from_right_mem();
                }
                t = lt.getFirstNegRightToken();
                while (t != null) {
                    ((RightToken)((ListItem)t).item).removeFromWme();
                    t = ((ListItem)t).next;
                }
            } else if (node_type == ReteNodeType.MEMORY_BNODE || node_type == ReteNodeType.UNHASHED_MEMORY_BNODE) {
                LeftToken lt = (LeftToken)tok;
                int hv = node.node_id ^ (lt.referent != null ? lt.referent.hash_id : 0);
                this.left_ht.remove_token_from_left_ht(lt, hv);
                if (node.a_np().tokens == null) {
                    ListItem next = null;
                    ListItem child = node.b_mem().first_linked_child.first;
                    while (child != null) {
                        next = ((ReteNode)child.item).a_pos().from_beta_mem.next;
                        ((ReteNode)child.item).unlink_from_right_mem();
                        child = next;
                    }
                }
            } else if (node_type == ReteNodeType.CN_BNODE) {
                int hv = node.node_id ^ Rete.addressOf(tok.parent) ^ Rete.addressOf(tok.w);
                this.left_ht.remove_token_from_left_ht((LeftToken)tok, hv);
                ListItem<RightToken> it = ((LeftToken)tok).getFirstNegRightToken();
                while (it != null) {
                    t = (Token)it.item;
                    ((Token)t).removeFromWme();
                    ((Token)t).removeFromNode();
                    ((Token)t).removeFromParent();
                    it = it.next;
                }
            } else if (node_type == ReteNodeType.CN_PARTNER_BNODE) {
                RightToken rt = (RightToken)tok;
                LeftToken left = rt.getLeftToken();
                left.removeNegRightToken(rt);
                if (!left.hasNegRightTokens()) {
                    ReteNode child = left.node.first_child;
                    while (child != null) {
                        this.executeLeftAddition(child, left, null);
                        child = child.next_sibling;
                    }
                }
            } else {
                throw new IllegalStateException("Internal error: bad node type " + (Object)((Object)node.node_type) + " in remove_token_and_subtree");
            }
            if (tok == root) break;
            tok = next_value_for_tok;
        }
    }

    public ConditionsAndNots p_node_to_conditions_and_nots(ReteNode p_node, Token tok, WmeImpl w, boolean doRhs) {
        ConditionsAndNots result = new ConditionsAndNots();
        Production prod = p_node.b_p().prod;
        if (tok == null) {
            w = null;
        }
        this.syms.getVariableGenerator().reset(null, null);
        ReteNodeToConditionsResult rntc = this.rete_node_to_conditions(p_node.parent, p_node.b_p().parents_nvn, this.dummy_top_node, tok, w, null);
        result.top = rntc.dest_top_cond;
        result.bottom = rntc.dest_bottom_cond;
        if (tok != null) {
            result.nots = rntc.nots_found_in_production;
        }
        rntc.nots_found_in_production = null;
        if (doRhs) {
            this.highest_rhs_unboundvar_index = -1;
            if (!prod.getRhsUnboundVariables().isEmpty()) {
                int i = 0;
                for (SymbolImpl symbolImpl : prod.getRhsUnboundVariables()) {
                    this.rhs_variable_bindings[i++] = symbolImpl;
                    ++this.highest_rhs_unboundvar_index;
                }
            }
            result.actions = Action.copy_action_list_and_substitute_varnames(this, prod.getFirstAction(), result.bottom);
            int index = 0;
            while (index <= this.highest_rhs_unboundvar_index) {
                this.rhs_variable_bindings[index++] = null;
            }
        }
        return result;
    }

    Test add_varnames_to_test(Object vn, Test t) {
        if (vn == null) {
            return t;
        }
        if (VarNames.varnames_is_one_var(vn)) {
            EqualityTest New = SymbolImpl.makeEqualityTest(VarNames.varnames_to_one_var(vn));
            t = Tests.add_new_test_to_test(t, New);
        } else {
            for (Variable c : VarNames.varnames_to_var_list(vn)) {
                EqualityTest New = SymbolImpl.makeEqualityTest(c);
                t = Tests.add_new_test_to_test(t, New);
            }
        }
        return t;
    }

    void add_rete_test_list_to_tests(ThreeFieldCondition cond, ReteTest rtIn) {
        ReteTest rt = rtIn;
        while (rt != null) {
            SymbolImpl referent;
            int test_type;
            Test New = null;
            if (rt.type == 48) {
                New = GoalIdTest.INSTANCE;
            } else if (rt.type == 49) {
                New = ImpasseIdTest.INSTANCE;
            } else if (rt.type == 32) {
                New = new DisjunctionTest(rt.disjunction_list);
            } else if (rt.test_is_constant_relational_test()) {
                test_type = ReteBuilder.relational_test_type_to_test_type[rt.kind_of_relational_test()];
                referent = rt.constant_referent;
                New = test_type == 254 ? SymbolImpl.makeEqualityTest(referent) : new RelationalTest(test_type, referent);
            } else if (rt.test_is_variable_relational_test()) {
                test_type = ReteBuilder.relational_test_type_to_test_type[rt.kind_of_relational_test()];
                if (rt.variable_referent.levels_up == 0) {
                    if (rt.variable_referent.field_num == 0) {
                        if (!Tests.test_includes_equality_test_for_symbol(cond.id_test, null)) {
                            cond.id_test = this.add_gensymmed_equality_test(cond.id_test, 's');
                        }
                    } else if (rt.variable_referent.field_num == 1) {
                        if (!Tests.test_includes_equality_test_for_symbol(cond.attr_test, null)) {
                            cond.attr_test = this.add_gensymmed_equality_test(cond.attr_test, 'a');
                        }
                    } else if (!Tests.test_includes_equality_test_for_symbol(cond.value_test, null)) {
                        cond.value_test = this.add_gensymmed_equality_test(cond.value_test, Tests.first_letter_from_test(cond.attr_test));
                    }
                }
                referent = Rete.var_bound_in_reconstructed_conds(cond, rt.variable_referent.field_num, rt.variable_referent.levels_up);
                New = test_type == 254 ? SymbolImpl.makeEqualityTest(referent) : new RelationalTest(test_type, referent);
            } else {
                throw new IllegalStateException("Error: bad test_type in add_rete_test_to_test");
            }
            if (rt.right_field_num == 0) {
                cond.id_test = Tests.add_new_test_to_test(cond.id_test, New);
            } else if (rt.right_field_num == 2) {
                cond.value_test = Tests.add_new_test_to_test(cond.value_test, New);
            } else {
                cond.attr_test = Tests.add_new_test_to_test(cond.attr_test, New);
            }
            rt = rt.next;
        }
    }

    NotStruct collect_nots(ReteTest rt, WmeImpl right_wme, Condition cond, NotStruct nots_found_in_production) {
        while (rt != null) {
            SymbolImpl right_sym;
            if (rt.test_is_not_equal_test() && (right_sym = right_wme.getField(rt.right_field_num)).asIdentifier() != null) {
                NotStruct new_not;
                SymbolImpl referent;
                if (rt.type == 1) {
                    referent = rt.constant_referent;
                    if (referent.asIdentifier() != null) {
                        new_not = new NotStruct(right_sym.asIdentifier(), referent.asIdentifier());
                        new_not.next = nots_found_in_production;
                        nots_found_in_production = new_not;
                    }
                } else if (rt.type == 17 && (referent = Rete.var_bound_in_reconstructed_conds(cond, rt.variable_referent.field_num, rt.variable_referent.levels_up)).asIdentifier() != null) {
                    new_not = new NotStruct(right_sym.asIdentifier(), referent.asIdentifier());
                    new_not.next = nots_found_in_production;
                    nots_found_in_production = new_not;
                }
            }
            rt = rt.next;
        }
        return nots_found_in_production;
    }

    void add_hash_info_to_id_test(ThreeFieldCondition cond, int field_num, int levels_up) {
        SymbolImpl temp = Rete.var_bound_in_reconstructed_conds(cond, field_num, levels_up);
        EqualityTest New = SymbolImpl.makeEqualityTest(temp);
        cond.id_test = Tests.add_new_test_to_test(cond.id_test, New);
    }

    ReteNodeToConditionsResult rete_node_to_conditions(ReteNode node, NodeVarNames nvn, ReteNode cutoff, Token tok, WmeImpl w, Condition conds_for_cutoff_and_up) {
        ReteNodeToConditionsResult result = new ReteNodeToConditionsResult();
        Condition cond = node.node_type == ReteNodeType.CN_BNODE ? new ConjunctiveNegationCondition() : (node.node_type.bnode_is_positive() ? new PositiveCondition() : new NegativeCondition(new PositiveCondition()));
        if (node.real_parent_node() == cutoff) {
            cond.prev = conds_for_cutoff_and_up;
            result.dest_top_cond = cond;
        } else {
            ReteNodeToConditionsResult sub = this.rete_node_to_conditions(node.real_parent_node(), nvn != null ? nvn.parent : null, cutoff, tok != null ? tok.parent : null, tok != null ? tok.w : null, conds_for_cutoff_and_up);
            result.dest_top_cond = sub.dest_top_cond;
            cond.prev = sub.dest_bottom_cond;
            if (sub.nots_found_in_production != null) {
                NotStruct tail = sub.nots_found_in_production;
                while (tail.next != null) {
                    tail = tail.next;
                }
                tail.next = result.nots_found_in_production;
                result.nots_found_in_production = sub.nots_found_in_production;
            }
            cond.prev.next = cond;
        }
        cond.next = null;
        result.dest_bottom_cond = cond;
        if (node.node_type == ReteNodeType.CN_BNODE) {
            ConjunctiveNegationCondition ncc = cond.asConjunctiveNegationCondition();
            ReteNodeToConditionsResult sub = this.rete_node_to_conditions(node.b_cn().partner.parent, nvn != null ? nvn.bottom_of_subconditions : null, node.parent, null, null, cond.prev);
            ncc.top = sub.dest_top_cond;
            ncc.bottom = sub.dest_bottom_cond;
            if (sub.nots_found_in_production != null) {
                NotStruct tail = sub.nots_found_in_production;
                while (tail.next != null) {
                    tail = tail.next;
                }
                tail.next = result.nots_found_in_production;
                result.nots_found_in_production = sub.nots_found_in_production;
            }
            ncc.top.prev = null;
        } else if (w != null && cond.asPositiveCondition() != null) {
            PositiveCondition pc = cond.asPositiveCondition();
            pc.id_test = SymbolImpl.makeEqualityTest(w.id);
            pc.attr_test = SymbolImpl.makeEqualityTest(w.attr);
            pc.value_test = SymbolImpl.makeEqualityTest(w.value);
            pc.test_for_acceptable_preference = w.acceptable;
            pc.bt().wme_ = w;
            if (node.b_posneg().other_tests != null) {
                result.nots_found_in_production = this.collect_nots(node.b_posneg().other_tests, w, cond, result.nots_found_in_production);
            }
        } else {
            ThreeFieldCondition tfc = cond.asThreeFieldCondition();
            AlphaMemory am = node.b_posneg().alpha_mem_;
            tfc.id_test = SymbolImpl.makeEqualityTest(am.id);
            tfc.attr_test = SymbolImpl.makeEqualityTest(am.attr);
            tfc.value_test = SymbolImpl.makeEqualityTest(am.value);
            tfc.test_for_acceptable_preference = am.acceptable;
            if (nvn != null) {
                tfc.id_test = this.add_varnames_to_test(nvn.fields.id_varnames, tfc.id_test);
                tfc.attr_test = this.add_varnames_to_test(nvn.fields.attr_varnames, tfc.attr_test);
                tfc.value_test = this.add_varnames_to_test(nvn.fields.value_varnames, tfc.value_test);
            }
            if (node.node_type == ReteNodeType.MP_BNODE || node.node_type == ReteNodeType.NEGATIVE_BNODE) {
                this.add_hash_info_to_id_test(tfc, node.left_hash_loc_field_num, node.left_hash_loc_levels_up);
            } else if (node.node_type == ReteNodeType.POSITIVE_BNODE) {
                this.add_hash_info_to_id_test(tfc, node.parent.left_hash_loc_field_num, node.parent.left_hash_loc_levels_up);
            }
            if (node.b_posneg().other_tests != null) {
                this.add_rete_test_list_to_tests(tfc, node.b_posneg().other_tests);
            }
            if (nvn == null) {
                if (!Tests.test_includes_equality_test_for_symbol(tfc.id_test, null)) {
                    tfc.id_test = this.add_gensymmed_equality_test(tfc.id_test, 's');
                }
                if (!Tests.test_includes_equality_test_for_symbol(tfc.attr_test, null)) {
                    tfc.attr_test = this.add_gensymmed_equality_test(tfc.attr_test, 'a');
                }
                if (!Tests.test_includes_equality_test_for_symbol(tfc.value_test, null)) {
                    tfc.value_test = this.add_gensymmed_equality_test(tfc.value_test, Tests.first_letter_from_test(tfc.attr_test));
                }
            }
        }
        return result;
    }

    public static void print_whole_token_wme(Printer printer, WmeImpl w, Trace.WmeTraceType wtt) {
        if (w != null) {
            if (wtt == Trace.WmeTraceType.TIMETAG) {
                printer.print("%d", w.timetag);
            } else if (wtt == Trace.WmeTraceType.FULL) {
                printer.print("%s", w);
            }
            if (wtt != Trace.WmeTraceType.NONE) {
                printer.print(" ");
            }
        }
    }

    void print_whole_token(Printer printer, Token t, Trace.WmeTraceType wtt) {
        if (t == this.dummy_top_token) {
            return;
        }
        this.print_whole_token(printer, t.parent, wtt);
        Rete.print_whole_token_wme(printer, t.w, wtt);
    }

    private void dummy_matches_node_left_addition(ReteNode node, Token tok, WmeImpl w) {
        assert (node.node_type == ReteNodeType.DUMMY_MATCHES_BNODE);
        Token New = Token.createMatchesToken(tok, w);
        New.next_of_node = this.dummy_matches_node_tokens;
        this.dummy_matches_node_tokens = New;
    }

    private Token get_all_left_tokens_emerging_from_node(ReteNode node) {
        this.dummy_matches_node_tokens = null;
        ReteNode dummy = ReteNode.createMatchesNode(node);
        this.update_node_with_matches_from_above(dummy);
        Token result = this.dummy_matches_node_tokens;
        this.dummy_matches_node_tokens = null;
        return result;
    }

    private int ppmi_aux(Printer printer, ReteNode node, ReteNode cutoff, Condition cond, Trace.WmeTraceType wtt, int indent, boolean showNodeIds) {
        int matches_at_this_level = this.getMatchCountForNode(node);
        if (node == cutoff) {
            return matches_at_this_level;
        }
        ReteNode parent = node.real_parent_node();
        int matches_one_level_up = this.ppmi_aux(printer, parent, cutoff, cond.prev, wtt, indent, showNodeIds);
        String match_count_string = "";
        if (matches_one_level_up == 0) {
            match_count_string = "    ";
        } else if (matches_at_this_level == 0) {
            match_count_string = ">>>>";
        } else {
            match_count_string = String.format("%4d", matches_at_this_level);
            if (showNodeIds) {
                match_count_string = match_count_string + String.format(" %10s", "(" + Integer.toHexString(System.identityHashCode(node)) + ")");
            }
        }
        printer.spaces(indent);
        ConjunctiveNegationCondition ncc = cond.asConjunctiveNegationCondition();
        if (ncc != null) {
            printer.print("    -{\n");
            this.ppmi_aux(printer, node.b_cn().partner.real_parent_node(), parent, ncc.bottom, wtt, indent + 5, showNodeIds);
            printer.spaces(indent).print("%s }\n", match_count_string);
        } else {
            printer.print("%s%s\n", match_count_string, cond);
            if (matches_one_level_up != 0 && matches_at_this_level == 0 && wtt != Trace.WmeTraceType.NONE) {
                Token parent_tokens;
                printer.spaces(indent).print("*** Matches For Left ***\n");
                Token t = parent_tokens = this.get_all_left_tokens_emerging_from_node(parent);
                while (t != null) {
                    printer.spaces(indent);
                    this.print_whole_token(printer, t, wtt);
                    printer.print("\n");
                    t = t.next_of_node;
                }
                printer.spaces(indent).print("*** Matches for Right ***\n").spaces(indent);
                RightMemory rm = node.b_posneg().alpha_mem_.right_mems;
                while (rm != null) {
                    if (wtt == Trace.WmeTraceType.TIMETAG) {
                        printer.print("%d", rm.w.timetag);
                    } else if (wtt == Trace.WmeTraceType.FULL) {
                        printer.print("%s", rm.w);
                    }
                    printer.print(" ");
                    rm = rm.next_in_am;
                }
                printer.print("\n");
            }
        }
        return matches_at_this_level;
    }

    public void print_partial_match_information(Printer printer, ReteNode p_node, Trace.WmeTraceType wtt, boolean showNodeIds) {
        ConditionsAndNots cans = this.p_node_to_conditions_and_nots(p_node, null, null, false);
        int n = this.ppmi_aux(printer, p_node.parent, this.dummy_top_node, cans.bottom, wtt, 0, showNodeIds);
        printer.print("\n%d complete matches.\n", n);
        if (n != 0 && wtt != Trace.WmeTraceType.NONE) {
            Token tokens;
            printer.print("*** Complete Matches ***\n");
            Token t = tokens = this.get_all_left_tokens_emerging_from_node(p_node.parent);
            while (t != null) {
                this.print_whole_token(printer, t, wtt);
                printer.print("\n");
                t = t.next_of_node;
            }
        }
    }

    private List<PartialMatches.Entry> getPartialMatchesAux(List<PartialMatches.Entry> entries, ReteNode node, ReteNode cutoff, Condition cond) {
        int matches_at_this_level = this.getMatchCountForNode(node);
        if (node == cutoff) {
            return entries;
        }
        ReteNode parent = node.real_parent_node();
        this.getPartialMatchesAux(entries, parent, cutoff, cond.prev);
        ConjunctiveNegationCondition ncc = cond.asConjunctiveNegationCondition();
        if (ncc != null) {
            entries.add(new PartialMatches.Entry(cond, matches_at_this_level, this.getPartialMatchesAux(new ArrayList<PartialMatches.Entry>(), node.b_cn().partner.real_parent_node(), parent, ncc.bottom)));
        } else {
            entries.add(new PartialMatches.Entry(cond, matches_at_this_level, null));
        }
        return entries;
    }

    public PartialMatches getPartialMatches(ReteNode p_node) {
        ConditionsAndNots cans = this.p_node_to_conditions_and_nots(p_node, null, null, false);
        List<PartialMatches.Entry> entries = this.getPartialMatchesAux(new ArrayList<PartialMatches.Entry>(), p_node.parent, this.dummy_top_node, cans.bottom);
        return new PartialMatches(entries);
    }

    private int getMatchCountForNode(ReteNode node) {
        Token tokens = this.get_all_left_tokens_emerging_from_node(node);
        int matches_at_this_level = 0;
        Token t = tokens;
        while (t != null) {
            ++matches_at_this_level;
            t = t.next_of_node;
        }
        return matches_at_this_level;
    }

    public int count_rete_tokens_for_production(ReteNode p_node) {
        if (p_node == null) {
            return 0;
        }
        ReteNode node = p_node.parent;
        int count = 0;
        while (node != this.dummy_top_node) {
            if (node.node_type != ReteNodeType.POSITIVE_BNODE && node.node_type != ReteNodeType.UNHASHED_POSITIVE_BNODE) {
                Token tok = node.a_np().tokens;
                while (tok != null) {
                    ++count;
                    tok = tok.next_of_node;
                }
            }
            if (node.node_type == ReteNodeType.CN_BNODE) {
                node = node.b_cn().partner.parent;
                continue;
            }
            node = node.parent;
        }
        return count;
    }
}

