/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import java.util.Arrays;
import java.util.List;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.ConjunctiveNegationCondition;
import org.jsoar.kernel.lhs.ConjunctiveTest;
import org.jsoar.kernel.lhs.DisjunctionTest;
import org.jsoar.kernel.lhs.EqualityTest;
import org.jsoar.kernel.lhs.GoalIdTest;
import org.jsoar.kernel.lhs.ImpasseIdTest;
import org.jsoar.kernel.lhs.NegativeCondition;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.RelationalTest;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.rete.AlphaMemory;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.ReteNode;
import org.jsoar.kernel.rete.ReteNodeType;
import org.jsoar.kernel.rete.ReteTest;
import org.jsoar.kernel.rete.VarLocation;
import org.jsoar.kernel.rhs.ReteLocation;
import org.jsoar.kernel.rhs.RhsFunctionCall;
import org.jsoar.kernel.rhs.RhsSymbolValue;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.rhs.UnboundVariable;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.Arguments;
import org.jsoar.util.ByRef;
import org.jsoar.util.ListHead;
import org.jsoar.util.markers.Marker;

class ReteBuilder {
    static final int EQUAL_TEST_TYPE = 254;
    private static final int ERROR_TEST_TYPE = 255;
    private static final int[] test_type_to_relational_test_type = new int[256];
    static final int[] relational_test_type_to_test_type;

    private ReteBuilder() {
    }

    static void add_rete_tests_for_test(Rete rete, Test t, int current_depth, int field_num, ByRef<ReteTest> rt, ByRef<SymbolImpl> alpha_constant) {
        if (Tests.isBlank(t)) {
            return;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            SymbolImpl referent = eq.getReferent();
            if (referent.asVariable() == null && alpha_constant.value == null) {
                alpha_constant.value = referent;
                return;
            }
            if (referent.asVariable() == null) {
                ReteTest new_rt = ReteTest.createConstantTest(0, field_num, referent);
                new_rt.next = (ReteTest)rt.value;
                rt.value = new_rt;
                return;
            }
            VarLocation where = VarLocation.find(referent.asVariable(), current_depth);
            if (where == null) {
                throw new IllegalStateException("Error: Rete build found test of unbound var: " + referent);
            }
            if (where.levels_up == 0 && where.field_num == field_num) {
                return;
            }
            ReteTest new_rt = ReteTest.createVariableTest(0, field_num, where);
            new_rt.next = (ReteTest)rt.value;
            rt.value = new_rt;
            return;
        }
        RelationalTest relational = t.asRelationalTest();
        if (relational != null) {
            if (relational.referent.asVariable() == null) {
                ReteTest new_rt = ReteTest.createConstantTest(test_type_to_relational_test_type[relational.type], field_num, relational.referent);
                new_rt.next = (ReteTest)rt.value;
                rt.value = new_rt;
                return;
            }
            VarLocation where = VarLocation.find(relational.referent.asVariable(), current_depth);
            if (where == null) {
                throw new IllegalStateException("Error: Rete build found test of unbound var: " + relational.referent);
            }
            ReteTest new_rt = ReteTest.createVariableTest(test_type_to_relational_test_type[relational.type], field_num, where);
            new_rt.next = (ReteTest)rt.value;
            rt.value = new_rt;
            return;
        }
        DisjunctionTest dt = t.asDisjunctionTest();
        if (dt != null) {
            ReteTest new_rt = ReteTest.createDisjunctionTest(field_num, dt.disjunction_list);
            new_rt.next = (ReteTest)rt.value;
            rt.value = new_rt;
            return;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test c : ct.conjunct_list) {
                ReteBuilder.add_rete_tests_for_test(rete, c, current_depth, field_num, rt, alpha_constant);
            }
            return;
        }
        GoalIdTest gid = t.asGoalIdTest();
        if (gid != null) {
            ReteTest new_rt = ReteTest.createGoalIdTest();
            new_rt.next = (ReteTest)rt.value;
            rt.value = new_rt;
            return;
        }
        ImpasseIdTest iid = t.asImpasseIdTest();
        if (iid != null) {
            ReteTest new_rt = ReteTest.createImpasseIdTest();
            new_rt.next = (ReteTest)rt.value;
            rt.value = new_rt;
            return;
        }
        throw new IllegalStateException("Error: found unknown test type while building rete: " + t);
    }

    private static boolean single_rete_tests_are_identical(ReteTest rt1, ReteTest rt2) {
        if (rt1.type != rt2.type) {
            return false;
        }
        if (rt1.right_field_num != rt2.right_field_num) {
            return false;
        }
        if (rt1.test_is_variable_relational_test()) {
            return VarLocation.var_locations_equal(rt1.variable_referent, rt2.variable_referent);
        }
        if (rt1.test_is_constant_relational_test()) {
            return rt1.constant_referent == rt2.constant_referent;
        }
        if (rt1.type == 48) {
            return true;
        }
        if (rt1.type == 49) {
            return true;
        }
        if (rt1.type == 32) {
            return rt1.disjunction_list.equals(rt2.disjunction_list);
        }
        throw new IllegalStateException("Error: found unknown rete test type while building rete: " + rt1 + ", " + rt2);
    }

    private static boolean rete_test_lists_are_identical(ReteTest rt1, ReteTest rt2) {
        while (rt1 != null && rt2 != null) {
            if (!ReteBuilder.single_rete_tests_are_identical(rt1, rt2)) {
                return false;
            }
            rt1 = rt1.next;
            rt2 = rt2.next;
        }
        return rt1 == rt2;
    }

    private static boolean extract_rete_test_to_hash_with(ByRef<ReteTest> rt, ByRef<VarLocation> dest_hash_loc) {
        ReteTest current = null;
        ReteTest prev = null;
        current = (ReteTest)rt.value;
        while (current != null && current.type != 16) {
            prev = current;
            current = current.next;
        }
        if (current == null) {
            dest_hash_loc.value = VarLocation.DEFAULT;
            return false;
        }
        if (prev != null) {
            prev.next = current.next;
        } else {
            rt.value = current.next;
        }
        dest_hash_loc.value = current.variable_referent;
        current.next = null;
        return true;
    }

    private static ReteNode make_node_for_positive_cond(Rete rete, PositiveCondition cond, int current_depth, ReteNode parent) {
        ReteNodeType mp_node_type;
        ReteNodeType mem_node_type;
        ReteNodeType pos_node_type;
        Arguments.checkNotNull(rete, "rete");
        Arguments.checkNotNull(cond, "cond");
        Arguments.check(current_depth >= 0, "current_depth >= 0");
        Arguments.checkNotNull(parent, "parent");
        ListHead<Variable> vars_bound_here = ListHead.newInstance();
        Tests.bind_variables_in_test(cond.id_test, current_depth, 0, false, vars_bound_here);
        Tests.bind_variables_in_test(cond.attr_test, current_depth, 1, false, vars_bound_here);
        Tests.bind_variables_in_test(cond.value_test, current_depth, 2, false, vars_bound_here);
        ByRef<Object> alpha_id = ByRef.create(null);
        ByRef<Object> alpha_attr = ByRef.create(null);
        ByRef<Object> alpha_value = ByRef.create(null);
        ByRef<Object> rt = ByRef.create(null);
        ReteBuilder.add_rete_tests_for_test(rete, cond.id_test, current_depth, 0, rt, alpha_id);
        ByRef<Object> left_hash_loc = ByRef.create(null);
        boolean hash_this_node = ReteBuilder.extract_rete_test_to_hash_with(rt, left_hash_loc);
        ReteBuilder.add_rete_tests_for_test(rete, cond.attr_test, current_depth, 1, rt, alpha_attr);
        ReteBuilder.add_rete_tests_for_test(rete, cond.value_test, current_depth, 2, rt, alpha_value);
        Variable.pop_bindings_and_deallocate_list_of_variables(vars_bound_here);
        AlphaMemory am = rete.find_or_make_alpha_mem((SymbolImpl)alpha_id.value, (SymbolImpl)alpha_attr.value, (SymbolImpl)alpha_value.value, cond.test_for_acceptable_preference);
        if (hash_this_node) {
            pos_node_type = ReteNodeType.POSITIVE_BNODE;
            mem_node_type = ReteNodeType.MEMORY_BNODE;
            mp_node_type = ReteNodeType.MP_BNODE;
        } else {
            pos_node_type = ReteNodeType.UNHASHED_POSITIVE_BNODE;
            mem_node_type = ReteNodeType.UNHASHED_MEMORY_BNODE;
            mp_node_type = ReteNodeType.UNHASHED_MP_BNODE;
        }
        ReteNode mem_node = parent.first_child;
        while (mem_node != null && (mem_node.node_type != mem_node_type || hash_this_node && (mem_node.left_hash_loc_field_num != ((VarLocation)left_hash_loc.value).field_num || mem_node.left_hash_loc_levels_up != ((VarLocation)left_hash_loc.value).levels_up))) {
            mem_node = mem_node.next_sibling;
        }
        if (mem_node != null) {
            ReteNode node = mem_node.first_child;
            while (!(node == null || node.node_type == pos_node_type && am == node.b_posneg().alpha_mem_ && ReteBuilder.rete_test_lists_are_identical(node.b_posneg().other_tests, (ReteTest)rt.value))) {
                node = node.next_sibling;
            }
            if (node != null) {
                rt.value = null;
                am.remove_ref_to_alpha_mem(rete);
                return node;
            }
            node = ReteNode.make_new_positive_node(rete, mem_node, pos_node_type, am, (ReteTest)rt.value, false);
            return node;
        }
        ReteNode mp_node = parent.first_child;
        while (mp_node != null && (mp_node.node_type != mp_node_type || hash_this_node && (mp_node.left_hash_loc_field_num != ((VarLocation)left_hash_loc.value).field_num || mp_node.left_hash_loc_levels_up != ((VarLocation)left_hash_loc.value).levels_up))) {
            mp_node = mp_node.next_sibling;
        }
        if (mp_node != null) {
            if (am == mp_node.b_posneg().alpha_mem_ && ReteBuilder.rete_test_lists_are_identical(mp_node.b_posneg().other_tests, (ReteTest)rt.value)) {
                rt.value = null;
                am.remove_ref_to_alpha_mem(rete);
                return mp_node;
            }
            mem_node = ReteNode.split_mp_node(rete, mp_node);
            ReteNode node = ReteNode.make_new_positive_node(rete, mem_node, pos_node_type, am, (ReteTest)rt.value, false);
            return node;
        }
        return ReteNode.make_new_mp_node(rete, parent, mp_node_type, (VarLocation)left_hash_loc.value, am, (ReteTest)rt.value, false);
    }

    private static ReteNode make_node_for_negative_cond(Rete rete, NegativeCondition cond, int current_depth, ReteNode parent) {
        ListHead<Variable> vars_bound_here = ListHead.newInstance();
        Tests.bind_variables_in_test(cond.id_test, current_depth, 0, false, vars_bound_here);
        Tests.bind_variables_in_test(cond.attr_test, current_depth, 1, false, vars_bound_here);
        Tests.bind_variables_in_test(cond.value_test, current_depth, 2, false, vars_bound_here);
        ByRef<Object> alpha_id = ByRef.create(null);
        ByRef<Object> rt = ByRef.create(null);
        ReteBuilder.add_rete_tests_for_test(rete, cond.id_test, current_depth, 0, rt, alpha_id);
        ByRef<Object> left_hash_loc = ByRef.create(null);
        boolean hash_this_node = ReteBuilder.extract_rete_test_to_hash_with(rt, left_hash_loc);
        ByRef<Object> alpha_attr = ByRef.create(null);
        ReteBuilder.add_rete_tests_for_test(rete, cond.attr_test, current_depth, 1, rt, alpha_attr);
        ByRef<Object> alpha_value = ByRef.create(null);
        ReteBuilder.add_rete_tests_for_test(rete, cond.value_test, current_depth, 2, rt, alpha_value);
        Variable.pop_bindings_and_deallocate_list_of_variables(vars_bound_here);
        AlphaMemory am = rete.find_or_make_alpha_mem((SymbolImpl)alpha_id.value, (SymbolImpl)alpha_attr.value, (SymbolImpl)alpha_value.value, cond.test_for_acceptable_preference);
        ReteNodeType node_type = hash_this_node ? ReteNodeType.NEGATIVE_BNODE : ReteNodeType.UNHASHED_NEGATIVE_BNODE;
        ReteNode node = parent.first_child;
        while (node != null && (node.node_type != node_type || am != node.b_posneg().alpha_mem_ || hash_this_node && (node.left_hash_loc_field_num != ((VarLocation)left_hash_loc.value).field_num || node.left_hash_loc_levels_up != ((VarLocation)left_hash_loc.value).levels_up) || !ReteBuilder.rete_test_lists_are_identical(node.b_posneg().other_tests, (ReteTest)rt.value))) {
            node = node.next_sibling;
        }
        if (node != null) {
            rt.value = null;
            am.remove_ref_to_alpha_mem(rete);
            return node;
        }
        node = ReteNode.make_new_negative_node(rete, parent, node_type, (VarLocation)left_hash_loc.value, am, (ReteTest)rt.value);
        return node;
    }

    static void build_network_for_condition_list(Rete rete, Condition cond_list, int depth_of_first_cond, ReteNode parent, ByRef<ReteNode> dest_bottom_node, ByRef<Integer> dest_bottom_depth, ByRef<ListHead<Variable>> dest_vars_bound) {
        ReteNode node = parent;
        ReteNode new_node = null;
        ByRef<Object> subconditions_bottom_node = ByRef.create(null);
        int current_depth = depth_of_first_cond;
        ListHead<Variable> vars_bound = ListHead.newInstance();
        Condition cond = cond_list;
        while (cond != null) {
            PositiveCondition pc = cond.asPositiveCondition();
            NegativeCondition nc = cond.asNegativeCondition();
            ConjunctiveNegationCondition ncc = cond.asConjunctiveNegationCondition();
            if (pc != null) {
                new_node = ReteBuilder.make_node_for_positive_cond(rete, pc, current_depth, node);
                Tests.bind_variables_in_test(pc.id_test, current_depth, 0, true, vars_bound);
                Tests.bind_variables_in_test(pc.attr_test, current_depth, 1, true, vars_bound);
                Tests.bind_variables_in_test(pc.value_test, current_depth, 2, true, vars_bound);
            } else if (nc != null) {
                new_node = ReteBuilder.make_node_for_negative_cond(rete, nc, current_depth, node);
            } else if (ncc != null) {
                ReteBuilder.build_network_for_condition_list(rete, ncc.top, current_depth, node, subconditions_bottom_node, null, null);
                ReteNode child = node.first_child;
                while (child != null && (child.node_type != ReteNodeType.CN_BNODE || child.b_cn().partner.parent != subconditions_bottom_node.value)) {
                    child = child.next_sibling;
                }
                new_node = child != null ? child : ReteNode.make_new_cn_node(rete, node, (ReteNode)subconditions_bottom_node.value);
            } else {
                throw new IllegalStateException("Unexpected condition type: " + cond);
            }
            node = new_node;
            ++current_depth;
            cond = cond.next;
        }
        if (dest_bottom_node != null) {
            dest_bottom_node.value = node;
        }
        if (dest_bottom_depth != null) {
            dest_bottom_depth.value = current_depth - 1;
        }
        if (dest_vars_bound != null) {
            dest_vars_bound.value = vars_bound;
        } else {
            Variable.pop_bindings_and_deallocate_list_of_variables(vars_bound);
        }
    }

    static RhsValue fixup_rhs_value_variable_references(Rete rete, RhsValue rv, int bottom_depth, List<Variable> rhs_unbound_vars_for_new_prod, Marker rhs_unbound_vars_tc) {
        RhsSymbolValue rvsym = rv.asSymbolValue();
        if (rvsym != null) {
            Variable var = rvsym.getSym().asVariable();
            if (var == null) {
                return rv;
            }
            VarLocation var_loc = VarLocation.find(var, bottom_depth + 1);
            if (var_loc != null) {
                return ReteLocation.create(var_loc.field_num, var_loc.levels_up - 1);
            }
            int index = 0;
            if (var.tc_number != rhs_unbound_vars_tc) {
                index = rhs_unbound_vars_for_new_prod.size();
                rhs_unbound_vars_for_new_prod.add(var);
                var.tc_number = rhs_unbound_vars_tc;
                var.unbound_variable_index = index;
            } else {
                index = var.unbound_variable_index;
            }
            return UnboundVariable.create(index);
        }
        RhsFunctionCall fc = rv.asFunctionCall();
        if (fc != null) {
            List<RhsValue> args = fc.getArguments();
            assert (args == fc.getArguments());
            for (int i = 0; i < args.size(); ++i) {
                RhsValue newV = ReteBuilder.fixup_rhs_value_variable_references(rete, args.get(i), bottom_depth, rhs_unbound_vars_for_new_prod, rhs_unbound_vars_tc);
                args.set(i, newV);
            }
        } else {
            throw new IllegalArgumentException("Unknown value type: " + rv);
        }
        return rv;
    }

    static {
        Arrays.fill(test_type_to_relational_test_type, 255);
        relational_test_type_to_test_type = new int[256];
        Arrays.fill(relational_test_type_to_test_type, 255);
        ReteBuilder.test_type_to_relational_test_type[1] = 1;
        ReteBuilder.test_type_to_relational_test_type[2] = 2;
        ReteBuilder.test_type_to_relational_test_type[3] = 3;
        ReteBuilder.test_type_to_relational_test_type[4] = 4;
        ReteBuilder.test_type_to_relational_test_type[5] = 5;
        ReteBuilder.test_type_to_relational_test_type[6] = 6;
        ReteBuilder.relational_test_type_to_test_type[0] = 254;
        ReteBuilder.relational_test_type_to_test_type[1] = 1;
        ReteBuilder.relational_test_type_to_test_type[2] = 2;
        ReteBuilder.relational_test_type_to_test_type[3] = 3;
        ReteBuilder.relational_test_type_to_test_type[4] = 4;
        ReteBuilder.relational_test_type_to_test_type[5] = 5;
        ReteBuilder.relational_test_type_to_test_type[6] = 6;
    }
}

