/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.ProductionType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.rete.AlphaMemory;
import org.jsoar.kernel.rete.NodeVarNames;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.ReteNetConstants;
import org.jsoar.kernel.rete.ReteNode;
import org.jsoar.kernel.rete.ReteNodeType;
import org.jsoar.kernel.rete.ReteTest;
import org.jsoar.kernel.rete.VarNames;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.FunctionAction;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.ReteLocation;
import org.jsoar.kernel.rhs.RhsFunctionCall;
import org.jsoar.kernel.rhs.RhsSymbolValue;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.rhs.UnboundVariable;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.Arguments;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.properties.PropertyKey;

public class ReteNetWriter {
    private final Agent context;
    private final SymbolFactoryImpl syms;
    private final Rete rete;
    private Map<Symbol, Integer> symbolIndex;
    private Map<AlphaMemory, Integer> amIndex;
    protected final HashSet<PropertyKey<?>> propertiesToInclude = new HashSet<PropertyKey<?>>(){
        {
            this.add(SoarProperties.WAITSNC);
            this.add(SoarProperties.LEARNING_ON);
            this.add(SoarProperties.EXPLAIN);
            this.add(SoarProperties.MAX_ELABORATIONS);
        }
    };

    protected ReteNetWriter(Agent context) {
        Arguments.checkNotNull(context, "context");
        this.context = context;
        this.syms = Adaptables.require(this.getClass(), this.context, SymbolFactoryImpl.class);
        this.rete = Adaptables.require(this.getClass(), context, Rete.class);
    }

    protected void write(OutputStream os) throws IOException, SoarException {
        this.ensureNoJustifications();
        DataOutputStream dos = new DataOutputStream(os);
        try {
            System.gc();
            dos.writeUTF("JSoarCompactReteNet");
            dos.writeInt(1);
            this.writeAllSymbols(dos);
            this.writeAlphaMemories(dos, this.rete.getAllAlphaMemories());
            this.writeChildrenOfNode(dos, this.rete.dummy_top_node);
            this.writeProperties(dos, this.propertiesToInclude);
        }
        finally {
            dos.flush();
        }
    }

    private void ensureNoJustifications() throws SoarException {
        if (!this.context.getProductions().getProductions(ProductionType.JUSTIFICATION).isEmpty()) {
            throw new SoarException("Internal error: cannot save rete net with justifications present.");
        }
    }

    private void writeProperties(DataOutputStream dos, HashSet<PropertyKey<?>> properties) throws IOException, SoarException {
        dos.writeInt(properties.size());
        for (PropertyKey<?> prop : properties) {
            dos.writeUTF(prop.getName());
            if (prop.getType().equals(Boolean.class)) {
                dos.writeBoolean((Boolean)this.context.getProperties().get(prop));
                continue;
            }
            if (prop.getType().equals(Integer.class)) {
                dos.writeInt((Integer)this.context.getProperties().get(prop));
                continue;
            }
            throw new SoarException("Unhandled property type: " + prop.getType());
        }
    }

    private void writeChildrenOfNode(DataOutputStream dos, ReteNode node) throws IOException, SoarException {
        FluentIterable children = this.getChildrenOfNode(node);
        children = children.filter((Predicate)new Predicate<ReteNode>(){

            public boolean apply(ReteNode child) {
                return child.node_type != ReteNodeType.CN_BNODE;
            }
        });
        children = FluentIterable.from((Iterable)children.toList().reverse());
        dos.writeInt(children.size());
        for (ReteNode child : children) {
            this.writeNodeAndChildren(dos, child);
        }
    }

    private FluentIterable<ReteNode> getChildrenOfNode(ReteNode node) {
        ImmutableList.Builder children = ImmutableList.builder();
        ReteNode child = node.first_child;
        while (child != null) {
            children.add((Object)child);
            child = child.next_sibling;
        }
        return FluentIterable.from((Iterable)children.build());
    }

    private void writeNodeAndChildren(DataOutputStream dos, ReteNode node) throws IOException, SoarException {
        dos.writeUTF(node.node_type.toString());
        switch (node.node_type) {
            case MEMORY_BNODE: {
                this.writeLeftHashLoc(dos, node);
            }
            case UNHASHED_MEMORY_BNODE: {
                break;
            }
            case MP_BNODE: {
                this.writeLeftHashLoc(dos, node);
            }
            case UNHASHED_MP_BNODE: {
                dos.writeInt(this.getAlphaMemoryIndex(node.b_posneg().alpha_mem_));
                this.writeTestList(dos, node.b_posneg().other_tests);
                dos.writeBoolean(node.a_np().is_left_unlinked);
                break;
            }
            case POSITIVE_BNODE: 
            case UNHASHED_POSITIVE_BNODE: {
                dos.writeInt(this.getAlphaMemoryIndex(node.b_posneg().alpha_mem_));
                this.writeTestList(dos, node.b_posneg().other_tests);
                dos.writeBoolean(node.node_is_left_unlinked());
                break;
            }
            case NEGATIVE_BNODE: {
                this.writeLeftHashLoc(dos, node);
            }
            case UNHASHED_NEGATIVE_BNODE: {
                dos.writeInt(this.getAlphaMemoryIndex(node.b_posneg().alpha_mem_));
                this.writeTestList(dos, node.b_posneg().other_tests);
                break;
            }
            case CN_PARTNER_BNODE: {
                int i = 0;
                ReteNode temp = node.real_parent_node();
                while (temp != node.b_cn().partner.parent) {
                    temp = temp.real_parent_node();
                    ++i;
                }
                dos.writeInt(i);
                break;
            }
            case P_BNODE: {
                Production prod = node.b_p().prod;
                dos.writeUTF(prod.getName());
                dos.writeUTF(prod.getDocumentation());
                dos.writeUTF(prod.getType().toString());
                dos.writeUTF(prod.getDeclaredSupport().toString());
                this.writeActionList(dos, prod.getFirstAction());
                dos.writeInt(prod.getRhsUnboundVariables().size());
                for (Variable unboundVar : prod.getRhsUnboundVariables()) {
                    dos.writeInt(this.getSymbolIndex(unboundVar));
                }
                if (node.b_p().parents_nvn != null) {
                    dos.writeBoolean(true);
                    this.writeNodeVarNames(dos, node.b_p().parents_nvn, node.parent);
                    break;
                }
                dos.writeBoolean(false);
                break;
            }
            default: {
                throw new SoarException("Unhandled ReteNodeType: " + (Object)((Object)node.node_type));
            }
        }
        if (node.node_type == ReteNodeType.CN_PARTNER_BNODE) {
            node = node.b_cn().partner;
        }
        this.writeChildrenOfNode(dos, node);
    }

    private void writeLeftHashLoc(DataOutputStream dos, ReteNode node) throws IOException {
        dos.writeInt(node.left_hash_loc_field_num);
        dos.writeInt(node.left_hash_loc_levels_up);
    }

    private void writeActionList(DataOutputStream dos, Action firstAction) throws IOException, SoarException {
        int numActions = 0;
        Action a = firstAction;
        while (a != null) {
            ++numActions;
            a = a.next;
        }
        dos.writeInt(numActions);
        a = firstAction;
        while (a != null) {
            this.writeAction(dos, a);
            a = a.next;
        }
    }

    private void writeAction(DataOutputStream dos, Action a) throws IOException, SoarException {
        if (a instanceof MakeAction) {
            dos.writeInt(ReteNetConstants.Action.MAKE_ACTION.ordinal());
        } else if (a instanceof FunctionAction) {
            dos.writeInt(ReteNetConstants.Action.FUNCALL_ACTION.ordinal());
        } else {
            throw new SoarException("Unhandled action type.");
        }
        if (a.preference_type != null) {
            dos.writeBoolean(true);
            dos.writeUTF(a.preference_type.toString());
        } else {
            dos.writeBoolean(false);
        }
        dos.writeUTF(a.support.toString());
        if (a instanceof FunctionAction) {
            this.writeRHSValue(dos, a.asFunctionAction().call);
        } else if (a instanceof MakeAction) {
            this.writeRHSValue(dos, a.asMakeAction().id);
            this.writeRHSValue(dos, a.asMakeAction().attr);
            this.writeRHSValue(dos, a.asMakeAction().value);
            if (a.preference_type != null && a.preference_type.isBinary()) {
                this.writeRHSValue(dos, a.asMakeAction().referent);
            }
        }
    }

    private void writeRHSValue(DataOutputStream dos, RhsValue rv) throws IOException, SoarException {
        if (rv instanceof RhsSymbolValue) {
            dos.writeInt(ReteNetConstants.RHS.RHS_SYMBOL.ordinal());
            SymbolImpl sym = rv.asSymbolValue().getSym();
            dos.writeInt(this.getSymbolIndex(sym));
        } else if (rv instanceof RhsFunctionCall) {
            dos.writeInt(ReteNetConstants.RHS.RHS_FUNCALL.ordinal());
            dos.writeInt(this.getSymbolIndex(rv.asFunctionCall().getName()));
            dos.writeBoolean(rv.asFunctionCall().isStandalone());
            List<RhsValue> arguments = rv.asFunctionCall().getArguments();
            dos.writeInt(arguments.size());
            for (RhsValue value : arguments) {
                this.writeRHSValue(dos, value);
            }
        } else if (rv instanceof ReteLocation) {
            dos.writeInt(ReteNetConstants.RHS.RHS_RETELOC.ordinal());
            dos.writeInt(rv.asReteLocation().getFieldNum());
            dos.writeInt(rv.asReteLocation().getLevelsUp());
        } else if (rv instanceof UnboundVariable) {
            dos.writeInt(ReteNetConstants.RHS.RHS_UNBOUND_VAR.ordinal());
            dos.writeInt(rv.asUnboundVariable().getIndex());
        } else {
            throw new SoarException("Unhandled RHS value");
        }
    }

    private void writeTestList(DataOutputStream dos, ReteTest firstRete) throws IOException, SoarException {
        int numTests = 0;
        ReteTest rt = firstRete;
        while (rt != null) {
            ++numTests;
            rt = rt.next;
        }
        dos.writeInt(numTests);
        rt = firstRete;
        while (rt != null) {
            this.writeTest(dos, rt);
            rt = rt.next;
        }
    }

    private void writeTest(DataOutputStream dos, ReteTest rt) throws IOException, SoarException {
        dos.writeInt(rt.type);
        dos.writeInt(rt.right_field_num);
        if (rt.test_is_constant_relational_test()) {
            dos.writeInt(this.getSymbolIndex(rt.constant_referent));
        } else if (rt.test_is_variable_relational_test()) {
            dos.writeInt(rt.variable_referent.field_num);
            dos.writeInt(rt.variable_referent.levels_up);
        } else if (rt.type == 32) {
            List<SymbolImpl> disjunctions = rt.disjunction_list;
            dos.writeInt(disjunctions.size());
            for (SymbolImpl disjunction : disjunctions) {
                dos.writeInt(this.getSymbolIndex(disjunction));
            }
        } else if (rt.type != 48 && rt.type != 49) {
            throw new SoarException("Unhandled ReteTest: " + rt);
        }
    }

    private void writeAllSymbols(DataOutputStream dos) throws IOException {
        this.symbolIndex = new HashMap<Symbol, Integer>();
        int nextIndex = this.writeSymbolList(dos, 1, this.syms.getSymbols(StringSymbol.class), new SymbolWriter<StringSymbol>(){

            @Override
            public void write(DataOutputStream dos, StringSymbol s) throws IOException {
                dos.writeUTF(s.getValue());
            }
        });
        nextIndex = this.writeSymbolList(dos, nextIndex, this.syms.getSymbols(Variable.class), new SymbolWriter<Variable>(){

            @Override
            public void write(DataOutputStream dos, Variable s) throws IOException {
                dos.writeUTF(s.name);
            }
        });
        nextIndex = this.writeSymbolList(dos, nextIndex, this.syms.getSymbols(IntegerSymbol.class), new SymbolWriter<IntegerSymbol>(){

            @Override
            public void write(DataOutputStream dos, IntegerSymbol s) throws IOException {
                dos.writeLong(s.getValue());
            }
        });
        nextIndex = this.writeSymbolList(dos, nextIndex, this.syms.getSymbols(DoubleSymbol.class), new SymbolWriter<DoubleSymbol>(){

            @Override
            public void write(DataOutputStream dos, DoubleSymbol s) throws IOException {
                dos.writeDouble(s.getValue());
            }
        });
    }

    private <T extends Symbol> int writeSymbolList(DataOutputStream dos, int nextIndex, List<T> symbols, SymbolWriter<T> writer) throws IOException {
        dos.writeInt(symbols.size());
        for (Symbol s : symbols) {
            writer.write(dos, s);
            nextIndex = this.indexSymbol(s, nextIndex);
        }
        return nextIndex;
    }

    private int indexSymbol(Symbol s, int nextIndex) {
        this.symbolIndex.put(s, nextIndex);
        return ++nextIndex;
    }

    private int getSymbolIndex(Symbol s) {
        if (s == null) {
            return 0;
        }
        Integer i = this.symbolIndex.get(s);
        return i != null ? i : 0;
    }

    private void writeAlphaMemories(DataOutputStream dos, List<AlphaMemory> ams) throws IOException {
        this.amIndex = new HashMap<AlphaMemory, Integer>();
        dos.writeInt(ams.size());
        int nextIndex = 1;
        for (AlphaMemory am : ams) {
            this.writeAlphaMemory(dos, am);
            this.amIndex.put(am, nextIndex++);
        }
    }

    private int getAlphaMemoryIndex(AlphaMemory am) throws SoarException {
        if (am == null) {
            throw new SoarException("Alpha memory is null.");
        }
        Integer i = this.amIndex.get(am);
        if (i == null) {
            throw new SoarException("Unknown alpha memory.");
        }
        return i;
    }

    private void writeAlphaMemory(DataOutputStream dos, AlphaMemory am) throws IOException {
        dos.writeInt(this.getSymbolIndex(am.id));
        dos.writeInt(this.getSymbolIndex(am.attr));
        dos.writeInt(this.getSymbolIndex(am.value));
        dos.writeBoolean(am.acceptable);
    }

    private void writeVarNames(DataOutputStream dos, Object varNames) throws IOException {
        if (varNames == null) {
            dos.writeInt(ReteNetConstants.VarName.VARNAME_NULL.ordinal());
        } else if (VarNames.varnames_is_one_var(varNames)) {
            dos.writeInt(ReteNetConstants.VarName.VARNAME_ONE_VAR.ordinal());
            dos.writeInt(this.getSymbolIndex(VarNames.varnames_to_one_var(varNames)));
        } else {
            dos.writeInt(ReteNetConstants.VarName.VARNAME_LIST.ordinal());
            LinkedList<Variable> vars = VarNames.varnames_to_var_list(varNames);
            dos.writeInt(vars.size());
            for (Variable v : vars) {
                dos.writeInt(this.getSymbolIndex(v));
            }
        }
    }

    private void writeNodeVarNames(DataOutputStream dos, NodeVarNames nvn, ReteNode node) throws IOException {
        while (node.node_type != ReteNodeType.DUMMY_TOP_BNODE) {
            if (node.node_type == ReteNodeType.CN_BNODE) {
                node = node.b_cn().partner.parent;
                nvn = nvn.bottom_of_subconditions;
                continue;
            }
            this.writeVarNames(dos, nvn.fields.id_varnames);
            this.writeVarNames(dos, nvn.fields.attr_varnames);
            this.writeVarNames(dos, nvn.fields.value_varnames);
            nvn = nvn.parent;
            node = node.real_parent_node();
        }
        return;
    }

    private static interface SymbolWriter<T> {
        public void write(DataOutputStream var1, T var2) throws IOException;
    }
}

