/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import org.jsoar.kernel.Production;
import org.jsoar.kernel.rete.AReteNodeData;
import org.jsoar.kernel.rete.AlphaMemory;
import org.jsoar.kernel.rete.BReteNodeData;
import org.jsoar.kernel.rete.BetaMemoryNodeData;
import org.jsoar.kernel.rete.ConjunctiveNegationNodeData;
import org.jsoar.kernel.rete.NonPosNodeData;
import org.jsoar.kernel.rete.PosNegNodeData;
import org.jsoar.kernel.rete.PosNodeData;
import org.jsoar.kernel.rete.ProductionNodeData;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rete.ReteNodeType;
import org.jsoar.kernel.rete.ReteTest;
import org.jsoar.kernel.rete.Token;
import org.jsoar.kernel.rete.VarLocation;

public class ReteNode {
    ReteNodeType node_type;
    int left_hash_loc_field_num;
    int left_hash_loc_levels_up;
    int node_id;
    ReteNode parent;
    ReteNode first_child;
    ReteNode next_sibling;
    private AReteNodeData a = null;
    private BReteNodeData b = null;

    private ReteNode(ReteNodeType type, int node_id) {
        this.node_type = type;
        this.node_id = node_id;
        this.a = type.bnode_is_positive() && type != ReteNodeType.P_BNODE ? new PosNodeData(this) : new NonPosNodeData();
        this.b = type == ReteNodeType.P_BNODE ? new ProductionNodeData() : (type == ReteNodeType.CN_BNODE || type == ReteNodeType.CN_PARTNER_BNODE ? new ConjunctiveNegationNodeData() : (type == ReteNodeType.MEMORY_BNODE || type == ReteNodeType.UNHASHED_MEMORY_BNODE ? new BetaMemoryNodeData() : new PosNegNodeData()));
        this.validateUnions();
    }

    private ReteNode(ReteNode other) {
        this.node_type = other.node_type;
        this.left_hash_loc_levels_up = other.left_hash_loc_levels_up;
        this.left_hash_loc_field_num = other.left_hash_loc_field_num;
        this.node_id = other.node_id;
        this.parent = other.parent;
        this.first_child = other.first_child;
        this.next_sibling = other.next_sibling;
        this.a = other.a != null ? other.a.copy() : null;
        this.b = other.b != null ? other.b.copy() : null;
        this.validateUnions();
    }

    private void validateUnions() {
        assert (this.a != null);
        assert (this.b != null);
    }

    public PosNodeData a_pos() {
        return (PosNodeData)this.a;
    }

    public NonPosNodeData a_np() {
        return (NonPosNodeData)this.a;
    }

    public PosNegNodeData b_posneg() {
        return (PosNegNodeData)this.b;
    }

    BetaMemoryNodeData b_mem() {
        return (BetaMemoryNodeData)this.b;
    }

    ConjunctiveNegationNodeData b_cn() {
        return (ConjunctiveNegationNodeData)this.b;
    }

    public ProductionNodeData b_p() {
        return (ProductionNodeData)this.b;
    }

    public ReteNode real_parent_node() {
        return this.node_type.bnode_is_bottom_of_split_mp() ? this.parent.parent : this.parent;
    }

    public boolean node_is_right_unlinked() {
        return this.b_posneg().node_is_right_unlinked;
    }

    private void mark_node_as_right_unlinked() {
        this.b_posneg().node_is_right_unlinked = true;
    }

    void relink_to_right_mem() {
        ReteNode rtrm_ancestor = this.b_posneg().nearest_ancestor_with_same_am;
        while (rtrm_ancestor != null && rtrm_ancestor.node_is_right_unlinked()) {
            rtrm_ancestor = rtrm_ancestor.b_posneg().nearest_ancestor_with_same_am;
        }
        if (rtrm_ancestor != null) {
            ReteNode rtrm_prev = rtrm_ancestor.b_posneg().prev_from_alpha_mem;
            this.b_posneg().next_from_alpha_mem = rtrm_ancestor;
            this.b_posneg().prev_from_alpha_mem = rtrm_prev;
            rtrm_ancestor.b_posneg().prev_from_alpha_mem = this;
            if (rtrm_prev != null) {
                rtrm_prev.b_posneg().next_from_alpha_mem = this;
            } else {
                this.b_posneg().alpha_mem_.beta_nodes = this;
            }
        } else {
            ReteNode rtrm_prev = this.b_posneg().alpha_mem_.last_beta_node;
            this.b_posneg().next_from_alpha_mem = null;
            this.b_posneg().prev_from_alpha_mem = rtrm_prev;
            this.b_posneg().alpha_mem_.last_beta_node = this;
            if (rtrm_prev != null) {
                rtrm_prev.b_posneg().next_from_alpha_mem = this;
            } else {
                this.b_posneg().alpha_mem_.beta_nodes = this;
            }
        }
        this.b_posneg().node_is_right_unlinked = false;
    }

    void unlink_from_right_mem() {
        if (this.b_posneg().next_from_alpha_mem == null) {
            this.b_posneg().alpha_mem_.last_beta_node = this.b_posneg().prev_from_alpha_mem;
        }
        if (this.b_posneg().next_from_alpha_mem != null) {
            this.b_posneg().next_from_alpha_mem.b_posneg().prev_from_alpha_mem = this.b_posneg().prev_from_alpha_mem;
        }
        if (this.b_posneg().prev_from_alpha_mem != null) {
            this.b_posneg().prev_from_alpha_mem.b_posneg().next_from_alpha_mem = this.b_posneg().next_from_alpha_mem;
        } else {
            this.b_posneg().alpha_mem_.beta_nodes = this.b_posneg().next_from_alpha_mem;
        }
        this.mark_node_as_right_unlinked();
    }

    boolean node_is_left_unlinked() {
        return this.a_pos().node_is_left_unlinked;
    }

    void mark_node_as_left_unlinked() {
        this.a_pos().node_is_left_unlinked = true;
    }

    void relink_to_left_mem() {
        this.a_pos().from_beta_mem.insertAtHead(this.parent.b_mem().first_linked_child);
        this.a_pos().node_is_left_unlinked = false;
    }

    void unlink_from_left_mem() {
        this.a_pos().from_beta_mem.remove(this.parent.b_mem().first_linked_child);
        this.mark_node_as_left_unlinked();
    }

    void make_mp_bnode_left_unlinked() {
        this.a_np().is_left_unlinked = true;
    }

    void make_mp_bnode_left_linked() {
        this.a_np().is_left_unlinked = false;
    }

    boolean mp_bnode_is_left_unlinked() {
        return this.a_np().is_left_unlinked;
    }

    void remove_node_from_parents_list_of_children() {
        ReteNode prev_sibling = this.parent.first_child;
        if (prev_sibling == this) {
            this.parent.first_child = this.next_sibling;
            return;
        }
        while (prev_sibling.next_sibling != this) {
            prev_sibling = prev_sibling.next_sibling;
        }
        prev_sibling.next_sibling = this.next_sibling;
    }

    ReteNode nearest_ancestor_with_same_am(AlphaMemory am) {
        ReteNode node = this;
        while (node.node_type != ReteNodeType.DUMMY_TOP_BNODE) {
            node = node.node_type == ReteNodeType.CN_BNODE ? node.b_cn().partner.parent : node.real_parent_node();
            if (!node.node_type.bnode_is_posneg() || node.b_posneg().alpha_mem_ != am) continue;
            return node;
        }
        return null;
    }

    static ReteNode createDummy() {
        return new ReteNode(ReteNodeType.DUMMY_TOP_BNODE, 0);
    }

    static ReteNode make_new_mem_node(Rete rete, ReteNode parent, ReteNodeType node_type, VarLocation left_hash_loc) {
        ReteNode node = new ReteNode(node_type, rete.get_next_beta_node_id());
        node.parent = parent;
        node.next_sibling = parent.first_child;
        parent.first_child = node;
        node.left_hash_loc_field_num = left_hash_loc.field_num;
        node.left_hash_loc_levels_up = left_hash_loc.levels_up;
        rete.update_node_with_matches_from_above(node);
        return node;
    }

    static ReteNode make_new_positive_node(Rete rete, ReteNode parent_mem, ReteNodeType node_type, AlphaMemory am, ReteTest rt, boolean prefer_left_unlinking) {
        ReteNode node = new ReteNode(node_type, 0);
        node.parent = parent_mem;
        node.next_sibling = parent_mem.first_child;
        parent_mem.first_child = node;
        node.relink_to_left_mem();
        node.b_posneg().other_tests = rt;
        node.b_posneg().alpha_mem_ = am;
        node.b_posneg().nearest_ancestor_with_same_am = node.nearest_ancestor_with_same_am(am);
        node.relink_to_right_mem();
        if (parent_mem.a_np().tokens == null) {
            node.unlink_from_right_mem();
        }
        if (am.right_mems == null && !node.node_is_right_unlinked()) {
            node.unlink_from_left_mem();
        }
        if (prefer_left_unlinking && parent_mem.a_np().tokens == null && am.right_mems == null) {
            node.relink_to_right_mem();
            node.unlink_from_left_mem();
        }
        return node;
    }

    static ReteNode split_mp_node(Rete rete, ReteNode mp_node) {
        ReteNodeType mem_node_type;
        ReteNodeType node_type;
        assert (mp_node.node_type == ReteNodeType.MP_BNODE || mp_node.node_type == ReteNodeType.UNHASHED_MP_BNODE);
        if (mp_node.node_type == ReteNodeType.MP_BNODE) {
            node_type = ReteNodeType.POSITIVE_BNODE;
            mem_node_type = ReteNodeType.MEMORY_BNODE;
        } else {
            node_type = ReteNodeType.UNHASHED_POSITIVE_BNODE;
            mem_node_type = ReteNodeType.UNHASHED_MEMORY_BNODE;
        }
        ReteNode parent = mp_node.parent;
        mp_node.remove_node_from_parents_list_of_children();
        ReteNode mem_node = new ReteNode(mem_node_type, mp_node.node_id);
        mem_node.parent = parent;
        mem_node.next_sibling = parent.first_child;
        parent.first_child = mem_node;
        mem_node.left_hash_loc_field_num = mp_node.left_hash_loc_field_num;
        mem_node.left_hash_loc_levels_up = mp_node.left_hash_loc_levels_up;
        mem_node.a_np().tokens = mp_node.a_np().tokens;
        Token t = mp_node.a_np().tokens;
        while (t != null) {
            t.node = mem_node;
            t = t.next_of_node;
        }
        boolean mpIsLeftUnlinked = mp_node.mp_bnode_is_left_unlinked();
        ReteNode pos_node = mp_node;
        pos_node.node_type = node_type;
        pos_node.a = new PosNodeData(pos_node);
        pos_node.parent = mem_node;
        mem_node.first_child = pos_node;
        pos_node.first_child = mp_node.first_child;
        pos_node.next_sibling = null;
        pos_node.b = mp_node.b_posneg();
        pos_node.relink_to_left_mem();
        if (mpIsLeftUnlinked) {
            pos_node.unlink_from_left_mem();
        }
        mem_node.validateUnions();
        pos_node.validateUnions();
        return mem_node;
    }

    static ReteNode merge_into_mp_node(Rete rete, ReteNode mem_node) {
        ReteNode pos_node = mem_node.first_child;
        boolean posNodeIsLeftUnlinked = pos_node.node_is_left_unlinked();
        ReteNode parent = mem_node.parent;
        if (pos_node == null || pos_node.next_sibling != null) {
            throw new IllegalArgumentException("Internal error: tried to merge_into_mp_node, but <>1 child");
        }
        assert (mem_node.node_type == ReteNodeType.MEMORY_BNODE && pos_node.node_type == ReteNodeType.POSITIVE_BNODE || mem_node.node_type == ReteNodeType.UNHASHED_MEMORY_BNODE && pos_node.node_type == ReteNodeType.UNHASHED_POSITIVE_BNODE);
        ReteNodeType node_type = mem_node.node_type == ReteNodeType.MEMORY_BNODE ? ReteNodeType.MP_BNODE : ReteNodeType.UNHASHED_MP_BNODE;
        ReteNode mp_node = pos_node;
        mp_node.node_type = node_type;
        mp_node.node_id = mem_node.node_id;
        mp_node.b = pos_node.b_posneg();
        mp_node.a = new NonPosNodeData();
        mp_node.a_np().tokens = mem_node.a_np().tokens;
        Token t = mem_node.a_np().tokens;
        while (t != null) {
            t.node = mp_node;
            t = t.next_of_node;
        }
        mp_node.left_hash_loc_field_num = mem_node.left_hash_loc_field_num;
        mp_node.left_hash_loc_levels_up = mem_node.left_hash_loc_levels_up;
        mp_node.parent = parent;
        mp_node.next_sibling = parent.first_child;
        parent.first_child = mp_node;
        mp_node.first_child = pos_node.first_child;
        mem_node.remove_node_from_parents_list_of_children();
        mp_node.make_mp_bnode_left_linked();
        if (posNodeIsLeftUnlinked) {
            mp_node.make_mp_bnode_left_unlinked();
        }
        mp_node.validateUnions();
        return mp_node;
    }

    static ReteNode make_new_mp_node(Rete rete, ReteNode parent, ReteNodeType node_type, VarLocation left_hash_loc, AlphaMemory am, ReteTest rt, boolean prefer_left_unlinking) {
        ReteNodeType mem_node_type = null;
        ReteNodeType pos_node_type = null;
        if (node_type == ReteNodeType.MP_BNODE) {
            pos_node_type = ReteNodeType.POSITIVE_BNODE;
            mem_node_type = ReteNodeType.MEMORY_BNODE;
        } else {
            pos_node_type = ReteNodeType.UNHASHED_POSITIVE_BNODE;
            mem_node_type = ReteNodeType.UNHASHED_MEMORY_BNODE;
        }
        ReteNode mem_node = ReteNode.make_new_mem_node(rete, parent, mem_node_type, left_hash_loc);
        ReteNode pos_node = ReteNode.make_new_positive_node(rete, mem_node, pos_node_type, am, rt, prefer_left_unlinking);
        return ReteNode.merge_into_mp_node(rete, mem_node);
    }

    static ReteNode make_new_negative_node(Rete rete, ReteNode parent, ReteNodeType node_type, VarLocation left_hash_loc, AlphaMemory am, ReteTest rt) {
        ReteNode node = new ReteNode(node_type, rete.get_next_beta_node_id());
        node.parent = parent;
        node.next_sibling = parent.first_child;
        parent.first_child = node;
        node.left_hash_loc_field_num = left_hash_loc.field_num;
        node.left_hash_loc_levels_up = left_hash_loc.levels_up;
        node.b_posneg().other_tests = rt;
        node.b_posneg().alpha_mem_ = am;
        node.b_posneg().nearest_ancestor_with_same_am = node.nearest_ancestor_with_same_am(am);
        node.relink_to_right_mem();
        rete.update_node_with_matches_from_above(node);
        if (node.a_np().tokens == null) {
            node.unlink_from_right_mem();
        }
        return node;
    }

    static ReteNode make_new_cn_node(Rete rete, ReteNode parent, ReteNode bottom_of_subconditions) {
        ReteNode ncc_subconditions_top_node = null;
        ReteNode node = bottom_of_subconditions;
        while (node != parent) {
            ncc_subconditions_top_node = node;
            node = node.parent;
        }
        node = new ReteNode(ReteNodeType.CN_BNODE, rete.get_next_beta_node_id());
        ReteNode partner = new ReteNode(ReteNodeType.CN_PARTNER_BNODE, 0);
        ncc_subconditions_top_node.remove_node_from_parents_list_of_children();
        node.parent = parent;
        node.next_sibling = parent.first_child;
        ncc_subconditions_top_node.next_sibling = node;
        parent.first_child = ncc_subconditions_top_node;
        node.first_child = null;
        node.b_cn().partner = partner;
        partner.parent = bottom_of_subconditions;
        partner.next_sibling = bottom_of_subconditions.first_child;
        bottom_of_subconditions.first_child = partner;
        partner.first_child = null;
        partner.b_cn().partner = node;
        rete.update_node_with_matches_from_above(partner);
        rete.update_node_with_matches_from_above(node);
        return node;
    }

    static ReteNode make_new_production_node(Rete rete, ReteNode parent, Production new_prod) {
        ReteNode p_node = new ReteNode(ReteNodeType.P_BNODE, 0);
        new_prod.setReteNode(rete, p_node);
        p_node.parent = parent;
        p_node.next_sibling = parent.first_child;
        parent.first_child = p_node;
        p_node.first_child = null;
        p_node.b_p().prod = new_prod;
        return p_node;
    }

    public static ReteNode createMatchesNode(ReteNode parent) {
        ReteNode dummy = new ReteNode(ReteNodeType.DUMMY_MATCHES_BNODE, 0);
        dummy.parent = parent;
        return dummy;
    }

    static void deallocate_rete_node(Rete rete, ReteNode node) {
        if (node == rete.dummy_top_node) {
            return;
        }
        if (node.node_type == ReteNodeType.P_BNODE) {
            throw new IllegalArgumentException("deallocate_rete_node() called on p-node");
        }
        ReteNode parent = node.parent;
        if (node.node_type == ReteNodeType.CN_BNODE) {
            ReteNode.deallocate_rete_node(rete, node.b_cn().partner);
        }
        if (!node.node_type.bnode_is_bottom_of_split_mp()) {
            while (node.a_np().tokens != null) {
                rete.remove_token_and_subtree(node.a_np().tokens);
            }
        }
        if (node.node_type.bnode_is_posneg()) {
            node.b_posneg().other_tests = null;
            if (!node.node_is_right_unlinked()) {
                node.unlink_from_right_mem();
            }
            node.b_posneg().alpha_mem_.remove_ref_to_alpha_mem(rete);
        }
        node.remove_node_from_parents_list_of_children();
        if (node.node_type.bnode_is_bottom_of_split_mp()) {
            if (!node.node_is_left_unlinked()) {
                node.unlink_from_left_mem();
            }
            if (parent.first_child != null && parent.first_child.next_sibling == null) {
                ReteNode.merge_into_mp_node(rete, parent);
                parent = null;
            }
        }
        if (parent != null && parent.first_child == null) {
            ReteNode.deallocate_rete_node(rete, parent);
        }
    }

    public String toString() {
        return this.node_id + ":" + (Object)((Object)this.node_type);
    }
}

