/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import java.util.List;
import org.jsoar.kernel.rete.VarLocation;
import org.jsoar.kernel.symbols.SymbolImpl;

public class ReteTest {
    public static final int CONSTANT_RELATIONAL = 0;
    public static final int VARIABLE_RELATIONAL = 16;
    public static final int DISJUNCTION = 32;
    public static final int ID_IS_GOAL = 48;
    public static final int ID_IS_IMPASSE = 49;
    public static final int RELATIONAL_EQUAL = 0;
    public static final int RELATIONAL_NOT_EQUAL = 1;
    public static final int RELATIONAL_LESS = 2;
    public static final int RELATIONAL_GREATER = 3;
    public static final int RELATIONAL_LESS_OR_EQUAL = 4;
    public static final int RELATIONAL_GREATER_OR_EQUAL = 5;
    public static final int RELATIONAL_SAME_TYPE = 6;
    final int type;
    final int right_field_num;
    final VarLocation variable_referent;
    final SymbolImpl constant_referent;
    final List<SymbolImpl> disjunction_list;
    ReteTest next;

    public static ReteTest createDisjunctionTest(int fieldNum, List<SymbolImpl> disjuncts) {
        return new ReteTest(fieldNum, disjuncts);
    }

    public static ReteTest createVariableTest(int type, int fieldNum, VarLocation variableReferent) {
        return new ReteTest(type, fieldNum, variableReferent);
    }

    public static ReteTest createConstantTest(int type, int fieldNum, SymbolImpl constant) {
        return new ReteTest(type, fieldNum, constant);
    }

    public static ReteTest createGoalIdTest() {
        return new ReteTest(48);
    }

    public static ReteTest createImpasseIdTest() {
        return new ReteTest(49);
    }

    private static boolean isRelationType(int r) {
        return r == 0 || r == 1 || r == 2 || r == 3 || r == 4 || r == 5 || r == 6;
    }

    protected ReteTest(int type) {
        this.type = type;
        this.right_field_num = 0;
        this.variable_referent = null;
        this.disjunction_list = null;
        this.constant_referent = null;
    }

    private ReteTest(int fieldNum, List<SymbolImpl> disjunction) {
        this.type = 32;
        this.right_field_num = fieldNum;
        this.disjunction_list = disjunction;
        this.variable_referent = null;
        this.constant_referent = null;
    }

    private ReteTest(int relation, int fieldNum, VarLocation variableReferent) {
        assert (ReteTest.isRelationType(relation));
        this.type = 16 + relation;
        this.right_field_num = fieldNum;
        this.disjunction_list = null;
        this.variable_referent = variableReferent;
        this.constant_referent = null;
    }

    private ReteTest(int relation, int fieldNum, SymbolImpl constantReferent) {
        assert (ReteTest.isRelationType(relation));
        this.type = 0 + relation;
        this.right_field_num = fieldNum;
        this.constant_referent = constantReferent;
        this.disjunction_list = null;
        this.variable_referent = null;
    }

    public boolean test_is_constant_relational_test() {
        return (this.type & 0xF0) == 0;
    }

    public boolean test_is_variable_relational_test() {
        return (this.type & 0xF0) == 16;
    }

    public int kind_of_relational_test() {
        return this.type & 0xF;
    }

    public boolean test_is_not_equal_test() {
        return this.type == 1 || this.type == 17;
    }

    public String toString() {
        String typeStr = "unknown";
        if (this.test_is_constant_relational_test()) {
            typeStr = "constant, " + this.relationToString(this.type - 0);
        } else if (this.test_is_variable_relational_test()) {
            typeStr = "variable, " + this.relationToString(this.type - 16);
        } else if (this.type == 32) {
            typeStr = "disjunction";
        } else if (this.type == 48) {
            typeStr = "id is goal";
        } else if (this.type == 49) {
            typeStr = "id is impasse";
        }
        return String.format("ReteTest id %d (%s)", this.type, typeStr);
    }

    private String relationToString(int relation) {
        switch (relation) {
            case 0: {
                return "equal";
            }
            case 1: {
                return "not equal";
            }
            case 2: {
                return "less";
            }
            case 3: {
                return "greater";
            }
            case 4: {
                return "less or equal";
            }
            case 5: {
                return "greater or equal";
            }
            case 6: {
                return "same_type";
            }
        }
        return "unknown";
    }
}

