/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rete;

import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.rete.NonPosNodeData;
import org.jsoar.kernel.rete.ReteNode;

public class Token {
    public final Token parent;
    ReteNode node;
    public final WmeImpl w;
    Token first_child;
    Token next_sibling;
    private Token previous_sibling;
    Token next_from_wme;
    private Token previous_from_wme;
    Token next_of_node;
    private Token previous_of_node;

    public Token(ReteNode current_node, Token parent_tok, WmeImpl parent_wme, boolean addToNode) {
        assert (current_node != null);
        this.node = current_node;
        this.parent = parent_tok;
        this.w = parent_wme;
        if (addToNode) {
            Token.addToNode(this.node.a_np(), this);
        }
        Token.addToParent(this.parent, this);
        Token.addToWme(this.w, this);
    }

    public static Token createMatchesToken(Token parent, WmeImpl wme) {
        return new Token(parent, wme);
    }

    private Token(Token parent, WmeImpl wme) {
        this.parent = parent;
        this.w = wme;
    }

    public Token getNextSiblingOrParent() {
        return this.next_sibling != null ? this.next_sibling : this.parent;
    }

    public void removeFromParent() {
        if (this.next_sibling != null) {
            this.next_sibling.previous_sibling = this.previous_sibling;
        }
        if (this.previous_sibling != null) {
            this.previous_sibling.next_sibling = this.next_sibling;
        } else {
            this.parent.first_child = this.next_sibling;
        }
        this.next_sibling = null;
        this.previous_sibling = null;
    }

    private static void addToParent(Token parent, Token child) {
        if (parent != null) {
            child.next_sibling = parent.first_child;
            child.previous_sibling = null;
            if (parent.first_child != null) {
                parent.first_child.previous_sibling = child;
            }
            parent.first_child = child;
        }
    }

    public void removeFromWme() {
        if (this.w != null) {
            if (this.next_from_wme != null) {
                this.next_from_wme.previous_from_wme = this.previous_from_wme;
            }
            if (this.previous_from_wme != null) {
                this.previous_from_wme.next_from_wme = this.next_from_wme;
            } else {
                this.w.tokens = this.next_from_wme;
            }
            this.next_from_wme = null;
            this.previous_from_wme = null;
        }
    }

    public void removeFromNode() {
        NonPosNodeData a_np = this.node.a_np();
        if (this.next_of_node != null) {
            this.next_of_node.previous_of_node = this.previous_of_node;
        }
        if (this.previous_of_node != null) {
            this.previous_of_node.next_of_node = this.next_of_node;
        } else {
            a_np.tokens = this.next_of_node;
        }
        this.next_of_node = null;
        this.previous_of_node = null;
    }

    private static void addToNode(NonPosNodeData a_np, Token tok) {
        tok.next_of_node = a_np.tokens;
        tok.previous_of_node = null;
        if (a_np.tokens != null) {
            a_np.tokens.previous_of_node = tok;
        }
        a_np.tokens = tok;
    }

    private static void addToWme(WmeImpl wme, Token tok) {
        if (wme != null) {
            tok.next_from_wme = wme.tokens;
            tok.previous_from_wme = null;
            if (wme.tokens != null) {
                wme.tokens.previous_from_wme = tok;
            }
            wme.tokens = tok;
        }
    }
}

