/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs;

import java.util.Iterator;
import java.util.LinkedList;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.memory.PreferenceType;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.rhs.ActionSupport;
import org.jsoar.kernel.rhs.FunctionAction;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.RhsFunctionCall;
import org.jsoar.kernel.rhs.RhsSymbolValue;
import org.jsoar.kernel.rhs.RhsValues;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.ListHead;
import org.jsoar.util.markers.Marker;

public abstract class Action {
    public Action next;
    public PreferenceType preference_type;
    public ActionSupport support = ActionSupport.UNKNOWN_SUPPORT;
    public boolean already_in_tc = false;

    public static void addAllVariables(Action head, Marker tc_number, ListHead<Variable> var_list) {
        Action a = head;
        while (a != null) {
            a.addAllVariables(tc_number, var_list);
            a = a.next;
        }
    }

    public abstract void addAllVariables(Marker var1, ListHead<Variable> var2);

    public MakeAction asMakeAction() {
        return null;
    }

    public FunctionAction asFunctionAction() {
        return null;
    }

    public static boolean same_rhs(Action rhs1, Action rhs2, boolean rl_chunk_stop) {
        Action a1 = rhs1;
        Action a2 = rhs2;
        while (a1 != null && a2 != null) {
            if (a1.asFunctionAction() != null) {
                return false;
            }
            if (a2.asFunctionAction() != null) {
                return false;
            }
            if (a1.preference_type != a2.preference_type) {
                return false;
            }
            MakeAction ma1 = a1.asMakeAction();
            MakeAction ma2 = a2.asMakeAction();
            if (!ma1.id.equals(ma2.id)) {
                return false;
            }
            if (!ma1.attr.equals(ma2.attr)) {
                return false;
            }
            if (!ma1.value.equals(ma2.value)) {
                return false;
            }
            if (ma1.preference_type.isBinary() && ma1.referent != ma2.referent) {
                boolean stop = true;
                if (rl_chunk_stop && ma1.referent.asSymbolValue() != null && ma2.referent.asSymbolValue() != null) {
                    RhsSymbolValue a1r = ma1.referent.asSymbolValue();
                    RhsSymbolValue a2r = ma2.referent.asSymbolValue();
                    if (!(a1r.getSym().asInteger() == null && a1r.getSym().asDouble() == null || a2r.getSym().asInteger() == null && a2r.getSym().asDouble() == null || a1 != rhs1 || a1.next != null || a2 != rhs2 || a2.next != null)) {
                        stop = false;
                    }
                }
                if (stop) {
                    return false;
                }
            }
            a1 = a1.next;
            a2 = a2.next;
        }
        return a1 == a2;
    }

    public boolean action_is_in_tc(Marker tc) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void add_action_to_tc(Marker tc, ListHead<IdentifierImpl> id_list, ListHead<Variable> var_list) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Action copy_action_list_and_substitute_varnames(Rete rete, Action actions, Condition cond) {
        FunctionAction prev = null;
        FunctionAction first = null;
        Action old = actions;
        Action New = null;
        while (old != null) {
            if (old instanceof MakeAction) {
                MakeAction oldMake = (MakeAction)old;
                MakeAction newMake = new MakeAction();
                newMake.id = RhsValues.copy_rhs_value_and_substitute_varnames(rete, oldMake.id, cond, 's');
                newMake.attr = RhsValues.copy_rhs_value_and_substitute_varnames(rete, oldMake.attr, cond, 'a');
                char first_letter = newMake.attr.getFirstLetter();
                newMake.value = RhsValues.copy_rhs_value_and_substitute_varnames(rete, oldMake.value, cond, first_letter);
                if (old.preference_type.isBinary()) {
                    newMake.referent = RhsValues.copy_rhs_value_and_substitute_varnames(rete, oldMake.referent, cond, first_letter);
                }
                New = newMake;
            } else if (old instanceof FunctionAction) {
                FunctionAction newFunc;
                FunctionAction oldFunc = (FunctionAction)old;
                New = newFunc = new FunctionAction((RhsFunctionCall)RhsValues.copy_rhs_value_and_substitute_varnames(rete, oldFunc.call, cond, 'v'));
            } else {
                throw new IllegalStateException("Unknown action type: " + old);
            }
            if (prev != null) {
                prev.next = New;
            } else {
                first = New;
            }
            prev = New;
            New.preference_type = old.preference_type;
            New.support = old.support;
            old = old.next;
        }
        if (prev != null) {
            prev.next = null;
        } else {
            first = null;
        }
        return first;
    }

    public static void print_action_list(Printer printer, Action actions, int indent, boolean internal) {
        if (actions == null) {
            return;
        }
        boolean did_one_line_already = false;
        LinkedList<Action> actions_not_yet_printed = new LinkedList<Action>();
        Action a = actions;
        while (a != null) {
            actions_not_yet_printed.add(a);
            a = a.next;
        }
        while (!actions_not_yet_printed.isEmpty()) {
            if (did_one_line_already) {
                printer.print("\n").spaces(indent);
            } else {
                did_one_line_already = true;
            }
            a = (Action)actions_not_yet_printed.pop();
            FunctionAction fa = a.asFunctionAction();
            if (fa != null) {
                printer.print("%s", fa.call);
                continue;
            }
            MakeAction ma = a.asMakeAction();
            LinkedList<MakeAction> actions_for_this_id = new LinkedList<MakeAction>();
            actions_for_this_id.add(a.asMakeAction());
            SymbolImpl action_id_to_match = ma.id.asSymbolValue().getSym();
            if (!internal) {
                Iterator it = actions_not_yet_printed.iterator();
                while (it.hasNext()) {
                    Action n = (Action)it.next();
                    MakeAction nma = n.asMakeAction();
                    if (nma == null || nma.id.asSymbolValue().getSym() != action_id_to_match) continue;
                    actions_for_this_id.add(nma);
                    it.remove();
                }
            }
            printer.print("(%s", action_id_to_match);
            while (!actions_for_this_id.isEmpty()) {
                MakeAction ma2 = (MakeAction)actions_for_this_id.pop();
                StringBuilder gs = new StringBuilder();
                gs.append(" ^");
                gs.append(String.format("%s %s %c", ma2.attr, ma2.value, Character.valueOf(ma2.preference_type.getIndicator())));
                if (ma2.preference_type.isBinary()) {
                    gs.append(String.format(" %s", ma2.referent));
                }
                printer.print(gs.toString());
            }
            printer.print(")");
        }
    }
}

