/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs;

import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.ReordererException;
import org.jsoar.kernel.rhs.RhsFunctionCall;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.util.ByRef;
import org.jsoar.util.ListHead;
import org.jsoar.util.ListItem;
import org.jsoar.util.markers.Marker;

public class ActionReorderer {
    private final Printer printer;
    private final String prodName;

    public ActionReorderer(Printer printer, String prodName) {
        this.printer = printer;
        this.prodName = prodName;
    }

    public void reorder_action_list(ByRef<Action> action_list, Marker lhs_tc) throws ReordererException {
        ListHead<Variable> new_bound_vars = ListHead.newInstance();
        Action remaining_actions = (Action)action_list.value;
        Action first_action = null;
        Action last_action = null;
        Action prev_a = null;
        while (remaining_actions != null) {
            prev_a = null;
            Action a = remaining_actions;
            while (a != null && !this.legal_to_execute_action(a, lhs_tc)) {
                prev_a = a;
                a = a.next;
            }
            if (a == null) break;
            if (prev_a != null) {
                prev_a.next = a.next;
            } else {
                remaining_actions = a.next;
            }
            a.next = null;
            if (last_action != null) {
                last_action.next = a;
            } else {
                first_action = a;
            }
            last_action = a;
            Action.addAllVariables(a, lhs_tc, new_bound_vars);
        }
        if (remaining_actions != null) {
            if (last_action != null) {
                last_action.next = remaining_actions;
            } else {
                first_action = remaining_actions;
            }
            String message = String.format("Error: production %s has a bad RHS--\n Either it creates structure not connected to anything\n else in WM, or it tries to pass an unbound variable as\n an argument to a function.\n", this.prodName);
            this.printer.error(message);
            throw new ReordererException(message);
        }
        ListItem var = new_bound_vars.first;
        while (var != null) {
            ((Variable)var.item).unmark();
            var = var.next;
        }
        action_list.value = first_action;
    }

    private boolean legal_to_execute_action(Action a, Marker tc) {
        MakeAction ma = a.asMakeAction();
        if (ma != null) {
            if (!this.all_variables_in_rhs_value_bound(ma.id, tc)) {
                return false;
            }
            if (ma.attr.asFunctionCall() != null && !this.all_variables_in_rhs_value_bound(ma.attr, tc)) {
                return false;
            }
            if (ma.value.asFunctionCall() != null && !this.all_variables_in_rhs_value_bound(ma.value, tc)) {
                return false;
            }
            return !a.preference_type.isBinary() || ma.referent.asFunctionCall() == null || this.all_variables_in_rhs_value_bound(ma.referent, tc);
        }
        return this.all_variables_in_rhs_value_bound(a.asFunctionAction().getCall(), tc);
    }

    private boolean all_variables_in_rhs_value_bound(RhsValue rv, Marker tc) {
        RhsFunctionCall fc = rv.asFunctionCall();
        if (fc != null) {
            for (RhsValue arg : fc.getArguments()) {
                if (this.all_variables_in_rhs_value_bound(arg, tc)) continue;
                return false;
            }
            return true;
        }
        Variable var = rv.asSymbolValue().getSym().asVariable();
        if (var != null) {
            return var.tc_number == tc;
        }
        return true;
    }
}

