/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs;

import java.util.Formatter;
import org.jsoar.kernel.rhs.AbstractRhsValue;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.symbols.Variable;
import org.jsoar.util.ListHead;
import org.jsoar.util.markers.Marker;

public class UnboundVariable
extends AbstractRhsValue {
    private final int index;
    private static final UnboundVariable[] COMMON = new UnboundVariable[100];

    public static UnboundVariable create(int index) {
        if (index < COMMON.length) {
            return COMMON[index];
        }
        return new UnboundVariable(index);
    }

    private UnboundVariable(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public UnboundVariable asUnboundVariable() {
        return this;
    }

    @Override
    public RhsValue copy() {
        return this;
    }

    @Override
    public void addAllVariables(Marker tc_number, ListHead<Variable> var_list) {
        throw new UnsupportedOperationException("addAllVariables not supported on UnboundVariable RhsValue");
    }

    public String toString() {
        return "(unbound-var + " + this.index + ")";
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        throw new IllegalStateException("Internal error: rhs_value_to_string called on unbound variable.");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnboundVariable)) {
            return false;
        }
        UnboundVariable other = (UnboundVariable)obj;
        return this.index == other.index;
    }

    static {
        for (int i = 0; i < COMMON.length; ++i) {
            UnboundVariable.COMMON[i] = new UnboundVariable(i);
        }
    }
}

