/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.util.Arguments;

public abstract class AbstractRhsFunctionHandler
implements RhsFunctionHandler {
    private final String name;
    private final int minArgs;
    private final int maxArgs;

    public AbstractRhsFunctionHandler(String name) {
        this(name, 0, Integer.MAX_VALUE);
    }

    public AbstractRhsFunctionHandler(String name, int minArgs, int maxArgs) {
        Arguments.checkNotNull(name, "name");
        Arguments.check(minArgs <= maxArgs, "minArgs > maxArgs");
        Arguments.check(minArgs >= 0, "minArgs < 0");
        this.name = name;
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
    }

    @Override
    public int getMaxArguments() {
        return this.maxArgs;
    }

    @Override
    public int getMinArguments() {
        return this.minArgs;
    }

    @Override
    public boolean mayBeStandalone() {
        return false;
    }

    @Override
    public boolean mayBeValue() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

