/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.Symbol;

public class CumulativeNormalDistribution
extends AbstractRhsFunctionHandler {
    private final NormalDistribution nd = new NormalDistribution();

    public CumulativeNormalDistribution() {
        super("cndf", 1, 1);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
        double value = arguments.get(0).asDouble().getValue();
        double cndf = this.nd.cumulativeProbability(value);
        return context.getSymbols().createDouble(cndf);
    }
}

