/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.memory.WmeType;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.Identifier;
import org.jsoar.kernel.symbols.Symbol;

public class DeepCopy
extends AbstractRhsFunctionHandler {
    private static final EnumSet<WmeType> filter = EnumSet.complementOf(EnumSet.of(WmeType.IMPASSE));

    public DeepCopy() {
        super("deep-copy", 1, 1);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        Identifier startId = arguments.get(0).asIdentifier();
        if (startId == null) {
            throw new RhsFunctionException("Only argument to '" + this.getName() + "' RHS function must be an identifier.");
        }
        HashMap<Identifier, Identifier> idMap = new HashMap<Identifier, Identifier>();
        return this.copy(context, startId, idMap);
    }

    private Identifier copy(RhsFunctionContext context, Identifier id, Map<Identifier, Identifier> idMap) {
        Identifier targetId = idMap.get(id);
        if (targetId != null) {
            return targetId;
        }
        targetId = context.getSymbols().createIdentifier(id.getNameLetter());
        idMap.put(id, targetId);
        Iterator<Wme> it = id.getWmes(filter);
        while (it.hasNext()) {
            Wme w = it.next();
            Symbol value = w.getValue();
            Identifier valueId = value.asIdentifier();
            if (valueId == null) {
                context.addWme(targetId, w.getAttribute(), value);
                continue;
            }
            valueId = this.copy(context, valueId, idMap);
            context.addWme(targetId, w.getAttribute(), valueId);
        }
        return targetId;
    }
}

