/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class FloatRhsFunction
extends AbstractRhsFunctionHandler {
    public FloatRhsFunction() {
        super("float", 1, 1);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        Symbol arg = arguments.get(0);
        DoubleSymbol doubleSym = arg.asDouble();
        if (doubleSym != null) {
            return doubleSym;
        }
        IntegerSymbol intSym = arg.asInteger();
        if (intSym != null) {
            return context.getSymbols().createDouble(intSym.getValue());
        }
        if (arg.asIdentifier() != null) {
            throw new RhsFunctionException("Identifier passed to float RHS function: " + arg);
        }
        String string = arg.toString();
        try {
            return context.getSymbols().createDouble(Double.parseDouble(string));
        }
        catch (NumberFormatException e) {
            throw new RhsFunctionException(arg + " is not a valid float.");
        }
    }
}

