/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.IllegalFormatConversionException;
import java.util.List;
import org.jsoar.kernel.Production;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.Symbols;

public class FormatRhsFunction
extends AbstractRhsFunctionHandler {
    public FormatRhsFunction() {
        super("format", 1, Integer.MAX_VALUE);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        String format = arguments.get(0).toString();
        Object[] derefed = new Object[arguments.size() - 1];
        for (int i = 0; i < derefed.length; ++i) {
            derefed[i] = Symbols.valueOf(arguments.get(i + 1));
        }
        try {
            return context.getSymbols().createString(String.format(format, derefed));
        }
        catch (IllegalFormatConversionException e) {
            Production p = context.getProductionBeingFired();
            throw new RhsFunctionException("Invalid format '" + format + "' in rule '" + (p != null ? p.getName() : "unknown") + "': " + e.getMessage(), e);
        }
    }
}

