/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jsoar.kernel.io.xml.ManualTypeXmlToWme;
import org.jsoar.kernel.io.xml.TagAlreadyAddedException;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.util.XmlTools;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FromManualTypeXml
extends AbstractRhsFunctionHandler {
    public FromManualTypeXml() {
        super("from-mt-xml", 1, Integer.MAX_VALUE);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        Document doc;
        RhsFunctions.checkArgumentCount(this, arguments);
        String xml = arguments.get(0).toString();
        if (xml == null) {
            throw new RhsFunctionException("Only argument to '" + this.getName() + "' RHS function must be an XML string.");
        }
        try {
            doc = XmlTools.parse(xml);
        }
        catch (SAXException e) {
            throw new RhsFunctionException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RhsFunctionException(e.getMessage(), e);
        }
        ManualTypeXmlToWme mt = new ManualTypeXmlToWme(context);
        Iterator<Symbol> args = arguments.iterator();
        args.next();
        try {
            while (args.hasNext()) {
                String type = args.next().toString();
                if (type.equals("float")) {
                    mt.addFloatTag(args.next().toString());
                    continue;
                }
                if (!type.equals("int")) continue;
                mt.addIntTag(args.next().toString());
            }
        }
        catch (TagAlreadyAddedException e) {
            throw new RhsFunctionException("Int and float tags must be mutually exclusive.", e);
        }
        return mt.fromXml(doc.getDocumentElement());
    }
}

