/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;

public final class Minus
extends AbstractRhsFunctionHandler {
    public Minus() {
        super("-", 1, Integer.MAX_VALUE);
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
        RhsFunctions.checkArgumentCount(this, arguments);
        SymbolFactory syms = context.getSymbols();
        Symbol arg = arguments.get(0);
        if (arguments.size() == 1) {
            IntegerSymbol i = arg.asInteger();
            return i != null ? syms.createInteger(-i.getValue()) : syms.createDouble(-arg.asDouble().getValue());
        }
        long i = 0L;
        double f = 0.0;
        boolean float_found = false;
        IntegerSymbol ic = arg.asInteger();
        if (ic != null) {
            i = ic.getValue();
        } else {
            float_found = true;
            f = arg.asDouble().getValue();
        }
        for (int index = 1; index < arguments.size(); ++index) {
            arg = arguments.get(index);
            ic = arg.asInteger();
            if (ic != null) {
                if (float_found) {
                    f -= (double)ic.getValue();
                    continue;
                }
                i -= ic.getValue();
                continue;
            }
            if (float_found) {
                f -= arg.asDouble().getValue();
                continue;
            }
            float_found = true;
            f = (double)i - arg.asDouble().getValue();
        }
        return float_found ? syms.createDouble(f) : syms.createInteger(i);
    }
}

