/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import java.util.Random;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class RandFloat
extends AbstractRhsFunctionHandler {
    private final Random random;

    public RandFloat(Random random) {
        super("rand-float", 0, 1);
        this.random = random;
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        double max;
        RhsFunctions.checkArgumentCount(this, arguments);
        if (arguments.size() == 0) {
            return context.getSymbols().createDouble(this.random.nextDouble());
        }
        DoubleSymbol maxSymD = arguments.get(0).asDouble();
        if (maxSymD != null) {
            max = maxSymD.getValue();
        } else {
            IntegerSymbol maxSymI = arguments.get(0).asInteger();
            if (maxSymI != null) {
                max = maxSymI.getValue();
            } else {
                throw new RhsFunctionException("rand-float: Expected double or integer for first argument, got " + arguments.get(0));
            }
        }
        return context.getSymbols().createDouble(this.random.nextDouble() * max);
    }
}

