/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.List;
import java.util.Random;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.IntegerSymbol;
import org.jsoar.kernel.symbols.Symbol;

public class RandomInt
extends AbstractRhsFunctionHandler {
    private final Random random;

    public RandomInt(Random random) {
        super("random-int", 0, 1);
        this.random = random;
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        if (arguments.size() == 0) {
            return context.getSymbols().createInteger(this.random.nextInt());
        }
        IntegerSymbol maxSym = arguments.get(0).asInteger();
        if (maxSym == null) {
            throw new RhsFunctionException("random-int: Expected integer for first argument, got " + arguments.get(0));
        }
        long max = maxSym.getValue();
        if (max >= 0L) {
            return context.getSymbols().createInteger(this.random.nextInt((int)max));
        }
        return context.getSymbols().createInteger(-this.random.nextInt(-((int)max)));
    }
}

