/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.util.Arguments;

public class RhsFunctionManager {
    private final RhsFunctionContext rhsContext;
    private final Map<String, RhsFunctionHandler> handlers = new ConcurrentHashMap<String, RhsFunctionHandler>();
    private final Map<String, RhsFunctionHandler> disabledHandlers = new ConcurrentHashMap<String, RhsFunctionHandler>();

    public RhsFunctionManager(RhsFunctionContext rhsContext) {
        this.rhsContext = rhsContext;
    }

    public List<RhsFunctionHandler> getHandlers() {
        return new ArrayList<RhsFunctionHandler>(this.handlers.values());
    }

    public RhsFunctionHandler registerHandler(RhsFunctionHandler handler) {
        Arguments.checkNotNull(handler, "handler");
        return this.handlers.put(handler.getName(), handler);
    }

    public RhsFunctionHandler getHandler(String name) {
        return this.handlers.get(name);
    }

    public void unregisterHandler(String name) {
        Arguments.checkNotNull(name, "name");
        this.handlers.remove(name);
    }

    public void disableHandler(String name) {
        Arguments.checkNotNull(name, "name");
        if (this.handlers.containsKey(name)) {
            this.disabledHandlers.put(name, this.handlers.remove(name));
        }
    }

    public void enableHandler(String name) {
        Arguments.checkNotNull(name, "name");
        if (this.disabledHandlers.containsKey(name) && !this.handlers.containsKey(name)) {
            this.handlers.put(name, this.disabledHandlers.remove(name));
        }
    }

    public boolean isDisabled(String name) {
        Arguments.checkNotNull(name, "name");
        return this.disabledHandlers.containsKey(name);
    }

    public List<RhsFunctionHandler> getDisabledHandlers() {
        return new ArrayList<RhsFunctionHandler>(this.disabledHandlers.values());
    }

    public Symbol execute(String name, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctionHandler handler = this.handlers.get(name);
        if (handler != null) {
            return handler.execute(this.rhsContext, arguments);
        }
        if (this.disabledHandlers.containsKey(name)) {
            return null;
        }
        throw new RhsFunctionException("No function '" + name + "' registered");
    }
}

