/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.rhs.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.AcceptRhsFunction;
import org.jsoar.kernel.rhs.functions.CmdRhsFunction;
import org.jsoar.kernel.rhs.functions.Concat;
import org.jsoar.kernel.rhs.functions.Debug;
import org.jsoar.kernel.rhs.functions.DeepCopy;
import org.jsoar.kernel.rhs.functions.ExecRhsFunction;
import org.jsoar.kernel.rhs.functions.FloatRhsFunction;
import org.jsoar.kernel.rhs.functions.FormatRhsFunction;
import org.jsoar.kernel.rhs.functions.FromAutoTypeXml;
import org.jsoar.kernel.rhs.functions.FromManualTypeXml;
import org.jsoar.kernel.rhs.functions.FromSoarTechXml;
import org.jsoar.kernel.rhs.functions.FromXml;
import org.jsoar.kernel.rhs.functions.GetUrl;
import org.jsoar.kernel.rhs.functions.IfEq;
import org.jsoar.kernel.rhs.functions.IntRhsFunction;
import org.jsoar.kernel.rhs.functions.Interrupt;
import org.jsoar.kernel.rhs.functions.ListRhsFunction;
import org.jsoar.kernel.rhs.functions.LogRhsFunction;
import org.jsoar.kernel.rhs.functions.MakeConstantSymbol;
import org.jsoar.kernel.rhs.functions.MakeIntegerSymbol;
import org.jsoar.kernel.rhs.functions.MathFunctions;
import org.jsoar.kernel.rhs.functions.RandFloat;
import org.jsoar.kernel.rhs.functions.RandInt;
import org.jsoar.kernel.rhs.functions.RandomFloat;
import org.jsoar.kernel.rhs.functions.RandomInt;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.rhs.functions.Split;
import org.jsoar.kernel.rhs.functions.StandaloneRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.StrLen;
import org.jsoar.kernel.rhs.functions.StringRhsFunction;
import org.jsoar.kernel.rhs.functions.Timestamp;
import org.jsoar.kernel.rhs.functions.ToSoarTechXml;
import org.jsoar.kernel.rhs.functions.ToXml;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.util.StringTools;
import org.jsoar.util.adaptables.Adaptables;

public class StandardFunctions {
    private final Agent context;
    public final RhsFunctionHandler write = new StandaloneRhsFunctionHandler("write"){

        @Override
        public Symbol execute(RhsFunctionContext rhsContext, List<Symbol> arguments) throws RhsFunctionException {
            for (Symbol arg : arguments) {
                StandardFunctions.this.context.getPrinter().print(arg.toString());
            }
            StandardFunctions.this.context.getPrinter().flush();
            return null;
        }
    };
    public final RhsFunctionHandler crlf = new AbstractRhsFunctionHandler("crlf", 0, 0){

        @Override
        public Symbol execute(RhsFunctionContext rhsContext, List<Symbol> arguments) throws RhsFunctionException {
            RhsFunctions.checkArgumentCount(this, arguments);
            return rhsContext.getSymbols().createString("\n");
        }
    };
    public final RhsFunctionHandler failed = new StandaloneRhsFunctionHandler("failed"){

        @Override
        public Symbol execute(RhsFunctionContext rhsContext, List<Symbol> arguments) throws RhsFunctionException {
            StandardFunctions.this.context.getPrinter().error("Failed: %s: %s", rhsContext.getProductionBeingFired().getName(), StringTools.join(arguments, ", "));
            return StandardFunctions.this.context.getRhsFunctions().getHandler("halt").execute(rhsContext, arguments);
        }
    };
    public final RhsFunctionHandler succeeded = new StandaloneRhsFunctionHandler("succeeded"){

        @Override
        public Symbol execute(RhsFunctionContext rhsContext, List<Symbol> arguments) throws RhsFunctionException {
            StandardFunctions.this.context.getPrinter().print("Succeeded: %s: %s", rhsContext.getProductionBeingFired().getName(), StringTools.join(arguments, ", "));
            return StandardFunctions.this.context.getRhsFunctions().getHandler("halt").execute(rhsContext, arguments);
        }
    };
    private final List<RhsFunctionHandler> allInternal = new ArrayList<RhsFunctionHandler>(Arrays.asList(this.write, this.crlf, this.failed, this.succeeded, new Concat(), new IfEq(), new MakeConstantSymbol(), new MakeIntegerSymbol(), new StrLen(), new Split(), new DeepCopy(), new StringRhsFunction(), new IntRhsFunction(), new FloatRhsFunction(), new FromXml(), new ToXml(), new FromSoarTechXml(), new FromAutoTypeXml(), new FromManualTypeXml(), new ToSoarTechXml(), new GetUrl(), new AcceptRhsFunction(), new ListRhsFunction(), new FormatRhsFunction(), new Timestamp()));
    public final List<RhsFunctionHandler> all;

    public StandardFunctions(Agent context) {
        this.allInternal.addAll(MathFunctions.all);
        this.all = Collections.unmodifiableList(this.allInternal);
        this.context = context;
        DecisionCycle decisionCycle = Adaptables.adapt(context, DecisionCycle.class);
        this.allInternal.add(new Interrupt(decisionCycle));
        this.allInternal.add(new Debug(context));
        this.allInternal.add(new ExecRhsFunction(context.getRhsFunctions()));
        this.allInternal.add(new CmdRhsFunction(context.getInterpreter(), context));
        this.allInternal.add(new RandomInt(context.getRandom()));
        this.allInternal.add(new RandomFloat(context.getRandom()));
        this.allInternal.add(new RandInt(context.getRandom()));
        this.allInternal.add(new RandFloat(context.getRandom()));
        this.allInternal.add(new LogRhsFunction(context.getInterpreter()));
        for (RhsFunctionHandler handler : this.all) {
            context.getRhsFunctions().registerHandler(handler);
        }
    }
}

