/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.smem;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.Decider;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.epmem.DefaultEpisodicMemory;
import org.jsoar.kernel.learning.Chunker;
import org.jsoar.kernel.lhs.Condition;
import org.jsoar.kernel.lhs.ConjunctiveTest;
import org.jsoar.kernel.lhs.EqualityTest;
import org.jsoar.kernel.lhs.PositiveCondition;
import org.jsoar.kernel.lhs.Test;
import org.jsoar.kernel.lhs.Tests;
import org.jsoar.kernel.memory.Instantiation;
import org.jsoar.kernel.memory.Preference;
import org.jsoar.kernel.memory.RecognitionMemory;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.memory.WorkingMemory;
import org.jsoar.kernel.modules.SoarModule;
import org.jsoar.kernel.parser.original.Lexeme;
import org.jsoar.kernel.parser.original.LexemeType;
import org.jsoar.kernel.parser.original.Lexer;
import org.jsoar.kernel.rhs.Action;
import org.jsoar.kernel.rhs.MakeAction;
import org.jsoar.kernel.rhs.RhsSymbolValue;
import org.jsoar.kernel.rhs.RhsValue;
import org.jsoar.kernel.smem.ActivatedLti;
import org.jsoar.kernel.smem.DefaultSemanticMemoryParams;
import org.jsoar.kernel.smem.DefaultSemanticMemoryStats;
import org.jsoar.kernel.smem.ParsedLtiName;
import org.jsoar.kernel.smem.SemanticMemory;
import org.jsoar.kernel.smem.SemanticMemoryDatabase;
import org.jsoar.kernel.smem.SemanticMemoryStateInfo;
import org.jsoar.kernel.smem.SemanticMemoryStatistics;
import org.jsoar.kernel.smem.SemanticMemorySymbols;
import org.jsoar.kernel.smem.WeightedCueElement;
import org.jsoar.kernel.smem.math.MathQuery;
import org.jsoar.kernel.smem.math.MathQueryGreater;
import org.jsoar.kernel.smem.math.MathQueryGreaterOrEqual;
import org.jsoar.kernel.smem.math.MathQueryLess;
import org.jsoar.kernel.smem.math.MathQueryLessOrEqual;
import org.jsoar.kernel.smem.math.MathQueryMax;
import org.jsoar.kernel.smem.math.MathQueryMin;
import org.jsoar.kernel.smem.smem_chunk_lti;
import org.jsoar.kernel.smem.smem_cue_element_type;
import org.jsoar.kernel.smem.smem_vis_lti;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactoryImpl;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.symbols.Symbols;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.kernel.wma.WorkingMemoryActivation;
import org.jsoar.util.ByRef;
import org.jsoar.util.JdbcTools;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.markers.Marker;
import org.jsoar.util.properties.PropertyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSemanticMemory
implements SemanticMemory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSemanticMemory.class);
    private static final long SMEM_ACT_MAX = 0L;
    private static final long SMEM_AUGMENTATIONS_NULL = 0L;
    private static final long SMEM_ACT_HISTORY_ENTRIES = 10L;
    private static final long SMEM_ACT_LOW = -1000000000L;
    private Adaptable context;
    private DefaultSemanticMemoryParams params;
    private DefaultSemanticMemoryStats stats;
    SymbolFactoryImpl symbols;
    private RecognitionMemory recMem;
    private Chunker chunker;
    private Decider decider;
    private DefaultEpisodicMemory epmem;
    private WorkingMemoryActivation wma;
    private Trace trace;
    private SemanticMemoryDatabase db;
    private long smem_validation;
    private long smem_max_cycle;
    SemanticMemorySymbols predefinedSyms;
    private Map<IdentifierImpl, SemanticMemoryStateInfo> stateInfos = new LinkedHashMap<IdentifierImpl, SemanticMemoryStateInfo>();
    private Set<IdentifierImpl> smem_changed_ids = new LinkedHashSet<IdentifierImpl>();
    private boolean smem_ignore_changes;
    private BasicWeightedCue lastCue;

    public BasicWeightedCue getLastCue() {
        return this.lastCue;
    }

    public DefaultSemanticMemory(Adaptable context) {
        this(context, null);
    }

    public DefaultSemanticMemory(Adaptable context, SemanticMemoryDatabase db) {
        this.context = context;
        this.db = db;
    }

    public void initialize() {
        this.symbols = Adaptables.require(DefaultSemanticMemory.class, this.context, SymbolFactoryImpl.class);
        this.predefinedSyms = new SemanticMemorySymbols(this.symbols);
        this.chunker = Adaptables.adapt(this.context, Chunker.class);
        this.decider = Adaptables.adapt(this.context, Decider.class);
        this.recMem = Adaptables.adapt(this.context, RecognitionMemory.class);
        this.epmem = Adaptables.require(DefaultSemanticMemory.class, this.context, DefaultEpisodicMemory.class);
        this.wma = Adaptables.require(DefaultSemanticMemory.class, this.context, WorkingMemoryActivation.class);
        Agent agent = Adaptables.adapt(this.context, Agent.class);
        this.trace = agent.getTrace();
        PropertyManager properties = Adaptables.require(DefaultSemanticMemory.class, this.context, PropertyManager.class);
        this.params = new DefaultSemanticMemoryParams(properties);
        this.stats = new DefaultSemanticMemoryStats(properties);
    }

    @Override
    public void resetStatistics() {
        this.stats.reset();
    }

    @Override
    public SemanticMemoryStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public void initializeNewContext(WorkingMemory wm, IdentifierImpl id) {
        this.stateInfos.put(id, new SemanticMemoryStateInfo(this, wm, id));
    }

    SemanticMemoryDatabase getDatabase() {
        return this.db;
    }

    DefaultSemanticMemoryParams getParams() {
        return this.params;
    }

    DefaultSemanticMemoryStats getStats() {
        return this.stats;
    }

    private SemanticMemoryStateInfo smem_info(IdentifierImpl state) {
        return this.stateInfos.get(state);
    }

    @Override
    public boolean smem_enabled() {
        return this.params.learning.get() == DefaultSemanticMemoryParams.LearningChoices.on;
    }

    private List<WmeImpl> smem_get_direct_augs_of_id(SymbolImpl sym) {
        return this.smem_get_direct_augs_of_id(sym, null);
    }

    private List<WmeImpl> smem_get_direct_augs_of_id(SymbolImpl sym, Marker tc) {
        ArrayList<WmeImpl> return_val = new ArrayList<WmeImpl>();
        IdentifierImpl id = sym.asIdentifier();
        if (id != null) {
            WmeImpl w;
            if (tc != null) {
                if (tc == id.tc_number) {
                    return return_val;
                }
                id.tc_number = tc;
            }
            WmeImpl wmeImpl = w = id.goalInfo != null ? id.goalInfo.getImpasseWmes() : null;
            while (w != null) {
                if (!w.acceptable) {
                    return_val.add(w);
                }
                w = w.next;
            }
            w = id.getInputWmes();
            while (w != null) {
                return_val.add(w);
                w = w.next;
            }
            Slot s = id.slots;
            while (s != null) {
                WmeImpl w2 = s.getWmes();
                while (w2 != null) {
                    if (!w2.acceptable) {
                        return_val.add(w2);
                    }
                    w2 = w2.next;
                }
                s = s.next;
            }
        }
        return return_val;
    }

    private static boolean smem_symbol_is_constant(Symbol sym) {
        return Symbols.getSymbolType(sym) == 2 || Symbols.getSymbolType(sym) == 3 || Symbols.getSymbolType(sym) == 4;
    }

    private long smem_temporal_hash_add_type(int symbol_type) throws SQLException {
        this.db.hash_add_type.setInt(1, symbol_type);
        return JdbcTools.insertAndGetRowId(this.db.hash_add_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long smem_temporal_hash_int(long val, boolean add_on_fail) throws SQLException {
        long return_val = 0L;
        this.db.hash_get_int.setLong(1, val);
        try (ResultSet rs = this.db.hash_get_int.executeQuery();){
            if (rs.next()) {
                return_val = rs.getLong(1);
            }
        }
        if (return_val == 0L && add_on_fail) {
            return_val = this.smem_temporal_hash_add_type(3);
            this.db.hash_add_int.setLong(1, return_val);
            this.db.hash_add_int.setLong(2, val);
            this.db.hash_add_int.executeUpdate();
        }
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long smem_temporal_hash_float(double val, boolean add_on_fail) throws SQLException {
        long return_val = 0L;
        this.db.hash_get_float.setDouble(1, val);
        try (ResultSet rs = this.db.hash_get_float.executeQuery();){
            if (rs.next()) {
                return_val = rs.getLong(1);
            }
        }
        if (return_val == 0L && add_on_fail) {
            return_val = this.smem_temporal_hash_add_type(4);
            this.db.hash_add_float.setLong(1, return_val);
            this.db.hash_add_float.setDouble(2, val);
            this.db.hash_add_float.executeUpdate();
        }
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long smem_temporal_hash_str(String val, boolean add_on_fail) throws SQLException {
        long return_val = 0L;
        this.db.hash_get_str.setString(1, val);
        try (ResultSet rs = this.db.hash_get_str.executeQuery();){
            if (rs.next()) {
                return_val = rs.getLong(1);
            }
        }
        if (return_val == 0L && add_on_fail) {
            return_val = this.smem_temporal_hash_add_type(2);
            this.db.hash_add_str.setLong(1, return_val);
            this.db.hash_add_str.setString(2, val);
            this.db.hash_add_str.executeUpdate();
        }
        return return_val;
    }

    void _smem_process_buffered_wme_list(IdentifierImpl state, Set<WmeImpl> cue_wmes, List<WmeImpl.SymbolTriple> my_list, boolean meta) {
        if (my_list.isEmpty()) {
            return;
        }
        Instantiation inst = SoarModule.make_fake_instantiation(state, cue_wmes, my_list);
        Preference pref = inst.preferences_generated;
        while (pref != null) {
            this.recMem.add_preference_to_tm(pref);
            state.goalInfo.addGoalPreference(pref);
            pref.on_goal_list = true;
            if (meta) {
                this.smem_info((IdentifierImpl)state).smem_wmes.push(pref);
            }
            pref = pref.inst_next;
        }
        if (!meta) {
            ByRef<Object> my_justification_list = ByRef.create(null);
            this.chunker.chunk_instantiation(inst, false, my_justification_list);
            if (my_justification_list.value != null) {
                Instantiation next_justification = null;
                Instantiation my_justification = (Instantiation)my_justification_list.value;
                while (my_justification != null) {
                    next_justification = my_justification.nextInProdList;
                    if (my_justification.in_ms) {
                        my_justification.prod.instantiations = my_justification.insertAtHeadOfProdList(my_justification.prod.instantiations);
                    }
                    Preference just_pref = my_justification.preferences_generated;
                    while (just_pref != null) {
                        this.recMem.add_preference_to_tm(just_pref);
                        if (this.wma.wma_enabled()) {
                            this.wma.wma_activate_wmes_in_pref(just_pref);
                        }
                        just_pref = just_pref.inst_next;
                    }
                    my_justification = next_justification;
                }
            }
        }
    }

    private void smem_process_buffered_wmes(IdentifierImpl state, Set<WmeImpl> cue_wmes, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes) {
        this._smem_process_buffered_wme_list(state, cue_wmes, meta_wmes, true);
        this._smem_process_buffered_wme_list(state, cue_wmes, retrieval_wmes, false);
    }

    private void smem_buffer_add_wme(List<WmeImpl.SymbolTriple> my_list, IdentifierImpl id, SymbolImpl attr, SymbolImpl value) {
        my_list.add(new WmeImpl.SymbolTriple(id, attr, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean smem_variable_get(smem_variable_key variable_id, ByRef<Long> variable_value) throws SQLException {
        PreparedStatement var_get = this.db.var_get;
        var_get.setInt(1, variable_id.ordinal());
        try (ResultSet rs = var_get.executeQuery();){
            if (rs.next()) {
                variable_value.value = rs.getLong(1);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void smem_variable_set(smem_variable_key variable_id, long variable_value) throws SQLException {
        PreparedStatement var_set = this.db.var_set;
        var_set.setLong(1, variable_value);
        var_set.setInt(2, variable_id.ordinal());
        var_set.execute();
    }

    private void smem_variable_create(smem_variable_key variable_id, long variable_value) throws SQLException {
        PreparedStatement var_create = this.db.var_create;
        var_create.setInt(1, variable_id.ordinal());
        var_create.setLong(2, variable_value);
        var_create.execute();
    }

    private long smem_temporal_hash(SymbolImpl sym) throws SQLException {
        return this.smem_temporal_hash(sym, true);
    }

    private long smem_temporal_hash(SymbolImpl sym, boolean add_on_fail) throws SQLException {
        long return_val = 0L;
        if (DefaultSemanticMemory.smem_symbol_is_constant(sym)) {
            if (sym.smem_hash == 0L || sym.common_smem_valid != this.smem_validation) {
                sym.smem_hash = 0L;
                sym.common_smem_valid = this.smem_validation;
                switch (Symbols.getSymbolType(sym)) {
                    case 2: {
                        return_val = this.smem_temporal_hash_str(sym.asString().getValue(), add_on_fail);
                        break;
                    }
                    case 3: {
                        return_val = this.smem_temporal_hash_int(sym.asInteger().getValue(), add_on_fail);
                        break;
                    }
                    case 4: {
                        return_val = this.smem_temporal_hash_float(sym.asDouble().getValue(), add_on_fail);
                    }
                }
                sym.smem_hash = return_val;
                sym.common_smem_valid = this.smem_validation;
            }
            return_val = sym.smem_hash;
        }
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int smem_reverse_hash_int(long hash_value) throws SQLException {
        this.db.hash_rev_int.setLong(1, hash_value);
        try (ResultSet rs = this.db.hash_rev_int.executeQuery();){
            if (!rs.next()) {
                throw new IllegalStateException("Expected non-empty result");
            }
            int toReturn = rs.getInt(1);
            rs.close();
            int n = toReturn;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double smem_reverse_hash_float(long hash_value) throws SQLException {
        this.db.hash_rev_float.setLong(1, hash_value);
        try (ResultSet rs = this.db.hash_rev_float.executeQuery();){
            rs.next();
            double toReturn = rs.getDouble(1);
            rs.close();
            double d = toReturn;
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String smem_reverse_hash_str(long hash_value) throws SQLException {
        this.db.hash_rev_str.setLong(1, hash_value);
        try (ResultSet rs = this.db.hash_rev_str.executeQuery();){
            rs.next();
            String toReturn = rs.getString(1);
            rs.close();
            String string = toReturn;
            return string;
        }
    }

    private SymbolImpl smem_reverse_hash(int symbol_type, long hash_value) throws SQLException {
        switch (symbol_type) {
            case 2: {
                return this.symbols.createString(this.smem_reverse_hash_str(hash_value));
            }
            case 3: {
                return this.symbols.createInteger(this.smem_reverse_hash_int(hash_value));
            }
            case 4: {
                return this.symbols.createDouble(this.smem_reverse_hash_float(hash_value));
            }
        }
        return null;
    }

    public double smem_lti_calc_base(long lti, long time_now) {
        return this.smem_lti_calc_base(lti, time_now);
    }

    public double smem_lti_calc_base(long lti, long time_now, long n) throws SQLException {
        return this.smem_lti_calc_base(lti, time_now, n, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double smem_lti_calc_base(long lti, long time_now, long n, long activations_first) throws SQLException {
        long t_k;
        ResultSet rs;
        double sum = 0.0;
        double d = this.params.base_decay.get();
        long t_n = time_now - activations_first;
        if (n == 0L) {
            rs = null;
            try {
                this.db.lti_access_get.setLong(1, lti);
                rs = this.db.lti_access_get.executeQuery();
                n = rs.getLong(2);
                activations_first = rs.getLong(3);
            }
            finally {
                rs.close();
            }
        }
        rs = null;
        try {
            this.db.history_get.setLong(1, lti);
            rs = this.db.history_get.executeQuery();
            rs.next();
            int available_history = (int)(10L < n ? 10L : n);
            t_k = time_now - rs.getLong(available_history - 1 + 1);
            for (int i = 0; i < available_history; ++i) {
                sum += Math.pow(time_now - rs.getLong(i + 1), -d);
            }
        }
        finally {
            rs.close();
        }
        if (n > 10L) {
            double apx_numerator = (double)(n - 10L) * (Math.pow(t_n, 1.0 - d) - Math.pow(t_k, 1.0 - d));
            double apx_denominator = (1.0 - d) * (double)(t_n - t_k);
            sum += apx_numerator / apx_denominator;
        }
        return sum > 0.0 ? Math.log(sum) : -1.0E9;
    }

    double smem_lti_activate(long lti, boolean add_access) throws SQLException {
        return this.smem_lti_activate(lti, add_access, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double smem_lti_activate(long lti, boolean add_access, long num_edges) throws SQLException {
        long time_now;
        if (add_access) {
            time_now = this.smem_max_cycle++;
            if (this.params.activation_mode.get() == DefaultSemanticMemoryParams.ActivationChoices.base_level && this.params.base_update.get() == DefaultSemanticMemoryParams.BaseUpdateChoices.incremental) {
                Iterator<Long> b = this.params.base_incremental_threshes.get().iterator();
                while (b.hasNext()) {
                    long time_diff;
                    Long next = b.next();
                    if (next <= 0L || (time_diff = time_now - next) <= 0L) continue;
                    ArrayList<Long> to_update = new ArrayList<Long>();
                    try (ResultSet rs = null;){
                        this.db.lti_get_t.setLong(1, time_diff);
                        rs = this.db.lti_get_t.executeQuery();
                        while (rs.next()) {
                            to_update.add(rs.getLong(1));
                        }
                    }
                    for (Long l : to_update) {
                        this.smem_lti_activate(l, false);
                    }
                }
            }
        } else {
            time_now = this.smem_max_cycle;
            this.stats.act_updates.set(this.stats.act_updates.get() + 1L);
        }
        long prev_access_n = 0L;
        long prev_access_t = 0L;
        long prev_access_1 = 0L;
        try (ResultSet rs = null;){
            this.db.lti_access_get.setLong(1, lti);
            rs = this.db.lti_access_get.executeQuery();
            rs.next();
            prev_access_n = rs.getLong(1);
            prev_access_t = rs.getLong(2);
            prev_access_1 = rs.getLong(3);
        }
        if (add_access) {
            this.db.lti_access_set.setLong(1, prev_access_n + 1L);
            this.db.lti_access_set.setLong(2, time_now);
            this.db.lti_access_set.setLong(3, prev_access_n == 0L ? time_now : prev_access_1);
            this.db.lti_access_set.setLong(4, lti);
            this.db.lti_access_set.executeUpdate();
        }
        double new_activation = 0.0;
        DefaultSemanticMemoryParams.ActivationChoices act_mode = (DefaultSemanticMemoryParams.ActivationChoices)((Object)this.params.activation_mode.get());
        if (act_mode == DefaultSemanticMemoryParams.ActivationChoices.recency) {
            new_activation = time_now;
        } else if (act_mode == DefaultSemanticMemoryParams.ActivationChoices.frequency) {
            new_activation = prev_access_n + (long)(add_access ? 1 : 0);
        } else if (act_mode == DefaultSemanticMemoryParams.ActivationChoices.base_level) {
            if (prev_access_n == 0L) {
                if (add_access) {
                    this.db.history_add.setLong(1, lti);
                    this.db.history_add.setLong(2, time_now);
                    this.db.history_add.executeUpdate();
                }
                new_activation = 0.0;
            } else {
                if (add_access) {
                    this.db.history_push.setLong(1, time_now);
                    this.db.history_push.setLong(2, lti);
                    this.db.history_push.executeUpdate();
                }
                new_activation = this.smem_lti_calc_base(lti, time_now + (long)(add_access ? 1 : 0), prev_access_n + (long)(add_access ? 1 : 0), prev_access_1);
            }
        }
        if (num_edges == 0L) {
            try (ResultSet rs = null;){
                this.db.act_lti_child_ct_get.setLong(1, lti);
                rs = this.db.act_lti_child_ct_get.executeQuery();
                rs.next();
                num_edges = rs.getLong(1);
            }
        }
        if (num_edges < this.params.thresh.get()) {
            this.db.act_set.setDouble(1, new_activation);
            this.db.act_set.setLong(2, lti);
            this.db.act_set.executeUpdate();
        }
        this.db.act_lti_set.setDouble(1, new_activation);
        this.db.act_lti_set.setLong(2, lti);
        this.db.act_lti_set.executeUpdate();
        return new_activation;
    }

    private static void _smem_lti_from_test(Test t, Set<IdentifierImpl> valid_ltis) {
        if (Tests.isBlank(t)) {
            return;
        }
        EqualityTest eq = t.asEqualityTest();
        if (eq != null) {
            IdentifierImpl referent = eq.getReferent().asIdentifier();
            if (referent != null && referent.smem_lti != 0L) {
                valid_ltis.add(referent);
            }
            return;
        }
        ConjunctiveTest ct = t.asConjunctiveTest();
        if (ct != null) {
            for (Test c : ct.conjunct_list) {
                DefaultSemanticMemory._smem_lti_from_test(c, valid_ltis);
            }
        }
    }

    private static void _smem_lti_from_rhs_value(RhsValue rv, Set<IdentifierImpl> valid_ltis) {
        RhsSymbolValue rsv = rv.asSymbolValue();
        if (rsv != null) {
            IdentifierImpl sym = rsv.getSym().asIdentifier();
            if (sym != null && sym.smem_lti != 0L) {
                valid_ltis.add(sym);
            }
        } else {
            for (RhsValue c : rv.asFunctionCall().getArguments()) {
                DefaultSemanticMemory._smem_lti_from_rhs_value(c, valid_ltis);
            }
        }
    }

    public static boolean smem_valid_production(Condition lhs_top, Action rhs_top) {
        LinkedHashSet<IdentifierImpl> valid_ltis = new LinkedHashSet<IdentifierImpl>();
        Condition c = lhs_top;
        while (c != null) {
            PositiveCondition pc = c.asPositiveCondition();
            if (pc != null) {
                DefaultSemanticMemory._smem_lti_from_test(pc.attr_test, valid_ltis);
                DefaultSemanticMemory._smem_lti_from_test(pc.value_test, valid_ltis);
            }
            c = c.next;
        }
        int action_counter = 0;
        Action a = rhs_top;
        while (a != null) {
            a.already_in_tc = false;
            ++action_counter;
            a = a.next;
        }
        boolean good_pass = true;
        boolean good_action = true;
        while (good_pass && action_counter != 0) {
            good_pass = false;
            Action a2 = rhs_top;
            while (a2 != null) {
                if (!a2.already_in_tc) {
                    good_action = false;
                    MakeAction ma = a2.asMakeAction();
                    if (ma != null) {
                        IdentifierImpl id = ma.id.asSymbolValue().getSym().asIdentifier();
                        if (id == null) {
                            good_action = true;
                        } else if (id.smem_lti == 0L) {
                            good_action = true;
                        } else if (valid_ltis.contains(id)) {
                            good_action = true;
                        }
                    } else {
                        good_action = true;
                    }
                    if (good_action) {
                        a2.already_in_tc = true;
                        if (ma != null) {
                            DefaultSemanticMemory._smem_lti_from_rhs_value(ma.value, valid_ltis);
                            DefaultSemanticMemory._smem_lti_from_rhs_value(ma.attr, valid_ltis);
                        } else {
                            DefaultSemanticMemory._smem_lti_from_rhs_value(a2.asFunctionAction().getCall(), valid_ltis);
                        }
                        --action_counter;
                        good_pass = true;
                    }
                }
                a2 = a2.next;
            }
        }
        return action_counter == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long smem_lti_get_id(char name_letter, long name_number) throws SoarException {
        long return_val = 0L;
        this.smem_attach();
        try {
            this.db.lti_get.setLong(1, name_letter);
            this.db.lti_get.setLong(2, name_number);
            try (ResultSet rs = this.db.lti_get.executeQuery();){
                if (rs.next()) {
                    return_val = rs.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            throw new SoarException(e.getMessage(), e);
        }
        return return_val;
    }

    long smem_lti_add_id(char name_letter, long name_number) throws SQLException {
        long return_val = 0L;
        this.db.lti_add.setLong(1, name_letter);
        this.db.lti_add.setLong(2, name_number);
        this.db.lti_add.setLong(3, 0L);
        this.db.lti_add.setDouble(4, 0.0);
        this.db.lti_add.setLong(5, 0L);
        this.db.lti_add.setLong(6, 0L);
        this.db.lti_add.setLong(7, 0L);
        return_val = JdbcTools.insertAndGetRowId(this.db.lti_add);
        this.stats.nodes.set(this.stats.nodes.get() + 1L);
        return return_val;
    }

    private long smem_lti_soar_add(SymbolImpl s) throws SoarException, SQLException {
        IdentifierImpl id = s.asIdentifier();
        if (id != null && id.smem_lti == 0L) {
            id.smem_lti = this.smem_lti_get_id(id.getNameLetter(), id.getNameNumber());
            if (id.smem_lti == 0L) {
                id.smem_lti = this.smem_lti_add_id(id.getNameLetter(), id.getNameNumber());
                id.smem_time_id = this.epmem.getStats().getTime();
                id.id_smem_valid = this.epmem.epmem_validation();
                this.epmem.epmem_schedule_promotion(id);
            }
        }
        return id.smem_lti;
    }

    @Override
    public IdentifierImpl smem_lti_soar_make(long lti, char name_letter, long name_number, int level) {
        IdentifierImpl return_val = this.symbols.findIdentifier(name_letter, name_number);
        if (return_val == null) {
            return_val = this.symbols.make_new_identifier(name_letter, name_number, level);
        } else if (return_val.level == 0 && level != 0) {
            return_val.level = level;
            return_val.promotion_level = level;
        }
        return_val.smem_lti = lti;
        return return_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void smem_reset_id_counters() throws SoarException {
        if (this.db != null) {
            try (ResultSet rs = this.db.lti_max.executeQuery();){
                while (rs.next()) {
                    long name_letter = rs.getLong(1);
                    long letter_max = rs.getLong(2);
                    this.symbols.resetIdNumber((char)name_letter, letter_max);
                }
            }
            catch (SQLException e) {
                throw new SoarException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void smem_disconnect_chunk(long lti_id) throws SQLException {
        long pair_count = 0L;
        long child_attr = 0L;
        LinkedHashSet<Long> distinct_attr = new LinkedHashSet<Long>();
        this.db.web_all.setLong(1, lti_id);
        try (ResultSet webAllCounts = this.db.web_all.executeQuery();){
            while (webAllCounts.next()) {
                ++pair_count;
                child_attr = webAllCounts.getLong(1);
                distinct_attr.add(child_attr);
                if (webAllCounts.getLong(1) != 0L) {
                    this.db.wmes_constant_frequency_update.setInt(1, -1);
                    this.db.wmes_constant_frequency_update.setLong(2, child_attr);
                    this.db.wmes_constant_frequency_update.setInt(3, webAllCounts.getInt(2));
                    this.db.wmes_constant_frequency_update.executeUpdate();
                    continue;
                }
                this.db.wmes_constant_frequency_update.setInt(1, -1);
                this.db.wmes_constant_frequency_update.setLong(2, child_attr);
                this.db.wmes_constant_frequency_update.setInt(3, webAllCounts.getInt(3));
                this.db.wmes_constant_frequency_update.executeUpdate();
            }
        }
        for (Long a : distinct_attr) {
            this.db.attribute_frequency_update.setInt(1, -1);
            this.db.attribute_frequency_update.setLong(2, a);
            this.db.attribute_frequency_update.executeUpdate();
        }
        this.stats.edges.set(this.stats.edges.get() - pair_count);
        this.db.web_truncate.setLong(1, lti_id);
        this.db.web_truncate.executeUpdate();
    }

    void smem_store_chunk(long lti_id, Map<SymbolImpl, List<Object>> children) throws SQLException {
        this.smem_store_chunk(lti_id, children, true, null);
    }

    void smem_store_chunk(long lti_id, Map<SymbolImpl, List<Object>> children, boolean remove_old_children) throws SQLException {
        this.smem_store_chunk(lti_id, children, remove_old_children, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void smem_store_chunk(long lti_id, Map<SymbolImpl, List<Object>> children, boolean remove_old_children, IdentifierImpl print_id) throws SQLException {
        ResultSet rs;
        boolean after_above;
        long existing_edges = 0L;
        if (remove_old_children) {
            this.smem_disconnect_chunk(lti_id);
            if (print_id != null) {
                this.trace.startNewLine().print(Trace.Category.SMEM, "<=SMEM: (%s ^* *)", print_id);
            }
        } else {
            this.db.act_lti_child_ct_get.setLong(1, lti_id);
            try (ResultSet rs2 = null;){
                rs2 = this.db.act_lti_child_ct_get.executeQuery();
                rs2.next();
                existing_edges = rs2.getLong(1);
            }
        }
        LinkedHashSet<Long> attr_new = new LinkedHashSet<Long>();
        LinkedHashSet<SmemHashIdLongPair> const_new = new LinkedHashSet<SmemHashIdLongPair>();
        LinkedHashSet<SmemHashIdLongPair> lti_new = new LinkedHashSet<SmemHashIdLongPair>();
        long attr_hash = 0L;
        long value_hash = 0L;
        long value_lti = 0L;
        for (Map.Entry<SymbolImpl, List<Object>> s : children.entrySet()) {
            attr_hash = this.smem_temporal_hash(s.getKey());
            if (remove_old_children) {
                attr_new.add(attr_hash);
            } else {
                this.db.web_attr_child.setLong(1, lti_id);
                this.db.web_attr_child.setLong(2, attr_hash);
                try (ResultSet rs3 = null;){
                    rs3 = this.db.web_attr_child.executeQuery();
                    if (!rs3.next()) {
                        attr_new.add(attr_hash);
                    }
                }
            }
            for (Object v : s.getValue()) {
                SymbolImpl constant = Adaptables.adapt(v, SymbolImpl.class);
                if (constant != null) {
                    value_hash = this.smem_temporal_hash(constant);
                    if (remove_old_children) {
                        const_new.add(new SmemHashIdLongPair(attr_hash, value_hash));
                    } else {
                        this.db.web_const_child.setLong(1, lti_id);
                        this.db.web_const_child.setLong(2, attr_hash);
                        this.db.web_const_child.setLong(3, value_hash);
                        try (ResultSet rs4 = null;){
                            rs4 = this.db.web_const_child.executeQuery();
                            if (!rs4.next()) {
                                const_new.add(new SmemHashIdLongPair(attr_hash, value_hash));
                            }
                        }
                    }
                    this.trace.startNewLine().print(Trace.Category.SMEM, "=>SMEM: (%s ^%s %s)", print_id, s.getKey(), constant);
                    continue;
                }
                smem_chunk_lti vAsLti = (smem_chunk_lti)v;
                value_lti = vAsLti.lti_id;
                if (value_lti == 0L) {
                    vAsLti.lti_id = value_lti = this.smem_lti_add_id(vAsLti.lti_letter, vAsLti.lti_number);
                    if (vAsLti.soar_id != null) {
                        vAsLti.soar_id.smem_lti = value_lti;
                        vAsLti.soar_id.smem_time_id = this.epmem.getStats().getTime();
                        vAsLti.soar_id.id_smem_valid = this.epmem.epmem_validation();
                        this.epmem.epmem_schedule_promotion(vAsLti.soar_id);
                    }
                }
                if (remove_old_children) {
                    lti_new.add(new SmemHashIdLongPair(attr_hash, value_lti));
                } else {
                    this.db.web_lti_child.setLong(1, lti_id);
                    this.db.web_lti_child.setLong(2, attr_hash);
                    this.db.web_lti_child.setLong(3, value_lti);
                    try (ResultSet rs5 = null;){
                        rs5 = this.db.web_lti_child.executeQuery();
                        if (!rs5.next()) {
                            lti_new.add(new SmemHashIdLongPair(attr_hash, value_lti));
                        }
                    }
                }
                this.trace.startNewLine().print(Trace.Category.SMEM, "=>SMEM: (%s ^%s %s)", print_id, s.getKey(), vAsLti.soar_id);
            }
        }
        long new_edges = existing_edges + (long)const_new.size() + (long)lti_new.size();
        double web_act = 0.0;
        long thresh = this.params.thresh.get();
        boolean bl = after_above = new_edges >= thresh;
        if (existing_edges < thresh && after_above) {
            this.db.act_set.setDouble(1, web_act);
            this.db.act_set.setLong(2, lti_id);
            this.db.act_set.executeUpdate();
        }
        this.db.act_lti_child_ct_set.setLong(1, new_edges);
        this.db.act_lti_child_ct_set.setLong(2, lti_id);
        this.db.act_lti_child_ct_set.executeUpdate();
        double lti_act = this.smem_lti_activate(lti_id, true, new_edges);
        if (!after_above) {
            web_act = lti_act;
        }
        for (SmemHashIdLongPair pair : const_new) {
            this.db.web_add.setLong(1, lti_id);
            this.db.web_add.setLong(2, pair.getHashID());
            this.db.web_add.setLong(3, pair.getSecond());
            this.db.web_add.setLong(4, 0L);
            this.db.web_add.setDouble(5, web_act);
            this.db.web_add.executeUpdate();
            this.db.wmes_constant_frequency_check.setLong(1, pair.getHashID());
            this.db.wmes_constant_frequency_check.setLong(2, pair.getSecond());
            rs = null;
            try {
                rs = this.db.wmes_constant_frequency_check.executeQuery();
                if (!rs.next()) {
                    this.db.wmes_constant_frequency_add.setLong(1, pair.getHashID());
                    this.db.wmes_constant_frequency_add.setLong(2, pair.getSecond());
                    this.db.wmes_constant_frequency_add.executeUpdate();
                    continue;
                }
                this.db.wmes_constant_frequency_update.setLong(1, 1L);
                this.db.wmes_constant_frequency_update.setLong(2, pair.getHashID());
                this.db.wmes_constant_frequency_update.setLong(3, pair.getSecond());
                this.db.wmes_constant_frequency_update.executeUpdate();
            }
            finally {
                rs.close();
            }
        }
        for (SmemHashIdLongPair pair : lti_new) {
            this.db.web_add.setLong(1, lti_id);
            this.db.web_add.setLong(2, pair.getHashID());
            this.db.web_add.setLong(3, 0L);
            this.db.web_add.setLong(4, pair.getSecond());
            this.db.web_add.setDouble(5, web_act);
            this.db.web_add.executeUpdate();
            this.db.wmes_lti_frequency_check.setLong(1, pair.getHashID());
            this.db.wmes_lti_frequency_check.setLong(2, pair.getSecond());
            rs = null;
            try {
                rs = this.db.wmes_lti_frequency_check.executeQuery();
                if (!rs.next()) {
                    this.db.wmes_lti_frequency_add.setLong(1, pair.getHashID());
                    this.db.wmes_lti_frequency_add.setLong(2, pair.getSecond());
                    this.db.wmes_lti_frequency_add.executeUpdate();
                    continue;
                }
                this.db.wmes_lti_frequency_update.setLong(1, 1L);
                this.db.wmes_lti_frequency_update.setLong(2, pair.getHashID());
                this.db.wmes_lti_frequency_update.setLong(3, pair.getSecond());
                this.db.wmes_lti_frequency_update.executeUpdate();
            }
            finally {
                rs.close();
            }
        }
        for (Long a : attr_new) {
            this.db.attribute_frequency_check.setLong(1, a);
            rs = null;
            try {
                rs = this.db.attribute_frequency_check.executeQuery();
                if (!rs.next()) {
                    this.db.attribute_frequency_add.setLong(1, a);
                    this.db.attribute_frequency_add.executeUpdate();
                    continue;
                }
                this.db.attribute_frequency_update.setLong(1, 1L);
                this.db.attribute_frequency_update.setLong(2, a);
                this.db.attribute_frequency_update.executeUpdate();
            }
            finally {
                rs.close();
            }
        }
        this.stats.edges.set(this.stats.edges.get() + (long)(const_new.size() + lti_new.size()));
    }

    void smem_soar_store(IdentifierImpl id) throws SQLException, SoarException {
        this.smem_soar_store(id, smem_storage_type.store_level);
    }

    void smem_soar_store(IdentifierImpl id, smem_storage_type store_type) throws SQLException, SoarException {
        this.smem_soar_store(id, store_type, null);
    }

    void smem_soar_store(IdentifierImpl id, smem_storage_type store_type, Marker tc) throws SQLException, SoarException {
        if (store_type == smem_storage_type.store_recursive && tc == null) {
            tc = DefaultMarker.create();
        }
        ArrayList<IdentifierImpl> shorties = new ArrayList<IdentifierImpl>();
        List<WmeImpl> children = this.smem_get_direct_augs_of_id(id, tc);
        this.smem_lti_soar_add(id);
        LinkedHashMap<IdentifierImpl, smem_chunk_lti> sym_to_chunk = new LinkedHashMap<IdentifierImpl, smem_chunk_lti>();
        Map<SymbolImpl, List<Object>> map = smem_chunk_lti.newSlotMap();
        for (WmeImpl w : children) {
            Object v;
            List<Object> s = smem_chunk_lti.smem_make_slot(map, w.attr);
            if (w.value.symbol_is_constant()) {
                v = w.value;
            } else {
                IdentifierImpl valueId = w.value.asIdentifier();
                assert (valueId != null);
                smem_chunk_lti c = (smem_chunk_lti)sym_to_chunk.get(valueId);
                if (c == null) {
                    smem_chunk_lti lti = new smem_chunk_lti();
                    lti.lti_id = valueId.smem_lti;
                    lti.lti_letter = valueId.getNameLetter();
                    lti.lti_number = valueId.getNameNumber();
                    lti.slots = null;
                    lti.soar_id = valueId;
                    sym_to_chunk.put(valueId, lti);
                    c = lti;
                    if (store_type == smem_storage_type.store_recursive && c.lti_id == 0L) {
                        shorties.add(c.soar_id);
                    }
                }
                v = c;
            }
            s.add(v);
        }
        this.smem_store_chunk(id.smem_lti, map, true, id);
        for (SymbolImpl symbolImpl : shorties) {
            this.smem_soar_store(symbolImpl.asIdentifier(), smem_storage_type.store_recursive, tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void smem_install_memory(IdentifierImpl state, long lti_id, IdentifierImpl lti, boolean activate_lti, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes) throws SQLException {
        ResultSet rs;
        SemanticMemoryStateInfo info = this.smem_info(state);
        IdentifierImpl result_header = info.smem_result_header;
        boolean lti_created_here = false;
        if (lti == null) {
            this.db.lti_letter_num.setLong(1, lti_id);
            rs = this.db.lti_letter_num.executeQuery();
            try {
                if (!rs.next()) {
                    throw new IllegalStateException("Expected non-empty result");
                }
                lti = this.smem_lti_soar_make(lti_id, (char)rs.getLong(1), rs.getLong(2), result_header.level);
            }
            finally {
                rs.close();
            }
            lti_created_here = true;
        }
        if (activate_lti) {
            this.smem_lti_activate(lti_id, true);
        }
        this.smem_buffer_add_wme(meta_wmes, result_header, this.predefinedSyms.smem_sym_retrieved, lti);
        if (lti_created_here) {
            // empty if block
        }
        if (this.params.merge.get() == DefaultSemanticMemoryParams.MergeChoices.add || (lti.goalInfo == null || lti.goalInfo.getImpasseWmes() == null) && lti.getInputWmes() == null && lti.slots == null) {
            this.db.web_expand.setLong(1, lti_id);
            rs = this.db.web_expand.executeQuery();
            try {
                while (rs.next()) {
                    SymbolImpl attr_sym = this.smem_reverse_hash(rs.getInt(1), rs.getLong(2));
                    long lti_rs = rs.getLong(7);
                    SymbolImpl value_sym = lti_rs != 0L ? this.smem_lti_soar_make(lti_rs, (char)rs.getLong(5), rs.getLong(6), lti.level) : this.smem_reverse_hash(rs.getInt(3), rs.getLong(4));
                    this.smem_buffer_add_wme(retrieval_wmes, lti, attr_sym, value_sym);
                }
            }
            finally {
                rs.close();
            }
        }
    }

    PreparedStatement smem_setup_web_crawl(WeightedCueElement el) throws SQLException {
        PreparedStatement q = null;
        if (el.element_type == smem_cue_element_type.attr_t) {
            q = this.db.web_attr_all;
        } else if (el.element_type == smem_cue_element_type.value_const_t) {
            q = this.db.web_const_all;
            q.setLong(2, el.value_hash);
        } else if (el.element_type == smem_cue_element_type.value_lti_t) {
            q = this.db.web_lti_all;
            q.setLong(2, el.value_lti);
        }
        q.setLong(1, el.attr_hash);
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean _smem_process_cue_wme(WmeImpl w, boolean pos_cue, PriorityQueue<WeightedCueElement> weighted_pq, MathQuery mathQuery) throws SQLException {
        long value_hash;
        long value_lti;
        boolean good_wme = true;
        smem_cue_element_type element_type = null;
        PreparedStatement q = null;
        long attr_hash = this.smem_temporal_hash(w.attr, false);
        if (attr_hash == 0L) {
            if (!pos_cue) return good_wme;
            return false;
        }
        if (w.value.symbol_is_constant() && mathQuery == null) {
            value_lti = 0L;
            value_hash = this.smem_temporal_hash(w.value, false);
            element_type = smem_cue_element_type.value_const_t;
            if (value_hash != 0L) {
                q = this.db.wmes_constant_frequency_get;
                q.setLong(1, attr_hash);
                q.setLong(2, value_hash);
            } else {
                if (!pos_cue) return true;
                good_wme = false;
            }
        } else {
            value_lti = w.value.asIdentifier() != null ? w.value.asIdentifier().smem_lti : 0L;
            value_hash = 0L;
            if (value_lti == 0L) {
                q = this.db.attribute_frequency_get;
                q.setLong(1, attr_hash);
                element_type = smem_cue_element_type.attr_t;
            } else {
                q = this.db.wmes_lti_frequency_get;
                q.setLong(1, attr_hash);
                q.setLong(2, value_lti);
                element_type = smem_cue_element_type.value_lti_t;
            }
        }
        if (!good_wme) return good_wme;
        try (ResultSet rs = q.executeQuery();){
            if (rs.next()) {
                WeightedCueElement new_cue_element = new WeightedCueElement();
                new_cue_element.weight = rs.getLong(1);
                new_cue_element.attr_hash = attr_hash;
                new_cue_element.value_hash = value_hash;
                new_cue_element.value_lti = value_lti;
                new_cue_element.cue_element = w;
                new_cue_element.element_type = element_type;
                new_cue_element.pos_element = pos_cue;
                new_cue_element.mathElement = mathQuery;
                weighted_pq.add(new_cue_element);
                new_cue_element = null;
                return good_wme;
            }
            if (!pos_cue) return good_wme;
            good_wme = false;
            return good_wme;
        }
    }

    private MathQueryProcessResults processMathQuery(IdentifierImpl mathQuery, PriorityQueue<WeightedCueElement> weighted_pq) throws SQLException {
        boolean needFullSearch = false;
        HashSet<Symbol> uniqueMathQueryElements = new HashSet<Symbol>();
        List<WmeImpl> cue = this.smem_get_direct_augs_of_id(mathQuery);
        for (WmeImpl cue_p : cue) {
            List<WmeImpl> cueTypes = this.smem_get_direct_augs_of_id(cue_p.value);
            if (cueTypes.isEmpty()) {
                return new MathQueryProcessResults(false, false);
            }
            for (WmeImpl cueType : cueTypes) {
                if (cueType.attr == this.predefinedSyms.smem_sym_max) {
                    if (uniqueMathQueryElements.contains(this.predefinedSyms.smem_sym_max)) {
                        return new MathQueryProcessResults(false, false);
                    }
                    uniqueMathQueryElements.add(this.predefinedSyms.smem_sym_max);
                    needFullSearch = true;
                    this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryMax());
                    continue;
                }
                if (cueType.attr == this.predefinedSyms.smem_sym_min) {
                    if (uniqueMathQueryElements.contains(this.predefinedSyms.smem_sym_min)) {
                        return new MathQueryProcessResults(false, false);
                    }
                    uniqueMathQueryElements.add(this.predefinedSyms.smem_sym_min);
                    needFullSearch = true;
                    this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryMin());
                    continue;
                }
                if (cueType.attr == this.predefinedSyms.smem_sym_less) {
                    if (cueType.value.asDouble() != null) {
                        this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryLess(cueType.value.asDouble().getValue()));
                        continue;
                    }
                    if (cueType.value.asInteger() != null) {
                        this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryLess(cueType.value.asInteger().getValue()));
                        continue;
                    }
                    return new MathQueryProcessResults(false, false);
                }
                if (cueType.attr == this.predefinedSyms.smem_sym_greater) {
                    if (cueType.value.asDouble() != null) {
                        this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryGreater(cueType.value.asDouble().getValue()));
                        continue;
                    }
                    if (cueType.value.asInteger() != null) {
                        this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryGreater(cueType.value.asInteger().getValue()));
                        continue;
                    }
                    return new MathQueryProcessResults(false, false);
                }
                if (cueType.attr == this.predefinedSyms.smem_sym_less_or_equal) {
                    if (cueType.value.asDouble() != null) {
                        this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryLessOrEqual(cueType.value.asDouble().getValue()));
                        continue;
                    }
                    if (cueType.value.asInteger() != null) {
                        this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryLessOrEqual(cueType.value.asInteger().getValue()));
                        continue;
                    }
                    return new MathQueryProcessResults(false, false);
                }
                if (cueType.attr != this.predefinedSyms.smem_sym_greater_or_equal) continue;
                if (cueType.value.asDouble() != null) {
                    this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryGreaterOrEqual(cueType.value.asDouble().getValue()));
                    continue;
                }
                if (cueType.value.asInteger() != null) {
                    this._smem_process_cue_wme(cue_p, true, weighted_pq, new MathQueryGreaterOrEqual(cueType.value.asInteger().getValue()));
                    continue;
                }
                return new MathQueryProcessResults(false, false);
            }
        }
        return new MathQueryProcessResults(needFullSearch, true);
    }

    long smem_process_query(IdentifierImpl state, IdentifierImpl query, IdentifierImpl negquery, IdentifierImpl math, Set<Long> prohibit, Set<WmeImpl> cue_wmes, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes) throws SQLException {
        return this.smem_process_query(state, query, negquery, math, prohibit, cue_wmes, meta_wmes, retrieval_wmes, smem_query_levels.qry_full);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long smem_process_query(IdentifierImpl state, IdentifierImpl query, IdentifierImpl negquery, IdentifierImpl mathQuery, Set<Long> prohibit, Set<WmeImpl> cue_wmes, List<WmeImpl.SymbolTriple> meta_wmes, List<WmeImpl.SymbolTriple> retrieval_wmes, smem_query_levels query_level) throws SQLException {
        long king_id;
        SemanticMemoryStateInfo smem_info;
        block59: {
            smem_info = this.smem_info(state);
            ArrayList weighted_cue = new ArrayList();
            boolean good_cue = true;
            boolean needFullSearch = false;
            king_id = 0L;
            PriorityQueue<WeightedCueElement> weighted_pq = WeightedCueElement.newPriorityQueue();
            List<WmeImpl> cue = this.smem_get_direct_augs_of_id(query);
            if (cue.isEmpty()) {
                good_cue = false;
            }
            for (WmeImpl cue_p : cue) {
                cue_wmes.add(cue_p);
                if (!good_cue) continue;
                good_cue = this._smem_process_cue_wme(cue_p, true, weighted_pq, null);
            }
            if (mathQuery != null && good_cue) {
                MathQueryProcessResults mpr = this.processMathQuery(mathQuery, weighted_pq);
                good_cue = mpr.goodCue;
                needFullSearch = mpr.needFullSearch;
            }
            if (negquery != null) {
                cue = this.smem_get_direct_augs_of_id(negquery);
                for (WmeImpl cue_p : cue) {
                    cue_wmes.add(cue_p);
                    if (!good_cue) continue;
                    good_cue = this._smem_process_cue_wme(cue_p, false, weighted_pq, null);
                }
            }
            if (good_cue) {
                while (!weighted_pq.isEmpty()) {
                    weighted_cue.add(weighted_pq.remove());
                }
            } else {
                while (!weighted_pq.isEmpty()) {
                    weighted_pq.remove();
                }
            }
            if (good_cue && !weighted_cue.isEmpty()) {
                WeightedCueElement cand_set = null;
                for (WeightedCueElement next_element : weighted_cue) {
                    if (!next_element.pos_element) continue;
                    cand_set = next_element;
                    break;
                }
                PreparedStatement q = null;
                PreparedStatement q2 = null;
                if (this.params.activation_mode.get() == DefaultSemanticMemoryParams.ActivationChoices.base_level && this.params.base_update.get() == DefaultSemanticMemoryParams.BaseUpdateChoices.naive) {
                    q = this.smem_setup_web_crawl(cand_set);
                    LinkedHashSet<Long> to_update = new LinkedHashSet<Long>();
                    try (ResultSet rs = q.executeQuery();){
                        while (rs.next()) {
                            to_update.add(rs.getLong(1));
                        }
                    }
                    for (Long lti : to_update) {
                        this.smem_lti_activate(lti, false);
                    }
                }
                q = this.smem_setup_web_crawl(cand_set);
                this.lastCue = new BasicWeightedCue(cand_set.cue_element, cand_set.weight);
                try (ResultSet qrs = q.executeQuery();){
                    if (!qrs.next()) break block59;
                    PriorityQueue<ActivatedLti> plentiful_parents = ActivatedLti.newPriorityQueue();
                    boolean more_rows = true;
                    boolean use_db = false;
                    boolean has_feature = false;
                    while (more_rows && qrs.getDouble(2) == 0.0) {
                        this.db.act_lti_get.setLong(1, qrs.getLong(1));
                        try (ResultSet actLtiGetRs = this.db.act_lti_get.executeQuery();){
                            if (!actLtiGetRs.next()) {
                                throw new IllegalStateException("act_lti_get did not return a result");
                            }
                            plentiful_parents.add(new ActivatedLti(actLtiGetRs.getLong(1), qrs.getLong(1)));
                        }
                        more_rows = qrs.next();
                    }
                    while (!(king_id != 0L && !needFullSearch || !more_rows && plentiful_parents.isEmpty())) {
                        long cand;
                        use_db = false;
                        if (!more_rows) {
                            use_db = false;
                        } else if (plentiful_parents.isEmpty()) {
                            use_db = true;
                        } else {
                            boolean bl = use_db = qrs.getDouble(2) > plentiful_parents.peek().first;
                        }
                        if (use_db) {
                            cand = qrs.getLong(1);
                            more_rows = qrs.next();
                        } else {
                            cand = ((ActivatedLti)plentiful_parents.remove()).second;
                        }
                        if (prohibit.contains(cand)) continue;
                        boolean good_cand = true;
                        Iterator it = weighted_cue.iterator();
                        while (good_cand && it.hasNext()) {
                            WeightedCueElement next_element = (WeightedCueElement)it.next();
                            if (next_element == cand_set && next_element.mathElement == null) continue;
                            if (next_element.element_type == smem_cue_element_type.attr_t) {
                                q2 = this.db.web_attr_child;
                            } else if (next_element.element_type == smem_cue_element_type.value_const_t) {
                                q2 = this.db.web_const_child;
                                q2.setLong(3, next_element.value_hash);
                            } else if (next_element.element_type == smem_cue_element_type.value_lti_t) {
                                q2 = this.db.web_lti_child;
                                q2.setLong(3, next_element.value_lti);
                            }
                            q2.setLong(1, cand);
                            q2.setLong(2, next_element.attr_hash);
                            try (ResultSet q2rs = q2.executeQuery();){
                                has_feature = q2rs.next();
                                boolean mathQueryMet = false;
                                if (next_element.mathElement != null && has_feature) {
                                    do {
                                        long valueHash = q2rs.getLong(2);
                                        this.db.hash_rev_type.setLong(1, valueHash);
                                        ResultSet rs = this.db.hash_rev_type.executeQuery();
                                        if (!rs.next()) {
                                            good_cand = false;
                                        } else {
                                            int valueType = rs.getInt(1);
                                            switch (valueType) {
                                                case 4: {
                                                    mathQueryMet |= next_element.mathElement.valueIsAcceptable(this.smem_reverse_hash_float(valueHash));
                                                    break;
                                                }
                                                case 3: {
                                                    mathQueryMet |= next_element.mathElement.valueIsAcceptable(this.smem_reverse_hash_int(valueHash));
                                                }
                                            }
                                        }
                                        rs.close();
                                    } while (q2rs.next());
                                    good_cand = mathQueryMet;
                                } else {
                                    boolean bl = next_element.pos_element ? has_feature : (good_cand = !has_feature);
                                }
                                if (good_cand) continue;
                                break;
                            }
                        }
                        if (good_cand) {
                            king_id = cand;
                            for (WeightedCueElement wce : weighted_cue) {
                                if (wce.mathElement == null) continue;
                                wce.mathElement.commit();
                            }
                            continue;
                        }
                        for (WeightedCueElement wce : weighted_cue) {
                            if (wce.mathElement == null) continue;
                            wce.mathElement.rollback();
                        }
                    }
                }
            }
        }
        if (query_level == smem_query_levels.qry_full) {
            if (king_id != 0L) {
                this.smem_buffer_add_wme(meta_wmes, smem_info.smem_result_header, this.predefinedSyms.smem_sym_success, query);
                if (negquery != null) {
                    this.smem_buffer_add_wme(meta_wmes, smem_info.smem_result_header, this.predefinedSyms.smem_sym_success, negquery);
                }
                this.smem_install_memory(state, king_id, null, this.params.activate_on_query.get() == DefaultSemanticMemoryParams.ActivateOnQueryChoices.on, meta_wmes, retrieval_wmes);
            } else {
                this.smem_buffer_add_wme(meta_wmes, smem_info.smem_result_header, this.predefinedSyms.smem_sym_failure, query);
                if (negquery != null) {
                    this.smem_buffer_add_wme(meta_wmes, smem_info.smem_result_header, this.predefinedSyms.smem_sym_failure, negquery);
                }
            }
        }
        return king_id;
    }

    void smem_clear_result(IdentifierImpl state) {
        SemanticMemoryStateInfo smem_info = this.smem_info(state);
        while (!smem_info.smem_wmes.isEmpty()) {
            Preference pref = smem_info.smem_wmes.remove();
            if (!pref.isInTempMemory()) continue;
            this.recMem.remove_preference_from_tm(pref);
        }
    }

    @Override
    public void smem_reset(IdentifierImpl state) {
        if (state == null) {
            state = this.decider.top_goal;
        }
        while (state != null) {
            SemanticMemoryStateInfo data = this.stateInfos.remove(state);
            data.last_cmd_time[0] = 0L;
            data.last_cmd_time[1] = 0L;
            data.last_cmd_count[0] = 0L;
            data.last_cmd_count[1] = 0L;
            data.smem_wmes.clear();
            state = state.goalInfo.lower_goal;
        }
    }

    void smem_switch_to_memory_db(String buf) throws SoarException, SQLException, IOException {
        this.trace.print(buf);
        this.params.path.set(":memory:");
        this.db.getConnection().close();
        this.db = null;
        this.smem_init_db(false);
    }

    void smem_init_db() throws SoarException, SQLException, IOException {
        this.smem_init_db(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void smem_init_db(boolean readonly) throws SoarException, SQLException, IOException {
        if (this.db != null) {
            return;
        }
        String jdbcUrl = URLDecoder.decode(this.params.protocol.get() + ":" + this.params.path.get(), "UTF-8");
        Connection connection = JdbcTools.connect(this.params.driver.get(), jdbcUrl);
        DatabaseMetaData meta = connection.getMetaData();
        logger.info("Opened database '" + jdbcUrl + "' with " + meta.getDriverName() + ":" + meta.getDriverVersion());
        if (this.params.path.get().equals(":memory:")) {
            this.trace.print(Trace.Category.SMEM, "SMem| Initializing semantic memory database in cpu memory.\n");
        } else {
            this.trace.print(Trace.Category.SMEM, "SMem| Initializing semantic memory memory database at %s\n", this.params.path.get());
        }
        this.db = new SemanticMemoryDatabase(this.params.driver.get(), connection);
        this.applyDatabasePerformanceOptions();
        ++this.smem_validation;
        boolean tabula_rasa = this.db.structure();
        this.db.prepare();
        if (!":memory:".equals(this.params.path.get())) {
            try (ResultSet result = this.db.get_schema_version.executeQuery();){
                if (result.next()) {
                    String schemaVersion = result.getString(1);
                    if (!"2.0".equals(schemaVersion)) {
                        logger.error("Incorrect database version, switching to memory.  Found version: " + schemaVersion);
                        this.params.path.set(":memory:");
                        connection.close();
                        this.db = null;
                        this.smem_init_db(readonly);
                    }
                } else if (this.params.append_db.get() == DefaultSemanticMemoryParams.AppendDatabaseChoices.on) {
                    logger.info("The selected database contained no data to append on.  New tables created.");
                }
            }
        }
        this.db.set_schema_version.setString(1, "2.0");
        this.db.set_schema_version.execute();
        if (this.params.append_db.get() == DefaultSemanticMemoryParams.AppendDatabaseChoices.off) {
            this.db.dropSmemTables();
            this.db.structure();
            this.db.prepare();
        }
        if (tabula_rasa) {
            this.db.begin.executeUpdate();
            this.smem_max_cycle = 1L;
            this.smem_variable_create(smem_variable_key.var_max_cycle, this.smem_max_cycle);
            this.stats.nodes.set(0L);
            this.smem_variable_create(smem_variable_key.var_num_nodes, this.stats.nodes.get());
            this.stats.edges.set(0L);
            this.smem_variable_create(smem_variable_key.var_num_edges, this.stats.edges.get());
            this.smem_variable_create(smem_variable_key.var_act_thresh, this.params.thresh.get());
            this.smem_variable_create(smem_variable_key.var_act_mode, ((DefaultSemanticMemoryParams.ActivationChoices)((Object)this.params.activation_mode.get())).ordinal());
            this.db.commit.executeUpdate();
        } else {
            ByRef<Long> tempMaxCycle = ByRef.create(this.smem_max_cycle);
            this.smem_variable_get(smem_variable_key.var_max_cycle, tempMaxCycle);
            this.smem_max_cycle = (Long)tempMaxCycle.value;
            ByRef<Long> temp = ByRef.create(0L);
            this.smem_variable_get(smem_variable_key.var_act_thresh, temp);
            this.params.thresh.set((Long)temp.value);
            this.smem_variable_get(smem_variable_key.var_num_nodes, temp);
            this.stats.nodes.set((Long)temp.value);
            this.smem_variable_get(smem_variable_key.var_num_edges, temp);
            this.stats.edges.set((Long)temp.value);
            this.smem_variable_get(smem_variable_key.var_act_mode, temp);
            this.params.activation_mode.set(DefaultSemanticMemoryParams.ActivationChoices.values()[Integer.parseInt(((Long)temp.value).toString())]);
        }
        this.smem_reset_id_counters();
        if (this.params.lazy_commit.get() == DefaultSemanticMemoryParams.LazyCommitChoices.on) {
            this.db.begin.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDatabasePerformanceOptions() throws SQLException, SoarException, IOException {
        if (this.params.driver.get().equals("org.sqlite.JDBC")) {
            long cacheSize = this.params.cache_size.get();
            try (Statement s = this.db.getConnection().createStatement();){
                s.execute("PRAGMA cache_size = " + cacheSize);
            }
        }
        if (this.params.optimization.get() == DefaultSemanticMemoryParams.Optimization.performance) {
            String perfResource = this.params.driver.get() + ".performance.sql";
            InputStream perfStream = this.getClass().getResourceAsStream(perfResource);
            String fullPath = "/" + this.getClass().getCanonicalName().replace('.', '/') + "/" + perfResource;
            if (perfStream != null) {
                logger.info("Applying performance settings from '" + fullPath + "'.");
                try {
                    JdbcTools.executeSql(this.db.getConnection(), perfStream, null);
                }
                finally {
                    perfStream.close();
                }
            } else {
                logger.warn("Could not find performance resource at '" + fullPath + "'. No performance settings applied.");
            }
        }
        if (this.params.driver.get().equals("org.sqlite.JDBC")) {
            DefaultSemanticMemoryParams.PageChoices pageSize = (DefaultSemanticMemoryParams.PageChoices)((Object)this.params.page_size.get());
            long pageSizeLong = 0L;
            switch (pageSize) {
                case page_16k: {
                    pageSizeLong = 16384L;
                    break;
                }
                case page_1k: {
                    pageSizeLong = 1024L;
                    break;
                }
                case page_2k: {
                    pageSizeLong = 2048L;
                    break;
                }
                case page_32k: {
                    pageSizeLong = 32768L;
                    break;
                }
                case page_4k: {
                    pageSizeLong = 4096L;
                    break;
                }
                case page_64k: {
                    pageSizeLong = 65536L;
                    break;
                }
                case page_8k: {
                    pageSizeLong = 8192L;
                    break;
                }
            }
            try (Statement s = this.db.getConnection().createStatement();){
                s.execute("PRAGMA page_size = " + pageSizeLong);
            }
        }
    }

    @Override
    public void smem_attach() throws SoarException {
        if (this.db == null) {
            try {
                this.smem_init_db();
            }
            catch (SQLException e) {
                throw new SoarException("While attaching SMEM: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new SoarException("While attaching SMEM: " + e.getMessage(), e);
            }
        }
    }

    void _smem_close_vars() throws SQLException {
        this.smem_variable_set(smem_variable_key.var_max_cycle, this.smem_max_cycle);
        this.smem_variable_set(smem_variable_key.var_num_nodes, this.stats.nodes.get());
        this.smem_variable_set(smem_variable_key.var_num_edges, this.stats.edges.get());
    }

    @Override
    public void smem_close() throws SoarException {
        if (this.db != null) {
            try {
                this._smem_close_vars();
                if (this.params.lazy_commit.get() == DefaultSemanticMemoryParams.LazyCommitChoices.on) {
                    this.db.commit.executeUpdate();
                }
                this.db.getConnection().close();
                this.db = null;
            }
            catch (SQLException e) {
                throw new SoarException("While closing SMEM: " + e.getMessage(), e);
            }
        }
    }

    static void smem_deallocate_chunk(smem_chunk_lti chunk) {
        DefaultSemanticMemory.smem_deallocate_chunk(chunk, true);
    }

    static void smem_deallocate_chunk(smem_chunk_lti chunk, boolean free_chunk) {
        if (chunk != null) {
            chunk.slots = null;
        }
    }

    static ParsedLtiName smem_parse_lti_name(Lexeme lexeme) {
        if (lexeme.type == LexemeType.IDENTIFIER) {
            return new ParsedLtiName(String.format("%c%d", Character.valueOf(lexeme.id_letter), lexeme.id_number), lexeme.id_letter, lexeme.id_number);
        }
        return new ParsedLtiName(lexeme.string, Character.toUpperCase(lexeme.string.charAt(1)), 0L);
    }

    static SymbolImpl smem_parse_constant_attr(SymbolFactoryImpl syms, Lexeme lexeme) {
        SymbolImpl return_val = lexeme.type == LexemeType.SYM_CONSTANT ? syms.createString(lexeme.string) : (lexeme.type == LexemeType.INTEGER ? syms.createInteger(lexeme.int_val) : (lexeme.type == LexemeType.FLOAT ? syms.createDouble(lexeme.float_val) : null));
        return return_val;
    }

    static boolean smem_parse_chunk(SymbolFactoryImpl symbols, Lexer lexer, Map<String, smem_chunk_lti> chunks, Set<smem_chunk_lti> newbies) throws IOException {
        boolean return_val = false;
        smem_chunk_lti new_chunk = null;
        boolean good_at = false;
        ParsedLtiName chunk_name = null;
        lexer.getNextLexeme();
        if (lexer.getCurrentLexeme().type == LexemeType.AT || lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER || lexer.getCurrentLexeme().type == LexemeType.VARIABLE) {
            good_at = true;
            if (lexer.getCurrentLexeme().type == LexemeType.AT) {
                lexer.getNextLexeme();
                boolean bl = good_at = lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER;
            }
            if (good_at) {
                chunk_name = DefaultSemanticMemory.smem_parse_lti_name(lexer.getCurrentLexeme());
                new_chunk = new smem_chunk_lti();
                new_chunk.lti_letter = chunk_name.id_letter;
                new_chunk.lti_number = chunk_name.id_number;
                new_chunk.lti_id = 0L;
                new_chunk.soar_id = null;
                new_chunk.slots = smem_chunk_lti.newSlotMap();
                lexer.getNextLexeme();
                long intermediate_counter = 1L;
                while (lexer.getCurrentLexeme().type == LexemeType.UP_ARROW) {
                    List<Object> s;
                    smem_chunk_lti intermediate_parent = new_chunk;
                    lexer.getNextLexeme();
                    SymbolImpl chunk_attr = DefaultSemanticMemory.smem_parse_constant_attr(symbols, lexer.getCurrentLexeme());
                    if (chunk_attr == null) continue;
                    lexer.getNextLexeme();
                    while (lexer.getCurrentLexeme().type == LexemeType.PERIOD) {
                        smem_chunk_lti temp_chunk = new smem_chunk_lti();
                        temp_chunk.lti_letter = (char)(chunk_attr.asString() != null ? (int)chunk_attr.getFirstLetter() : 88);
                        ++intermediate_counter;
                        temp_chunk.lti_number = temp_chunk.lti_number;
                        temp_chunk.lti_id = 0L;
                        temp_chunk.slots = smem_chunk_lti.newSlotMap();
                        temp_chunk.soar_id = null;
                        s = smem_chunk_lti.smem_make_slot(intermediate_parent.slots, chunk_attr);
                        s.add(temp_chunk);
                        String temp_key = String.format("<%c#%d>", Character.valueOf(temp_chunk.lti_letter), temp_chunk.lti_number);
                        chunks.put(temp_key, temp_chunk);
                        newbies.add(temp_chunk);
                        intermediate_parent = temp_chunk;
                        lexer.getNextLexeme();
                        chunk_attr = DefaultSemanticMemory.smem_parse_constant_attr(symbols, lexer.getCurrentLexeme());
                        lexer.getNextLexeme();
                    }
                    if (chunk_attr == null) continue;
                    Object chunk_value = null;
                    do {
                        chunk_value = null;
                        if (lexer.getCurrentLexeme().type == LexemeType.SYM_CONSTANT) {
                            chunk_value = symbols.createString(lexer.getCurrentLexeme().string);
                        } else if (lexer.getCurrentLexeme().type == LexemeType.INTEGER) {
                            chunk_value = symbols.createInteger(lexer.getCurrentLexeme().int_val);
                        } else if (lexer.getCurrentLexeme().type == LexemeType.FLOAT) {
                            chunk_value = symbols.createDouble(lexer.getCurrentLexeme().float_val);
                        } else if (lexer.getCurrentLexeme().type == LexemeType.AT || lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER || lexer.getCurrentLexeme().type == LexemeType.VARIABLE) {
                            good_at = true;
                            if (lexer.getCurrentLexeme().type == LexemeType.AT) {
                                lexer.getNextLexeme();
                                boolean bl = good_at = lexer.getCurrentLexeme().type == LexemeType.IDENTIFIER;
                            }
                            if (good_at) {
                                ParsedLtiName temp_key2 = DefaultSemanticMemory.smem_parse_lti_name(lexer.getCurrentLexeme());
                                smem_chunk_lti p = chunks.get(temp_key2.value);
                                if (p != null) {
                                    chunk_value = p;
                                } else {
                                    smem_chunk_lti temp_chunk = new smem_chunk_lti();
                                    temp_chunk.lti_letter = temp_key2.id_letter;
                                    temp_chunk.lti_number = temp_key2.id_number;
                                    temp_chunk.lti_id = 0L;
                                    temp_chunk.slots = null;
                                    temp_chunk.soar_id = null;
                                    chunks.put(temp_key2.value, temp_chunk);
                                    newbies.add(temp_chunk);
                                    chunk_value = temp_chunk;
                                }
                            }
                        }
                        if (chunk_value == null) continue;
                        lexer.getNextLexeme();
                        s = smem_chunk_lti.smem_make_slot(intermediate_parent.slots, chunk_attr);
                        s.add(chunk_value);
                        if (lexer.getCurrentLexeme().type != LexemeType.R_PAREN) continue;
                        return_val = true;
                        lexer.getNextLexeme();
                        chunk_value = null;
                    } while (chunk_value != null);
                }
            }
        }
        if (return_val) {
            smem_chunk_lti p = chunks.get(chunk_name.value);
            if (p == null) {
                chunks.put(chunk_name.value, new_chunk);
                newbies.add(new_chunk);
            } else {
                if (p.slots == null) {
                    p.slots = new_chunk.slots;
                } else {
                    for (Map.Entry<SymbolImpl, List<Object>> ss_p : new_chunk.slots.entrySet()) {
                        List<Object> target_slot = smem_chunk_lti.smem_make_slot(p.slots, ss_p.getKey());
                        List<Object> source_slot = ss_p.getValue();
                        target_slot.addAll(source_slot);
                    }
                }
                new_chunk.slots = null;
                newbies.add(p);
                DefaultSemanticMemory.smem_deallocate_chunk(new_chunk);
            }
        } else {
            newbies.clear();
        }
        return return_val;
    }

    boolean smem_parse_chunks(String chunkString) throws SoarException {
        try {
            return this.smem_parse_chunks_safe(chunkString);
        }
        catch (IOException e) {
            throw new SoarException(e);
        }
        catch (SQLException e) {
            throw new SoarException(e);
        }
    }

    private boolean smem_parse_chunks_safe(String chunkString) throws SoarException, IOException, SQLException {
        boolean return_val = false;
        long clause_count = 0L;
        this.smem_attach();
        StringWriter errorWriter = new StringWriter();
        Lexer lexer = new Lexer(new Printer(errorWriter), new StringReader(chunkString));
        lexer.setAllowIds(true);
        lexer.getNextLexeme();
        boolean good_chunk = true;
        LinkedHashMap<String, smem_chunk_lti> chunks = new LinkedHashMap<String, smem_chunk_lti>();
        LinkedHashSet<smem_chunk_lti> newbies = new LinkedHashSet<smem_chunk_lti>();
        lexer.getNextLexeme();
        if (lexer.getCurrentLexeme().type == LexemeType.L_BRACE) {
            good_chunk = false;
        }
        while (lexer.getCurrentLexeme().type == LexemeType.L_PAREN && good_chunk) {
            good_chunk = DefaultSemanticMemory.smem_parse_chunk(this.symbols, lexer, chunks, newbies);
            if (!good_chunk) continue;
            for (smem_chunk_lti c_new : newbies) {
                if (c_new.lti_id != 0L) continue;
                if (c_new.lti_number == 0L) {
                    c_new.lti_number = this.symbols.incrementIdNumber(c_new.lti_letter);
                    c_new.lti_id = this.smem_lti_add_id(c_new.lti_letter, c_new.lti_number);
                    continue;
                }
                if (c_new.lti_id != 0L) continue;
                c_new.lti_id = this.smem_lti_get_id(c_new.lti_letter, c_new.lti_number);
                if (c_new.lti_id != 0L) continue;
                c_new.lti_id = this.smem_lti_add_id(c_new.lti_letter, c_new.lti_number);
                IdentifierImpl id_parent = this.symbols.findIdentifier(c_new.lti_letter, c_new.lti_number);
                if (id_parent == null) continue;
                id_parent.smem_lti = c_new.lti_id;
                id_parent.smem_time_id = this.epmem.getStats().getTime();
            }
            for (smem_chunk_lti c_new : newbies) {
                if (c_new.slots == null) continue;
                this.smem_store_chunk(c_new.lti_id, c_new.slots, false);
            }
            for (smem_chunk_lti c_new : newbies) {
                DefaultSemanticMemory.smem_deallocate_chunk(c_new, false);
            }
            newbies.clear();
            ++clause_count;
        }
        return_val = good_chunk;
        for (smem_chunk_lti c_old : chunks.values()) {
            DefaultSemanticMemory.smem_deallocate_chunk(c_old, true);
        }
        chunks.clear();
        if (!return_val) {
            throw new SoarException("Error parsing clause #" + clause_count);
        }
        return return_val;
    }

    void smem_respond_to_cmd(boolean store_only) throws SQLException, SoarException {
        boolean mirroring_on;
        IdentifierImpl state = this.decider.bottom_goal;
        ArrayList<WmeImpl.SymbolTriple> meta_wmes = new ArrayList<WmeImpl.SymbolTriple>();
        ArrayList<WmeImpl.SymbolTriple> retrieval_wmes = new ArrayList<WmeImpl.SymbolTriple>();
        LinkedHashSet<WmeImpl> cue_wmes = new LinkedHashSet<WmeImpl>();
        ArrayList<IdentifierImpl> prohibit = new ArrayList<IdentifierImpl>();
        ArrayList<IdentifierImpl> store = new ArrayList<IdentifierImpl>();
        int time_slot = store_only ? 1 : 0;
        ArrayDeque<IdentifierImpl> syms = new ArrayDeque<IdentifierImpl>();
        ArrayDeque<Integer> levels = new ArrayDeque<Integer>();
        boolean do_wm_phase = false;
        boolean bl = mirroring_on = this.params.mirroring.get() == DefaultSemanticMemoryParams.MirroringChoices.on;
        if (!store_only) {
            this.lastCue = null;
        }
        while (state != null) {
            SemanticMemoryStateInfo smem_info = this.smem_info(state);
            boolean bl2 = false;
            long wme_count = 0L;
            List<WmeImpl> cmds = null;
            DefaultMarker tc = DefaultMarker.create();
            syms.add(smem_info.smem_cmd_header);
            levels.add(0);
            while (!syms.isEmpty()) {
                IdentifierImpl parent_sym = (IdentifierImpl)syms.remove();
                int parent_level = (Integer)levels.remove();
                List<WmeImpl> wmes = this.smem_get_direct_augs_of_id(parent_sym, tc);
                for (WmeImpl wmeImpl : wmes) {
                    if ((!store_only || parent_level == 0 && wmeImpl.attr != this.predefinedSyms.smem_sym_store) && (store_only || parent_level == 0 && wmeImpl.attr == this.predefinedSyms.smem_sym_store)) continue;
                    ++wme_count;
                    if ((long)wmeImpl.timetag > smem_info.last_cmd_time[time_slot]) {
                        bl2 = true;
                        smem_info.last_cmd_time[time_slot] = wmeImpl.timetag;
                    }
                    if (wmeImpl.value.asIdentifier() == null || parent_level != 0 || wmeImpl.attr != this.predefinedSyms.smem_sym_query && wmeImpl.attr != this.predefinedSyms.smem_sym_store) continue;
                    syms.add(wmeImpl.value.asIdentifier());
                    levels.add(parent_level + 1);
                }
                if (cmds != null) continue;
                cmds = wmes;
            }
            if (smem_info.last_cmd_count[time_slot] != wme_count) {
                bl2 = true;
                smem_info.last_cmd_count[time_slot] = wme_count;
            }
            if (bl2) {
                this.smem_clear_result(state);
                do_wm_phase = true;
            }
            if (bl2 && wme_count != 0L) {
                cue_wmes.clear();
                meta_wmes.clear();
                retrieval_wmes.clear();
                IdentifierImpl retrieve = null;
                IdentifierImpl query = null;
                IdentifierImpl negquery = null;
                IdentifierImpl math = null;
                store.clear();
                prohibit.clear();
                path_type path = path_type.blank_slate;
                for (WmeImpl wmeImpl : cmds) {
                    cue_wmes.add(wmeImpl);
                    if (path == path_type.cmd_bad) continue;
                    if (wmeImpl.attr == this.predefinedSyms.smem_sym_retrieve) {
                        if (wmeImpl.value.asIdentifier() != null && path == path_type.blank_slate) {
                            retrieve = wmeImpl.value.asIdentifier();
                            path = path_type.cmd_retrieve;
                            continue;
                        }
                        path = path_type.cmd_bad;
                        continue;
                    }
                    if (wmeImpl.attr == this.predefinedSyms.smem_sym_query) {
                        if (wmeImpl.value.asIdentifier() != null && (path == path_type.blank_slate || path == path_type.cmd_query) && query == null) {
                            query = wmeImpl.value.asIdentifier();
                            path = path_type.cmd_query;
                            continue;
                        }
                        path = path_type.cmd_bad;
                        continue;
                    }
                    if (wmeImpl.attr == this.predefinedSyms.smem_sym_negquery) {
                        if (wmeImpl.value.asIdentifier() != null && (path == path_type.blank_slate || path == path_type.cmd_query) && negquery == null) {
                            negquery = wmeImpl.value.asIdentifier();
                            path = path_type.cmd_query;
                            continue;
                        }
                        path = path_type.cmd_bad;
                        continue;
                    }
                    if (wmeImpl.attr == this.predefinedSyms.smem_sym_prohibit) {
                        if (wmeImpl.value.asIdentifier() != null && (path == path_type.blank_slate || path == path_type.cmd_query) && wmeImpl.value.asIdentifier().smem_lti != 0L) {
                            prohibit.add(wmeImpl.value.asIdentifier());
                            path = path_type.cmd_query;
                            continue;
                        }
                        path = path_type.cmd_bad;
                        continue;
                    }
                    if (wmeImpl.attr == this.predefinedSyms.smem_sym_math_query) {
                        if (wmeImpl.value.asIdentifier() != null && (path == path_type.blank_slate || path == path_type.cmd_query) && math == null) {
                            math = wmeImpl.value.asIdentifier();
                            path = path_type.cmd_query;
                            continue;
                        }
                        path = path_type.cmd_bad;
                        continue;
                    }
                    if (wmeImpl.attr == this.predefinedSyms.smem_sym_store) {
                        if (wmeImpl.value.asIdentifier() != null && (path == path_type.blank_slate || path == path_type.cmd_store)) {
                            store.add(wmeImpl.value.asIdentifier());
                            path = path_type.cmd_store;
                            continue;
                        }
                        path = path_type.cmd_bad;
                        continue;
                    }
                    path = path_type.cmd_bad;
                }
                if (path == path_type.cmd_query && query == null) {
                    path = path_type.cmd_bad;
                }
                if (path == path_type.blank_slate) {
                    path = path_type.cmd_bad;
                }
                if (path != path_type.cmd_bad) {
                    this.smem_attach();
                    if (path == path_type.cmd_retrieve) {
                        if (retrieve.smem_lti == 0L) {
                            this.smem_buffer_add_wme(meta_wmes, smem_info.smem_result_header, this.predefinedSyms.smem_sym_failure, retrieve);
                        } else {
                            this.smem_buffer_add_wme(meta_wmes, smem_info.smem_result_header, this.predefinedSyms.smem_sym_success, retrieve);
                            this.smem_install_memory(state, retrieve.smem_lti, retrieve, true, meta_wmes, retrieval_wmes);
                            this.stats.retrieves.set(this.stats.retrieves.get() + 1L);
                        }
                    } else if (path == path_type.cmd_query) {
                        LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>();
                        for (IdentifierImpl sym_p : prohibit) {
                            linkedHashSet.add(sym_p.smem_lti);
                        }
                        this.smem_process_query(state, query, negquery, math, linkedHashSet, cue_wmes, meta_wmes, retrieval_wmes);
                        this.stats.queries.set(this.stats.queries.get() + 1L);
                    } else if (path == path_type.cmd_store) {
                        if (this.params.lazy_commit.get() == DefaultSemanticMemoryParams.LazyCommitChoices.off) {
                            this.db.begin.executeUpdate();
                        }
                        for (IdentifierImpl identifierImpl : store) {
                            this.smem_soar_store(identifierImpl, mirroring_on ? smem_storage_type.store_recursive : smem_storage_type.store_level);
                            this.smem_buffer_add_wme(meta_wmes, smem_info.smem_result_header, this.predefinedSyms.smem_sym_success, identifierImpl);
                            this.stats.stores.set(this.stats.stores.get() + 1L);
                        }
                        if (this.params.lazy_commit.get() == DefaultSemanticMemoryParams.LazyCommitChoices.off) {
                            this.db.commit.executeUpdate();
                        }
                    }
                } else {
                    this.smem_buffer_add_wme(meta_wmes, smem_info.smem_result_header, this.predefinedSyms.smem_sym_bad_cmd, smem_info.smem_cmd_header);
                }
                if (!meta_wmes.isEmpty() || !retrieval_wmes.isEmpty()) {
                    this.smem_process_buffered_wmes(state, cue_wmes, meta_wmes, retrieval_wmes);
                    retrieval_wmes.clear();
                    meta_wmes.clear();
                    do_wm_phase = true;
                }
                cue_wmes.clear();
            }
            state = state.goalInfo.higher_goal;
        }
        if (store_only && mirroring_on && !this.smem_changed_ids.isEmpty()) {
            if (this.params.lazy_commit.get() == DefaultSemanticMemoryParams.LazyCommitChoices.off) {
                this.db.begin.execute();
            }
            for (SymbolImpl symbolImpl : this.smem_changed_ids) {
                if (symbolImpl.asIdentifier().slots == null) continue;
                this.smem_soar_store(symbolImpl.asIdentifier(), smem_storage_type.store_recursive);
                this.stats.mirrors.set(this.stats.mirrors.get() + 1L);
            }
            if (this.params.lazy_commit.get() == DefaultSemanticMemoryParams.LazyCommitChoices.off) {
                this.db.commit.execute();
            }
            this.smem_changed_ids.clear();
        }
        if (do_wm_phase) {
            this.smem_ignore_changes = true;
            this.decider.do_working_memory_phase();
            this.smem_ignore_changes = false;
        }
    }

    @Override
    public void smem_go(boolean store_only) {
        try {
            this.smem_respond_to_cmd(store_only);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (SoarException e) {
            throw new RuntimeException(e);
        }
    }

    boolean smem_backup_db(String file_name, ByRef<String> err) throws SQLException {
        boolean return_val = false;
        if (this.db != null) {
            this._smem_close_vars();
            return this.db.backupDb(file_name);
        }
        err.value = "Semantic database is not currently connected.";
        return return_val;
    }

    void smem_visualize_store(PrintWriter return_val) throws SoarException {
        try {
            this.smem_visualize_store_safe(return_val);
        }
        catch (SQLException e) {
            throw new SoarException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smem_visualize_store_safe(PrintWriter return_val) throws SoarException, SQLException {
        this.smem_attach();
        return_val.append("digraph smem {");
        return_val.append("\n");
        return_val.append("node [ shape = doublecircle ];");
        return_val.append("\n");
        LinkedHashMap<Long, String> lti_names = new LinkedHashMap<Long, String>();
        try (ResultSet q = this.db.vis_lti.executeQuery();){
            while (q.next()) {
                long lti_id = q.getLong(1);
                char lti_letter = (char)q.getLong(2);
                long lti_number = q.getLong(3);
                String lti_name = String.format("%c%d", Character.valueOf(lti_letter), lti_number);
                lti_names.put(lti_id, lti_name);
                return_val.append(lti_name);
                return_val.append(" [ label=\"");
                return_val.append(lti_name);
                return_val.append("\\n[");
                Double temp_double = q.getDouble(4);
                if (temp_double >= 0.0) {
                    return_val.append("+");
                }
                return_val.append(temp_double.toString());
                return_val.append("]\" ];\n");
            }
        }
        if (!lti_names.isEmpty()) {
            LinkedHashMap lti_terminals = new LinkedHashMap();
            ArrayList<String> my_terminals = null;
            return_val.append("\n");
            return_val.append("node [ shape = plaintext ];");
            return_val.append("\n");
            try (ResultSet q = this.db.vis_value_const.executeQuery();){
                while (q.next()) {
                    long lti_id = q.getLong(1);
                    my_terminals = (ArrayList<String>)lti_terminals.get(lti_id);
                    if (my_terminals == null) {
                        my_terminals = new ArrayList<String>();
                        lti_terminals.put(lti_id, my_terminals);
                    }
                    String lti_name = (String)lti_names.get(lti_id);
                    return_val.append(lti_name);
                    return_val.append("_");
                    int terminal_num = my_terminals.size();
                    return_val.append(Integer.toString(terminal_num));
                    return_val.append(" [ label = \"");
                    switch ((int)q.getLong(4)) {
                        case 2: {
                            return_val.append(this.smem_reverse_hash_str(q.getLong(5)));
                            break;
                        }
                        case 3: {
                            return_val.append(Integer.toString(this.smem_reverse_hash_int(q.getLong(5))));
                            break;
                        }
                        case 4: {
                            return_val.append(Double.toString(this.smem_reverse_hash_float(q.getLong(5))));
                            break;
                        }
                    }
                    switch ((int)q.getLong(2)) {
                        case 2: {
                            my_terminals.add(this.smem_reverse_hash_str(q.getLong(3)));
                            break;
                        }
                        case 3: {
                            my_terminals.add(Integer.toString(this.smem_reverse_hash_int(q.getLong(3))));
                            break;
                        }
                        case 4: {
                            my_terminals.add(Double.toString(this.smem_reverse_hash_float(q.getLong(3))));
                            break;
                        }
                        default: {
                            my_terminals.add("");
                        }
                    }
                    return_val.append("\" ];");
                    return_val.append("\n");
                }
            }
            for (Map.Entry n_p : lti_names.entrySet()) {
                List t_p = (List)lti_terminals.get(n_p.getKey());
                if (t_p == null) continue;
                int terminal_counter = 0;
                for (String a_p : t_p) {
                    return_val.append((CharSequence)n_p.getValue());
                    return_val.append(" -> ");
                    return_val.append((CharSequence)n_p.getValue());
                    return_val.append("_");
                    return_val.append(Integer.toString(terminal_counter));
                    return_val.append(" [ label=\"");
                    return_val.append(a_p);
                    return_val.append("\" ];");
                    return_val.append("\n");
                    ++terminal_counter;
                }
            }
            q = this.db.vis_value_lti.executeQuery();
            try {
                while (q.next()) {
                    long lti_id = q.getLong(1);
                    String lti_name = (String)lti_names.get(lti_id);
                    return_val.append(lti_name);
                    return_val.append(" -> ");
                    lti_id = q.getLong(4);
                    lti_name = (String)lti_names.get(lti_id);
                    return_val.append(lti_name);
                    return_val.append(" [ label =\"");
                    switch ((int)q.getLong(2)) {
                        case 2: {
                            return_val.append(this.smem_reverse_hash_str(q.getLong(3)));
                            break;
                        }
                        case 3: {
                            return_val.append(Integer.toString(this.smem_reverse_hash_int(q.getLong(3))));
                            break;
                        }
                        case 4: {
                            return_val.append(Double.toString(this.smem_reverse_hash_float(q.getLong(3))));
                            break;
                        }
                    }
                    return_val.append("\" ];");
                    return_val.append("\n");
                }
            }
            finally {
                q.close();
            }
        }
        return_val.append("}");
        return_val.append("\n");
    }

    void smem_visualize_lti(long lti_id, int depth, PrintWriter return_val) throws SoarException {
        try {
            this.smem_visualize_lti_safe(lti_id, depth, return_val);
        }
        catch (SQLException e) {
            throw new SoarException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smem_visualize_lti_safe(long lti_id, int depth, PrintWriter return_val) throws SQLException {
        StringWriter return_val2 = new StringWriter();
        ArrayDeque<smem_vis_lti> bfs = new ArrayDeque<smem_vis_lti>();
        LinkedHashMap<Long, smem_vis_lti> close_list = new LinkedHashMap<Long, smem_vis_lti>();
        return_val.append("digraph smem_lti {");
        return_val.append("\n");
        smem_vis_lti new_lti = new smem_vis_lti();
        new_lti.lti_id = lti_id;
        new_lti.level = 0;
        this.db.lti_letter_num.setLong(1, lti_id);
        try (ResultSet lti_q = this.db.lti_letter_num.executeQuery();){
            new_lti.lti_name = String.format("%c%d", Character.valueOf((char)lti_q.getLong(1)), lti_q.getLong(2));
        }
        bfs.add(new_lti);
        close_list.put(lti_id, new_lti);
        while (!bfs.isEmpty()) {
            smem_vis_lti parent_lti = (smem_vis_lti)bfs.remove();
            long child_counter = 0L;
            this.db.web_expand.setLong(1, parent_lti.lti_id);
            try (ResultSet expand_q = this.db.web_expand.executeQuery();){
                while (expand_q.next()) {
                    long check_lti_id = expand_q.getLong(7);
                    if (check_lti_id != 0L) {
                        smem_vis_lti new_lti2 = new smem_vis_lti();
                        new_lti2.lti_id = check_lti_id;
                        new_lti2.level = parent_lti.level + 1;
                        new_lti2.lti_name = String.format("%c%d", Character.valueOf((char)expand_q.getLong(5)), expand_q.getLong(6));
                        return_val2.append(parent_lti.lti_name);
                        return_val2.append(" -> ");
                        return_val2.append(new_lti2.lti_name);
                        return_val2.append(" [ label = \"");
                        switch ((int)expand_q.getLong(1)) {
                            case 2: {
                                return_val2.append(this.smem_reverse_hash_str(expand_q.getLong(2)));
                                break;
                            }
                            case 3: {
                                return_val2.append(Integer.toString(this.smem_reverse_hash_int(expand_q.getLong(2))));
                                break;
                            }
                            case 4: {
                                return_val2.append(Double.toString(this.smem_reverse_hash_float(expand_q.getLong(2))));
                                break;
                            }
                        }
                        return_val2.append("\" ];");
                        return_val2.append("\n");
                        if (close_list.containsKey(new_lti2.lti_id)) continue;
                        close_list.put(new_lti2.lti_id, new_lti2);
                        if (depth != 0 && new_lti2.level >= depth) continue;
                        bfs.add(new_lti2);
                        continue;
                    }
                    String node_name = String.format("%s_%d", parent_lti.lti_name, child_counter);
                    return_val2.append("node [ shape = plaintext ];");
                    return_val2.append("\n");
                    return_val2.append(node_name);
                    return_val2.append(" [ label=\"");
                    switch ((int)expand_q.getLong(3)) {
                        case 2: {
                            return_val2.append(this.smem_reverse_hash_str(expand_q.getLong(4)));
                            break;
                        }
                        case 3: {
                            return_val2.append(Integer.toString(this.smem_reverse_hash_int(expand_q.getLong(4))));
                            break;
                        }
                        case 4: {
                            return_val2.append(Double.toString(this.smem_reverse_hash_float(expand_q.getLong(4))));
                            break;
                        }
                    }
                    return_val2.append("\" ];");
                    return_val2.append("\n");
                    return_val2.append(parent_lti.lti_name);
                    return_val2.append(" -> ");
                    return_val2.append(node_name);
                    return_val2.append(" [ label = \"");
                    switch ((int)expand_q.getLong(1)) {
                        case 2: {
                            return_val.append(this.smem_reverse_hash_str(expand_q.getLong(2)));
                            break;
                        }
                        case 3: {
                            return_val.append(Integer.toString(this.smem_reverse_hash_int(expand_q.getLong(2))));
                            break;
                        }
                        case 4: {
                            return_val.append(Double.toString(this.smem_reverse_hash_float(expand_q.getLong(2))));
                            break;
                        }
                    }
                    return_val2.append("\" ];");
                    return_val2.append("\n");
                    ++child_counter;
                }
            }
        }
        return_val2.append("}");
        return_val2.append("\n");
        PreparedStatement act_q = this.db.vis_lti_act;
        return_val.append("node [ shape = doublecircle ];");
        return_val.append("\n");
        for (Map.Entry e : close_list.entrySet()) {
            return_val.append(((smem_vis_lti)e.getValue()).lti_name);
            return_val.append(" [ label=\"");
            return_val.append(((smem_vis_lti)e.getValue()).lti_name);
            return_val.append("\\n[");
            act_q.setLong(1, (Long)e.getKey());
            try (ResultSet rs = null;){
                rs = act_q.executeQuery();
                if (rs.next()) {
                    Double temp_double = rs.getDouble(1);
                    if (temp_double >= 0.0) {
                        return_val.append("+");
                    }
                    return_val.append(temp_double.toString());
                }
            }
            return_val.append("]\"");
            return_val.append(" ];");
            return_val.append("\n");
        }
        return_val.append(return_val2.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Long> _smem_print_lti(long lti_id, char lti_letter, long lti_number, double lti_act, StringBuilder return_val) throws SQLException {
        LinkedHashSet<Long> next = new LinkedHashSet<Long>();
        StringBuilder temp_str2 = null;
        LinkedHashMap augmentations = new LinkedHashMap();
        PreparedStatement expand_q = this.db.web_expand;
        return_val.append("(@");
        return_val.append(lti_letter);
        return_val.append(lti_number);
        expand_q.setLong(1, lti_id);
        try (ResultSet rs = null;){
            rs = expand_q.executeQuery();
            while (rs.next()) {
                String temp_str;
                switch (rs.getInt(1)) {
                    case 2: {
                        temp_str = this.smem_reverse_hash_str(rs.getLong(2));
                        break;
                    }
                    case 3: {
                        temp_str = new Integer(this.smem_reverse_hash_int(rs.getLong(2))).toString();
                        break;
                    }
                    case 4: {
                        temp_str = new Double(this.smem_reverse_hash_float(rs.getLong(2))).toString();
                    }
                    default: {
                        temp_str = null;
                    }
                }
                if (rs.getLong(7) != 0L) {
                    temp_str2 = new StringBuilder("@");
                    temp_str2.append((char)rs.getInt(5));
                    temp_str2.append(rs.getLong(6));
                    next.add(rs.getLong(7));
                } else {
                    switch (rs.getInt(3)) {
                        case 2: {
                            temp_str2 = new StringBuilder(this.smem_reverse_hash_str(rs.getLong(4)));
                            temp_str2.insert(0, "|");
                            temp_str2.append("|");
                            break;
                        }
                        case 3: {
                            temp_str2 = new StringBuilder(new Integer(this.smem_reverse_hash_int(rs.getLong(4))).toString());
                            break;
                        }
                        case 4: {
                            temp_str2 = new StringBuilder(new Double(this.smem_reverse_hash_float(rs.getLong(4))).toString());
                            break;
                        }
                        default: {
                            temp_str2 = null;
                        }
                    }
                }
                if (!augmentations.containsKey(temp_str)) {
                    augmentations.put(temp_str, new ArrayList());
                }
                if (temp_str2 != null) {
                    ((List)augmentations.get(temp_str)).add(temp_str2.toString());
                    continue;
                }
                ((List)augmentations.get(temp_str)).add(temp_str);
            }
        }
        for (Map.Entry lti_slot : augmentations.entrySet()) {
            return_val.append(" ^");
            return_val.append((String)lti_slot.getKey());
            for (String slot_val : (List)lti_slot.getValue()) {
                return_val.append(" ");
                return_val.append(slot_val);
            }
        }
        augmentations.clear();
        return_val.append(" [");
        if (lti_act >= 0.0) {
            return_val.append("+");
        }
        return_val.append(lti_act);
        return_val.append("]");
        return_val.append(")\n");
        return next;
    }

    void smem_print_store(StringBuilder return_val) throws SoarException {
        this.smem_attach();
        PreparedStatement q = this.db.vis_lti;
        ResultSet rs = null;
        try {
            rs = q.executeQuery();
            while (rs.next()) {
                this._smem_print_lti(rs.getLong(1), (char)rs.getInt(2), rs.getLong(3), rs.getDouble(4), return_val);
            }
        }
        catch (SQLException e) {
            throw new SoarException(e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new SoarException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void smem_print_lti(long lti_id, int depth, StringBuilder return_val) throws SoarException {
        LinkedHashSet<Long> visited = new LinkedHashSet<Long>();
        ArrayDeque<SmemLTIidDepthPair> to_visit = new ArrayDeque<SmemLTIidDepthPair>();
        SmemLTIidDepthPair c = null;
        Set<Object> next = new LinkedHashSet();
        PreparedStatement lti_q = this.db.lti_letter_num;
        PreparedStatement act_q = this.db.vis_lti_act;
        this.smem_attach();
        to_visit.add(new SmemLTIidDepthPair(lti_id, 1));
        visited.add(lti_id);
        while (!to_visit.isEmpty()) {
            c = (SmemLTIidDepthPair)to_visit.remove();
            for (int i = 1; i < c.getDepth(); ++i) {
                return_val.append(" ");
            }
            try {
                lti_q.setLong(1, c.getLTIid());
                act_q.setLong(1, c.getLTIid());
                ResultSet ltiRS = null;
                ResultSet actRS = null;
                try {
                    ltiRS = lti_q.executeQuery();
                    actRS = act_q.executeQuery();
                    next = this._smem_print_lti(c.getLTIid(), (char)ltiRS.getLong(1), ltiRS.getLong(2), actRS.getDouble(1), return_val);
                    if (c.getDepth() >= depth) continue;
                    for (Long l : next) {
                        boolean successfullyInserted = visited.add(l);
                        if (!successfullyInserted) continue;
                        to_visit.add(new SmemLTIidDepthPair(l, c.getDepth() + 1));
                    }
                }
                finally {
                    ltiRS.close();
                    actRS.close();
                }
            }
            catch (SQLException e) {
                throw new SoarException(e);
            }
        }
    }

    void commit() throws SoarException {
        if (this.db != null && this.params.lazy_commit.get() == DefaultSemanticMemoryParams.LazyCommitChoices.on) {
            try {
                this.db.commit.executeUpdate();
                this.db.begin.executeUpdate();
            }
            catch (SQLException e) {
                throw new SoarException("Error while forcing commit: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean isMirroringEnabled() {
        return this.params.mirroring.get() == DefaultSemanticMemoryParams.MirroringChoices.on;
    }

    @Override
    public Set<IdentifierImpl> smem_changed_ids() {
        return this.smem_changed_ids;
    }

    @Override
    public boolean smem_ignore_changes() {
        return this.smem_ignore_changes;
    }

    private static class SmemLTIidDepthPair {
        private final long lti_id;
        private final int depth;

        public SmemLTIidDepthPair(long lti_id, int depth) {
            this.lti_id = lti_id;
            this.depth = depth;
        }

        public long getLTIid() {
            return this.lti_id;
        }

        public int getDepth() {
            return this.depth;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.depth;
            result = 31 * result + (int)(this.lti_id ^ this.lti_id >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SmemLTIidDepthPair other = (SmemLTIidDepthPair)obj;
            if (this.depth != other.depth) {
                return false;
            }
            return this.lti_id == other.lti_id;
        }
    }

    private static enum path_type {
        blank_slate,
        cmd_bad,
        cmd_retrieve,
        cmd_query,
        cmd_store;

    }

    private static class MathQueryProcessResults {
        public boolean needFullSearch;
        public boolean goodCue;

        public MathQueryProcessResults(boolean needFullSearch, boolean goodCue) {
            this.needFullSearch = needFullSearch;
            this.goodCue = goodCue;
        }
    }

    private static class SmemHashIdLongPair {
        private final long hash_id;
        private final long second;

        SmemHashIdLongPair(long hash_id, long second) {
            this.hash_id = hash_id;
            this.second = second;
        }

        public long getHashID() {
            return this.hash_id;
        }

        public long getSecond() {
            return this.second;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.hash_id ^ this.hash_id >>> 32);
            result = 31 * result + (int)(this.second ^ this.second >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SmemHashIdLongPair other = (SmemHashIdLongPair)obj;
            if (this.hash_id != other.hash_id) {
                return false;
            }
            return this.second == other.second;
        }
    }

    public static class BasicWeightedCue {
        public final WmeImpl cue;
        public final long weight;

        public BasicWeightedCue(WmeImpl cue, long weight) {
            this.cue = cue;
            this.weight = weight;
        }
    }

    private static enum smem_query_levels {
        qry_search,
        qry_full;

    }

    private static enum smem_storage_type {
        store_level,
        store_recursive;

    }

    private static enum smem_variable_key {
        var_max_cycle,
        var_num_nodes,
        var_num_edges,
        var_act_thresh,
        var_act_mode;

    }
}

