/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.smem;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jsoar.util.properties.DefaultPropertyProvider;
import org.jsoar.util.properties.DoublePropertyProvider;
import org.jsoar.util.properties.EnumPropertyProvider;
import org.jsoar.util.properties.LongPropertyProvider;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyManager;

class DefaultSemanticMemoryParams {
    private static final String PREFIX = "smem.params.";
    static final PropertyKey<LearningChoices> LEARNING = DefaultSemanticMemoryParams.key("learning", LearningChoices.class).defaultValue(LearningChoices.off).build();
    final EnumPropertyProvider<LearningChoices> learning = new EnumPropertyProvider<LearningChoices>(LEARNING);
    static final PropertyKey<String> DRIVER = DefaultSemanticMemoryParams.key("driver", String.class).defaultValue("org.sqlite.JDBC").build();
    final DefaultPropertyProvider<String> driver = new DefaultPropertyProvider<String>(DRIVER);
    static final PropertyKey<String> PROTOCOL = DefaultSemanticMemoryParams.key("protocol", String.class).defaultValue("jdbc:sqlite").build();
    final DefaultPropertyProvider<String> protocol = new DefaultPropertyProvider<String>(PROTOCOL);
    static final PropertyKey<String> PATH = DefaultSemanticMemoryParams.key("path", String.class).defaultValue(":memory:").build();
    final DefaultPropertyProvider<String> path = new DefaultPropertyProvider<String>(PATH);
    static final PropertyKey<LazyCommitChoices> LAZY_COMMIT = DefaultSemanticMemoryParams.key("lazy-commit", LazyCommitChoices.class).defaultValue(LazyCommitChoices.on).build();
    final EnumPropertyProvider<LazyCommitChoices> lazy_commit = new EnumPropertyProvider<LazyCommitChoices>(LAZY_COMMIT);
    static final PropertyKey<AppendDatabaseChoices> APPEND_DB = DefaultSemanticMemoryParams.key("append-database", AppendDatabaseChoices.class).defaultValue(AppendDatabaseChoices.on).build();
    final EnumPropertyProvider<AppendDatabaseChoices> append_db = new EnumPropertyProvider<AppendDatabaseChoices>(APPEND_DB);
    static final PropertyKey<PageChoices> PAGE_SIZE = DefaultSemanticMemoryParams.key("page-size", PageChoices.class).defaultValue(PageChoices.page_8k).build();
    final EnumPropertyProvider<PageChoices> page_size = new EnumPropertyProvider<PageChoices>(PAGE_SIZE);
    static final PropertyKey<Long> CACHE_SIZE = DefaultSemanticMemoryParams.key("cache-size", Long.class).defaultValue(10000L).build();
    final LongPropertyProvider cache_size = new LongPropertyProvider(CACHE_SIZE);
    static final PropertyKey<Optimization> OPTIMIZATION = DefaultSemanticMemoryParams.key("optimization", Optimization.class).defaultValue(Optimization.performance).build();
    final EnumPropertyProvider<Optimization> optimization = new EnumPropertyProvider<Optimization>(OPTIMIZATION);
    static final PropertyKey<Long> THRESH = DefaultSemanticMemoryParams.key("thresh", Long.class).defaultValue(100L).build();
    final LongPropertyProvider thresh = new LongPropertyProvider(THRESH);
    static final PropertyKey<MergeChoices> MERGE = DefaultSemanticMemoryParams.key("merge", MergeChoices.class).defaultValue(MergeChoices.add).build();
    final EnumPropertyProvider<MergeChoices> merge = new EnumPropertyProvider<MergeChoices>(MERGE);
    static final PropertyKey<ActivateOnQueryChoices> ACTIVATE_ON_QUERY = DefaultSemanticMemoryParams.key("activate-on-query", ActivateOnQueryChoices.class).defaultValue(ActivateOnQueryChoices.on).build();
    final EnumPropertyProvider<ActivateOnQueryChoices> activate_on_query = new EnumPropertyProvider<ActivateOnQueryChoices>(ACTIVATE_ON_QUERY);
    static final PropertyKey<ActivationChoices> ACTIVATION_MODE = DefaultSemanticMemoryParams.key("activation-mode", ActivationChoices.class).defaultValue(ActivationChoices.recency).build();
    final EnumPropertyProvider<ActivationChoices> activation_mode = new EnumPropertyProvider<ActivationChoices>(ACTIVATION_MODE);
    static final PropertyKey<Double> BASE_DECAY = DefaultSemanticMemoryParams.key("base-decay", Double.class).defaultValue(0.5).build();
    final DoublePropertyProvider base_decay = new DoublePropertyProvider(BASE_DECAY);
    static final PropertyKey<BaseUpdateChoices> BASE_UPDATE = DefaultSemanticMemoryParams.key("base-update-policy", BaseUpdateChoices.class).defaultValue(BaseUpdateChoices.stable).build();
    final EnumPropertyProvider<BaseUpdateChoices> base_update = new EnumPropertyProvider<BaseUpdateChoices>(BASE_UPDATE);
    static final PropertyKey<SetWrapperLong> BASE_INCREMENTAL_THRESHES = DefaultSemanticMemoryParams.key("base-incremental-threshes", SetWrapperLong.class).defaultValue(new SetWrapperLong()).build();
    final DefaultPropertyProvider<SetWrapperLong> base_incremental_threshes = new DefaultPropertyProvider<SetWrapperLong>(BASE_INCREMENTAL_THRESHES);
    static final PropertyKey<MirroringChoices> MIRRORING = DefaultSemanticMemoryParams.key("mirroring", MirroringChoices.class).defaultValue(MirroringChoices.off).build();
    final EnumPropertyProvider<MirroringChoices> mirroring = new EnumPropertyProvider<MirroringChoices>(MIRRORING);
    private final PropertyManager properties;

    public static PropertyKey<?> getProperty(PropertyManager props, String name) {
        return props.getKey(PREFIX + name);
    }

    private static <T> PropertyKey.Builder<T> key(String name, Class<T> type) {
        return PropertyKey.builder(PREFIX + name, type);
    }

    public DefaultSemanticMemoryParams(PropertyManager properties) {
        this.properties = properties;
        properties.setProvider(LEARNING, this.learning);
        properties.setProvider(DRIVER, this.driver);
        properties.setProvider(PROTOCOL, this.protocol);
        properties.setProvider(PATH, this.path);
        properties.setProvider(LAZY_COMMIT, this.lazy_commit);
        properties.setProvider(APPEND_DB, this.append_db);
        properties.setProvider(PAGE_SIZE, this.page_size);
        properties.setProvider(CACHE_SIZE, this.cache_size);
        properties.setProvider(OPTIMIZATION, this.optimization);
        properties.setProvider(THRESH, this.thresh);
        properties.setProvider(MERGE, this.merge);
        properties.setProvider(ACTIVATE_ON_QUERY, this.activate_on_query);
        properties.setProvider(ACTIVATION_MODE, this.activation_mode);
        properties.setProvider(BASE_DECAY, this.base_decay);
        properties.setProvider(BASE_UPDATE, this.base_update);
        properties.setProvider(BASE_INCREMENTAL_THRESHES, this.base_incremental_threshes);
        properties.setProvider(MIRRORING, this.mirroring);
    }

    public PropertyManager getProperties() {
        return this.properties;
    }

    public static class SetWrapperLong
    extends SetWrapper<Long> {
        public SetWrapperLong() {
            this.set = new HashSet();
        }

        public SetWrapperLong(Set<Long> set) {
            this.set = set;
        }

        public boolean add(Long object) {
            return this.set.add(object);
        }

        public void clear() {
            this.set.clear();
        }

        public boolean contains(Long object) {
            return this.set.contains(object);
        }

        public Iterator<Long> iterator() {
            return this.set.iterator();
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public String toString() {
            return this.set.toString();
        }

        public Set<Long> valueOf(String value) {
            Long longValue = Long.parseLong(value);
            if (this.set.contains(longValue)) {
                this.set.remove(longValue);
            } else {
                this.set.add(longValue);
            }
            return new HashSet<Long>(this.set);
        }

        public SetWrapperLong toSetWrapper(String value) {
            return new SetWrapperLong(this.valueOf(value));
        }
    }

    public static abstract class SetWrapper<T> {
        protected Set<T> set;
    }

    static enum AppendDatabaseChoices {
        on,
        off;

    }

    static enum LearningChoices {
        on,
        off;

    }

    static enum LazyCommitChoices {
        on,
        off;

    }

    static enum MirroringChoices {
        on,
        off;

    }

    static enum ActivateOnQueryChoices {
        on,
        off;

    }

    static enum BaseUpdateChoices {
        stable,
        naive,
        incremental;

    }

    static enum ActivationChoices {
        recency,
        frequency,
        base_level("base-level");

        private final String realName;

        private ActivationChoices() {
            this.realName = this.name();
        }

        private ActivationChoices(String realName) {
            this.realName = realName;
        }

        public String toString() {
            return this.realName;
        }

        public static ActivationChoices getEnum(String value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            for (ActivationChoices ac : ActivationChoices.values()) {
                if (!value.equals(ac.toString())) continue;
                return ac;
            }
            throw new IllegalArgumentException();
        }
    }

    static enum MergeChoices {
        none,
        add;

    }

    static enum Optimization {
        safety,
        performance;

    }

    static enum PageChoices {
        page_1k,
        page_2k,
        page_4k,
        page_8k,
        page_16k,
        page_32k,
        page_64k;


        public String toString() {
            switch (this) {
                case page_1k: {
                    return "1k";
                }
                case page_2k: {
                    return "2k";
                }
                case page_4k: {
                    return "4k";
                }
                case page_8k: {
                    return "8k";
                }
                case page_16k: {
                    return "16k";
                }
                case page_32k: {
                    return "32k";
                }
                case page_64k: {
                    return "64k";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

