/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.smem;

import java.util.HashSet;
import java.util.Set;
import org.jsoar.kernel.smem.SemanticMemoryStatistics;
import org.jsoar.util.properties.DefaultPropertyProvider;
import org.jsoar.util.properties.LongPropertyProvider;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyManager;
import org.jsoar.util.properties.PropertyProvider;

class DefaultSemanticMemoryStats
implements SemanticMemoryStatistics {
    private static final String PREFIX = "smem.stats.";
    static final PropertyKey<String> DB_LIB_VERSION = DefaultSemanticMemoryStats.key("db-lib-version", String.class).defaultValue(null).build();
    final DefaultPropertyProvider<String> db_lib_version = new DefaultPropertyProvider<String>(DB_LIB_VERSION);
    static final PropertyKey<Long> MEM_USAGE = DefaultSemanticMemoryStats.key("mem-usage", Long.class).defaultValue(0L).build();
    final LongPropertyProvider mem_usage = new LongPropertyProvider(MEM_USAGE);
    static final PropertyKey<Long> MEM_HIGH = DefaultSemanticMemoryStats.key("mem-high", Long.class).defaultValue(0L).build();
    final LongPropertyProvider mem_high = new LongPropertyProvider(MEM_HIGH);
    static final PropertyKey<Long> RETRIEVES = DefaultSemanticMemoryStats.key("retrieves", Long.class).defaultValue(0L).build();
    final LongPropertyProvider retrieves = new LongPropertyProvider(RETRIEVES);
    static final PropertyKey<Long> QUERIES = DefaultSemanticMemoryStats.key("queries", Long.class).defaultValue(0L).build();
    final LongPropertyProvider queries = new LongPropertyProvider(QUERIES);
    static final PropertyKey<Long> STORES = DefaultSemanticMemoryStats.key("stores", Long.class).defaultValue(0L).build();
    final LongPropertyProvider stores = new LongPropertyProvider(STORES);
    static final PropertyKey<Long> ACT_UPDATES = DefaultSemanticMemoryStats.key("act-updates", Long.class).defaultValue(0L).build();
    final LongPropertyProvider act_updates = new LongPropertyProvider(ACT_UPDATES);
    static final PropertyKey<Long> MIRRORS = DefaultSemanticMemoryStats.key("mirrors", Long.class).defaultValue(0L).build();
    final LongPropertyProvider mirrors = new LongPropertyProvider(MIRRORS);
    static final PropertyKey<Long> NODES = DefaultSemanticMemoryStats.key("nodes", Long.class).defaultValue(0L).build();
    final LongPropertyProvider nodes = new LongPropertyProvider(NODES);
    static final PropertyKey<Long> EDGES = DefaultSemanticMemoryStats.key("edges", Long.class).defaultValue(0L).build();
    final LongPropertyProvider edges = new LongPropertyProvider(EDGES);
    private final PropertyManager properties;
    private final Set<PropertyKey<?>> keys = new HashSet();

    public static PropertyKey<?> getProperty(PropertyManager props, String name) {
        return props.getKey(PREFIX + name);
    }

    private static <T> PropertyKey.Builder<T> key(String name, Class<T> type) {
        return PropertyKey.builder(PREFIX + name, type);
    }

    public DefaultSemanticMemoryStats(PropertyManager properties) {
        this.properties = properties;
        this.add(DB_LIB_VERSION, this.db_lib_version);
        this.add(MEM_USAGE, this.mem_usage);
        this.add(MEM_HIGH, this.mem_high);
        this.add(RETRIEVES, this.retrieves);
        this.add(QUERIES, this.queries);
        this.add(STORES, this.stores);
        this.add(ACT_UPDATES, this.act_updates);
        this.add(MIRRORS, this.mirrors);
        this.add(NODES, this.nodes);
        this.add(EDGES, this.edges);
    }

    private <T> void add(PropertyKey<T> key, PropertyProvider<T> value) {
        this.properties.setProvider(key, value);
    }

    public void reset() {
        for (PropertyKey<?> key : this.keys) {
            this.properties.set(key, key.getDefaultValue());
        }
    }

    @Override
    public long getRetrieves() {
        return this.retrieves.get();
    }

    @Override
    public long getQueries() {
        return this.queries.get();
    }

    @Override
    public long getStores() {
        return this.stores.get();
    }
}

