/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.smem.math;

import org.jsoar.kernel.smem.math.MathQuery;

public class MathQueryMin
extends MathQuery {
    private double doubleValue = Double.POSITIVE_INFINITY;
    private double stagedDoubleValue = Double.POSITIVE_INFINITY;
    private long longValue = Long.MAX_VALUE;
    private long stagedLongValue = Long.MAX_VALUE;

    private void stageDouble(double d) {
        if (d < this.stagedDoubleValue) {
            this.stagedDoubleValue = d;
        }
    }

    private void stageLong(long l) {
        if (l < this.stagedLongValue) {
            this.stagedLongValue = l;
        }
    }

    @Override
    public boolean valueIsAcceptable(double value) {
        if (value < this.doubleValue && value < (double)this.longValue) {
            this.stageDouble(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean valueIsAcceptable(long value) {
        if ((double)value < this.doubleValue && value < this.longValue) {
            this.stageLong(value);
            return true;
        }
        return false;
    }

    @Override
    public void commit() {
        this.doubleValue = this.stagedDoubleValue;
        this.longValue = this.stagedLongValue;
    }

    @Override
    public void rollback() {
        this.stagedDoubleValue = this.doubleValue;
        this.stagedLongValue = this.longValue;
    }
}

