/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import java.util.Formatter;
import org.jsoar.kernel.symbols.DoubleSymbol;
import org.jsoar.kernel.symbols.IntegerSymbolImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolImpl;

public class DoubleSymbolImpl
extends SymbolImpl
implements DoubleSymbol {
    private final double value;

    DoubleSymbolImpl(SymbolFactory factory, int hash_id, double value) {
        super(factory, hash_id);
        this.value = value;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public DoubleSymbolImpl asDouble() {
        return this;
    }

    @Override
    Symbol importInto(SymbolFactory factory) {
        return factory.createDouble(this.value);
    }

    @Override
    public boolean isSameTypeAs(SymbolImpl other) {
        return other.asDouble() != null;
    }

    @Override
    public boolean numericLess(SymbolImpl other) {
        DoubleSymbolImpl f = other.asDouble();
        if (f != null) {
            return this.value < f.value;
        }
        IntegerSymbolImpl i = other.asInteger();
        return i != null ? this.value < (double)i.getValue() : super.numericLess(other);
    }

    @Override
    public boolean numericLessOrEqual(SymbolImpl other) {
        DoubleSymbolImpl f = other.asDouble();
        if (f != null) {
            return this.value <= f.value;
        }
        IntegerSymbolImpl i = other.asInteger();
        return i != null ? this.value <= (double)i.getValue() : super.numericLessOrEqual(other);
    }

    @Override
    public boolean numericGreater(SymbolImpl other) {
        DoubleSymbolImpl f = other.asDouble();
        if (f != null) {
            return this.value > f.value;
        }
        IntegerSymbolImpl i = other.asInteger();
        return i != null ? this.value > (double)i.getValue() : super.numericLess(other);
    }

    @Override
    public boolean numericGreaterOrEqual(SymbolImpl other) {
        DoubleSymbolImpl f = other.asDouble();
        if (f != null) {
            return this.value >= f.value;
        }
        IntegerSymbolImpl i = other.asInteger();
        return i != null ? this.value >= (double)i.getValue() : super.numericLessOrEqual(other);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        formatter.format(Double.toString(this.value), new Object[0]);
    }
}

