/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.symbols;

import java.io.IOException;
import java.util.Formatter;
import org.jsoar.kernel.parser.PossibleSymbolTypes;
import org.jsoar.kernel.parser.original.Lexer;
import org.jsoar.kernel.symbols.StringSymbol;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.util.StringTools;

public class StringSymbolImpl
extends SymbolImpl
implements StringSymbol {
    private final String value;

    StringSymbolImpl(SymbolFactory factory, int hash_id, String value) {
        super(factory, hash_id);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public StringSymbolImpl asString() {
        return this;
    }

    @Override
    Symbol importInto(SymbolFactory factory) {
        return factory.createString(this.value);
    }

    @Override
    public boolean isSameTypeAs(SymbolImpl other) {
        return other.asString() != null;
    }

    @Override
    public char getFirstLetter() {
        return this.getValue().charAt(0);
    }

    @Override
    public boolean numericLess(SymbolImpl other) {
        StringSymbolImpl s = other.asString();
        if (s != null) {
            return this.value.compareTo(s.value) < 0;
        }
        return super.numericLess(other);
    }

    @Override
    public boolean numericLessOrEqual(SymbolImpl other) {
        StringSymbolImpl s = other.asString();
        if (s != null) {
            return this.value.compareTo(s.value) <= 0;
        }
        return super.numericLessOrEqual(other);
    }

    @Override
    public boolean numericGreater(SymbolImpl other) {
        StringSymbolImpl s = other.asString();
        if (s != null) {
            return this.value.compareTo(s.value) > 0;
        }
        return super.numericGreater(other);
    }

    @Override
    public boolean numericGreaterOrEqual(SymbolImpl other) {
        StringSymbolImpl s = other.asString();
        if (s != null) {
            return this.value.compareTo(s.value) >= 0;
        }
        return super.numericGreaterOrEqual(other);
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String stringToWrite;
        boolean rereadable;
        boolean bl = rereadable = (4 & flags) == 0;
        if (rereadable) {
            PossibleSymbolTypes possible = Lexer.determine_possible_symbol_types_for_string(this.getValue());
            stringToWrite = !possible.possible_sc || possible.possible_id && Character.isUpperCase(this.getValue().charAt(0)) || possible.possible_var || possible.possible_ic || possible.possible_fc || !possible.rereadable ? StringTools.string_to_escaped_string(this.getValue(), '|') : this.getValue();
        } else {
            stringToWrite = this.getValue();
        }
        try {
            formatter.out().append(stringToWrite);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

