/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.tracing;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import org.jsoar.util.NullWriter;
import org.jsoar.util.TeeWriter;

public class Printer {
    private static final char[] SPACES = new char[80];
    private TeeWriter persistentWriters = new TeeWriter(new Writer[0]);
    private PrintWriter persistentPrintWriter = new PrintWriter((Writer)this.persistentWriters, true);
    private Writer internalWriter;
    private PrintWriter printWriter;
    private boolean printWarnings = true;
    private boolean atStartOfLine = true;
    private final Writer startOfLineDetector = new Writer(){

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                Printer.this.atStartOfLine = cbuf[i] == '\n';
            }
        }
    };
    private final LinkedList<StackEntry> stack = new LinkedList();
    private List<String> warnings;

    public static Printer createStdOutPrinter() {
        return new Printer(new OutputStreamWriter(System.out));
    }

    public Printer(Writer writer) {
        this.internalWriter = writer != null ? writer : new NullWriter();
        this.printWriter = new PrintWriter(this.internalWriter, true);
        this.addPersistentWriter(this.startOfLineDetector);
        this.warnings = new ArrayList<String>();
    }

    public Writer getWriter() {
        return new TeeWriter(this.internalWriter, this.persistentWriters);
    }

    public void pushWriter(Writer writer) {
        this.printWriter.flush();
        this.persistentPrintWriter.flush();
        this.stack.push(new StackEntry(this.internalWriter, this.printWriter));
        this.internalWriter = writer != null ? writer : new NullWriter();
        this.printWriter = this.asPrintWriter(this.internalWriter);
    }

    private PrintWriter asPrintWriter(Writer writer) {
        return writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
    }

    public Writer popWriter() {
        this.printWriter.flush();
        this.persistentPrintWriter.flush();
        Writer oldInternal = this.internalWriter;
        StackEntry e = this.stack.pop();
        this.internalWriter = e.internal;
        this.printWriter = e.wrapped;
        return oldInternal;
    }

    public void addPersistentWriter(Writer writer) {
        this.persistentWriters.addWriter(writer);
    }

    public void removePersistentWriter(Writer writer) {
        this.persistentWriters.removeWriter(writer);
    }

    public Printer print(String output) {
        this.printWriter.print(output);
        this.persistentPrintWriter.print(output);
        return this;
    }

    public Printer print(String format, Object ... args) {
        try {
            this.printWriter.printf(format, args);
        }
        catch (Exception e) {
            System.out.println("!!");
        }
        this.persistentPrintWriter.printf(format, args);
        return this;
    }

    public Formatter asFormatter() {
        return new Formatter(this.printWriter);
    }

    public Printer startNewLine() {
        if (!this.atStartOfLine) {
            this.printWriter.append('\n');
            this.persistentPrintWriter.append('\n');
        }
        return this;
    }

    public Printer flush() {
        this.printWriter.flush();
        this.persistentPrintWriter.flush();
        return this;
    }

    public Printer warn(String message) {
        if (this.printWarnings) {
            this.print(message);
        }
        this.warnings.add(message);
        return this;
    }

    public Printer warn(String format, Object ... args) {
        if (this.printWarnings) {
            this.print(format, args);
        }
        this.warnings.add(String.format(format, args));
        return this;
    }

    public boolean isPrintWarnings() {
        return this.printWarnings;
    }

    public Printer setPrintWarnings(boolean printWarnings) {
        this.printWarnings = printWarnings;
        return this;
    }

    public Printer error(String message) {
        this.print("\nError: " + message);
        return this;
    }

    public Printer error(String format, Object ... args) {
        this.print("\nError: " + format, args);
        return this;
    }

    public Printer spaces(int n) {
        while (n > 0) {
            int c = Math.min(n, SPACES.length);
            this.printWriter.write(SPACES, 0, c);
            this.persistentPrintWriter.write(SPACES, 0, c);
            n -= c;
        }
        return this;
    }

    public List<String> getWarningsAndClear() {
        ArrayList<String> copy = new ArrayList<String>(this.warnings);
        this.warnings.clear();
        return copy;
    }

    static {
        Arrays.fill(SPACES, ' ');
    }

    private static class StackEntry {
        final Writer internal;
        final PrintWriter wrapped;

        public StackEntry(Writer internal, PrintWriter wrapped) {
            this.internal = internal;
            this.wrapped = wrapped;
        }
    }
}

