/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.tracing;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.DecisionCycle;
import org.jsoar.kernel.PredefinedSymbols;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.memory.Slot;
import org.jsoar.kernel.memory.WmeImpl;
import org.jsoar.kernel.symbols.IdentifierImpl;
import org.jsoar.kernel.symbols.StringSymbolImpl;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.kernel.symbols.SymbolImpl;
import org.jsoar.kernel.tracing.TraceFormat;
import org.jsoar.kernel.tracing.TraceFormatRestriction;
import org.jsoar.kernel.tracing.TraceFormatType;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.markers.DefaultMarker;
import org.jsoar.util.markers.Marker;

public class TraceFormats {
    private final Agent context;
    private PredefinedSymbols predefinedSyms;
    private DecisionCycle decisionCycle;
    private String format;
    private int offset;
    private String format_string_error_message;
    private Map<TraceFormatRestriction, Map<SymbolImpl, TraceFormat>> stack_tr_ht = TraceFormats.createMap();
    private Map<TraceFormatRestriction, Map<SymbolImpl, TraceFormat>> object_tr_ht = TraceFormats.createMap();
    private Map<TraceFormatRestriction, TraceFormat> stack_tf_for_anything = new EnumMap<TraceFormatRestriction, TraceFormat>(TraceFormatRestriction.class);
    private Map<TraceFormatRestriction, TraceFormat> object_tf_for_anything = new EnumMap<TraceFormatRestriction, TraceFormat>(TraceFormatRestriction.class);
    private boolean found_undefined = false;
    private TracingParameters tparams = new TracingParameters();
    private Marker tf_printing_tc;

    private static Map<TraceFormatRestriction, Map<SymbolImpl, TraceFormat>> createMap() {
        return new EnumMap<TraceFormatRestriction, Map<SymbolImpl, TraceFormat>>(TraceFormatRestriction.class);
    }

    public TraceFormats(Agent context) {
        this.context = context;
        for (TraceFormatRestriction r : TraceFormatRestriction.values()) {
            this.stack_tr_ht.put(r, new HashMap());
            this.object_tr_ht.put(r, new HashMap());
        }
    }

    public void initalize() {
        this.predefinedSyms = Adaptables.adapt(this.context, PredefinedSymbols.class);
        this.decisionCycle = Adaptables.adapt(this.context, DecisionCycle.class);
    }

    private TraceFormat parse_format_string(String string) {
        this.format = string;
        TraceFormat prev = null;
        TraceFormat first = null;
        this.offset = 0;
        while (this.offset < string.length()) {
            TraceFormat New = this.parse_item_from_format_string();
            if (New == null) {
                this.context.getPrinter().error("Error:  bad trace format string: %s\n", string);
                if (this.format_string_error_message != null) {
                    this.context.getPrinter().print(" %s\n Error found at: %s\n", this.format_string_error_message, this.format);
                }
                return null;
            }
            if (prev != null) {
                prev.next = New;
            } else {
                first = New;
            }
            prev = New;
        }
        if (prev != null) {
            prev.next = null;
        } else {
            first = null;
        }
        return first;
    }

    private List<Symbol> parse_attribute_path_in_brackets() {
        if (this.format.charAt(this.offset) != '[') {
            this.format_string_error_message = "Expected '[' followed by attribute (path)";
            return null;
        }
        ++this.offset;
        ArrayList<Symbol> path = null;
        if (this.format.charAt(this.offset) == '*') {
            path = null;
            ++this.offset;
        } else {
            path = new ArrayList<Symbol>();
            while (true) {
                String name = "";
                while (this.offset != this.format.length() && this.format.charAt(this.offset) != ']' && this.format.charAt(this.offset) != '.') {
                    name = name + this.format.charAt(this.offset);
                    ++this.offset;
                }
                if (this.offset == this.format.length()) {
                    this.format_string_error_message = "'[' without closing ']'";
                    return null;
                }
                if (name.length() == 0) {
                    this.format_string_error_message = "null attribute found in attribute path";
                    return null;
                }
                path.add(this.context.getSymbols().createString(name));
                if (this.format.charAt(this.offset) == ']') break;
                ++this.offset;
            }
        }
        if (this.format.charAt(this.offset) != ']') {
            this.format_string_error_message = "'[' without closing ']'";
            return null;
        }
        ++this.offset;
        return path;
    }

    private TraceFormat parse_pattern_in_brackets(boolean read_opening_bracket) {
        if (read_opening_bracket) {
            if (this.format.charAt(this.offset) != '[') {
                this.format_string_error_message = "Expected '[' followed by attribute path";
                return null;
            }
            ++this.offset;
        }
        TraceFormat prev = null;
        TraceFormat first = null;
        while (this.offset < this.format.length() && this.format.charAt(this.offset) != ']') {
            TraceFormat New = this.parse_item_from_format_string();
            if (New == null) {
                return null;
            }
            if (prev != null) {
                prev.next = New;
            } else {
                first = New;
            }
            prev = New;
        }
        if (prev != null) {
            prev.next = null;
        } else {
            first = null;
        }
        if (this.format.charAt(this.offset) != ']') {
            this.format_string_error_message = "'[' without closing ']'";
            return null;
        }
        ++this.offset;
        return first;
    }

    private TraceFormat parse_item_from_format_string() {
        if (this.offset >= this.format.length()) {
            return null;
        }
        if (this.format.charAt(this.offset) == ']') {
            return null;
        }
        if (this.format.charAt(this.offset) == '[') {
            this.format_string_error_message = "unexpected '[' character";
            return null;
        }
        if (this.format.charAt(this.offset) != '%') {
            String buf = "";
            while (this.offset < this.format.length() && this.format.charAt(this.offset) != '%' && this.format.charAt(this.offset) != '[' && this.format.charAt(this.offset) != ']') {
                buf = buf + this.format.charAt(this.offset);
                ++this.offset;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.STRING_TFT;
            tf.data_string = buf;
            return tf;
        }
        if (this.format.startsWith("%v", this.offset)) {
            this.offset += 2;
            List<Symbol> attribute_path = this.parse_attribute_path_in_brackets();
            if (this.format_string_error_message != null) {
                return null;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.VALUES_TFT;
            tf.data_attribute_path = attribute_path;
            return tf;
        }
        if (this.format.startsWith("%o", this.offset)) {
            this.offset += 2;
            List<Symbol> attribute_path = this.parse_attribute_path_in_brackets();
            if (this.format_string_error_message != null) {
                return null;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.VALUES_RECURSIVELY_TFT;
            tf.data_attribute_path = attribute_path;
            return tf;
        }
        if (this.format.startsWith("%av", this.offset)) {
            this.offset += 3;
            List<Symbol> attribute_path = this.parse_attribute_path_in_brackets();
            if (this.format_string_error_message != null) {
                return null;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.ATTS_AND_VALUES_TFT;
            tf.data_attribute_path = attribute_path;
            return tf;
        }
        if (this.format.startsWith("%ao", this.offset)) {
            this.offset += 3;
            List<Symbol> attribute_path = this.parse_attribute_path_in_brackets();
            if (this.format_string_error_message != null) {
                return null;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.ATTS_AND_VALUES_RECURSIVELY_TFT;
            tf.data_attribute_path = attribute_path;
            return tf;
        }
        if (this.format.startsWith("%cs", this.offset)) {
            this.offset += 3;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.CURRENT_STATE_TFT;
            return tf;
        }
        if (this.format.startsWith("%co", this.offset)) {
            this.offset += 3;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.CURRENT_OPERATOR_TFT;
            return tf;
        }
        if (this.format.startsWith("%dc", this.offset)) {
            this.offset += 3;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.DECISION_CYCLE_COUNT_TFT;
            return tf;
        }
        if (this.format.startsWith("%ec", this.offset)) {
            this.offset += 3;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.ELABORATION_CYCLE_COUNT_TFT;
            return tf;
        }
        if (this.format.startsWith("%%", this.offset)) {
            this.offset += 2;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.PERCENT_TFT;
            return tf;
        }
        if (this.format.startsWith("%[", this.offset)) {
            this.offset += 2;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.L_BRACKET_TFT;
            return tf;
        }
        if (this.format.startsWith("%]", this.offset)) {
            this.offset += 2;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.R_BRACKET_TFT;
            return tf;
        }
        if (this.format.startsWith("%sd", this.offset)) {
            this.offset += 3;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.SUBGOAL_DEPTH_TFT;
            return tf;
        }
        if (this.format.startsWith("%id", this.offset)) {
            this.offset += 3;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.IDENTIFIER_TFT;
            return tf;
        }
        if (this.format.startsWith("%ifdef", this.offset)) {
            this.offset += 6;
            TraceFormat pattern = this.parse_pattern_in_brackets(true);
            if (this.format_string_error_message != null) {
                return null;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.IF_ALL_DEFINED_TFT;
            tf.data_subformat = pattern;
            return tf;
        }
        if (this.format.startsWith("%left", this.offset)) {
            this.offset += 5;
            if (this.format.charAt(this.offset) != '[') {
                this.format_string_error_message = "Expected '[' after %left";
                return null;
            }
            ++this.offset;
            if (!Character.isDigit(this.format.charAt(this.offset))) {
                this.format_string_error_message = "Expected number with %left";
                return null;
            }
            int n = 0;
            while (Character.isDigit(this.format.charAt(this.offset))) {
                n = 10 * n + (this.format.charAt(this.offset++) - 48);
            }
            if (this.format.charAt(this.offset) != ',') {
                this.format_string_error_message = "Expected ',' after number in %left";
                return null;
            }
            ++this.offset;
            TraceFormat pattern = this.parse_pattern_in_brackets(false);
            if (this.format_string_error_message != null) {
                return null;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.LEFT_JUSTIFY_TFT;
            tf.num = n;
            tf.data_subformat = pattern;
            return tf;
        }
        if (this.format.startsWith("%right", this.offset)) {
            this.offset += 6;
            if (this.format.charAt(this.offset) != '[') {
                this.format_string_error_message = "Expected '[' after %right";
                return null;
            }
            ++this.offset;
            if (!Character.isDigit(this.format.charAt(this.offset))) {
                this.format_string_error_message = "Expected number with %right";
                return null;
            }
            int n = 0;
            while (Character.isDigit(this.format.charAt(this.offset))) {
                n = 10 * n + (this.format.charAt(this.offset++) - 48);
            }
            if (this.format.charAt(this.offset) != ',') {
                this.format_string_error_message = "Expected ',' after number in %right";
                return null;
            }
            ++this.offset;
            TraceFormat pattern = this.parse_pattern_in_brackets(false);
            if (this.format_string_error_message != null) {
                return null;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.RIGHT_JUSTIFY_TFT;
            tf.num = n;
            tf.data_subformat = pattern;
            return tf;
        }
        if (this.format.startsWith("%rsd", this.offset)) {
            this.offset += 4;
            TraceFormat pattern = this.parse_pattern_in_brackets(true);
            if (this.format_string_error_message != null) {
                return null;
            }
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.REPEAT_SUBGOAL_DEPTH_TFT;
            tf.data_subformat = pattern;
            return tf;
        }
        if (this.format.startsWith("%nl", this.offset)) {
            this.offset += 3;
            TraceFormat tf = new TraceFormat();
            tf.type = TraceFormatType.NEWLINE_TFT;
            return tf;
        }
        this.format_string_error_message = "Unrecognized escape sequence";
        return null;
    }

    private TraceFormat lookup_trace_format(boolean stack_trace, TraceFormatRestriction type_restriction, SymbolImpl name_restriction) {
        if (name_restriction != null) {
            if (stack_trace) {
                return this.stack_tr_ht.get((Object)type_restriction).get(name_restriction);
            }
            return this.object_tr_ht.get((Object)type_restriction).get(name_restriction);
        }
        if (stack_trace) {
            return this.stack_tf_for_anything.get((Object)type_restriction);
        }
        return this.object_tf_for_anything.get((Object)type_restriction);
    }

    public boolean remove_trace_format(boolean stack_trace, TraceFormatRestriction type_restriction, SymbolImpl name_restriction) {
        if (name_restriction != null) {
            if (stack_trace) {
                return null != this.stack_tr_ht.get((Object)type_restriction).remove(name_restriction);
            }
            return null != this.object_tr_ht.get((Object)type_restriction).remove(name_restriction);
        }
        if (stack_trace) {
            return null != this.stack_tf_for_anything.remove((Object)type_restriction);
        }
        return null != this.object_tf_for_anything.remove((Object)type_restriction);
    }

    public boolean add_trace_format(boolean stack_trace, TraceFormatRestriction type_restriction, SymbolImpl name_restriction, String format_string) {
        TraceFormat new_tf = this.parse_format_string(format_string);
        if (new_tf == null) {
            return false;
        }
        this.remove_trace_format(stack_trace, type_restriction, name_restriction);
        if (name_restriction != null) {
            if (stack_trace) {
                this.stack_tr_ht.get((Object)type_restriction).put(name_restriction, new_tf);
            } else {
                this.object_tr_ht.get((Object)type_restriction).put(name_restriction, new_tf);
            }
            return true;
        }
        if (stack_trace) {
            this.stack_tf_for_anything.put(type_restriction, new_tf);
        } else {
            this.object_tf_for_anything.put(type_restriction, new_tf);
        }
        return true;
    }

    private int add_values_of_attribute_path(SymbolImpl object, List<Symbol> path, int pathIndex, StringBuilder result, boolean recursive, int count) {
        WmeImpl w;
        if (pathIndex >= path.size()) {
            result.append(" ");
            if (recursive) {
                result.append(this.object_to_trace_string(object));
            } else {
                result.append(String.format("%s", object));
            }
            return ++count;
        }
        IdentifierImpl id = object.asIdentifier();
        if (id == null) {
            return count;
        }
        WmeImpl wmeImpl = w = id.goalInfo != null ? id.goalInfo.getImpasseWmes() : null;
        while (w != null) {
            if (w.attr == path.get(pathIndex)) {
                count = this.add_values_of_attribute_path(w.value, path, pathIndex + 1, result, recursive, count);
            }
            w = w.next;
        }
        w = id.getInputWmes();
        while (w != null) {
            if (w.attr == path.get(pathIndex)) {
                count = this.add_values_of_attribute_path(w.value, path, pathIndex + 1, result, recursive, count);
            }
            w = w.next;
        }
        Slot s = Slot.find_slot(id, path.get(pathIndex));
        if (s != null) {
            WmeImpl w2 = s.getWmes();
            while (w2 != null) {
                count = this.add_values_of_attribute_path(w2.value, path, pathIndex + 1, result, recursive, count);
                w2 = w2.next;
            }
        }
        return count;
    }

    void add_trace_for_wme(StringBuilder result, WmeImpl w, boolean print_attribute, boolean recursive) {
        result.append(" ");
        if (print_attribute) {
            result.append("^");
            result.append(String.format("%s", w.attr));
            result.append(" ");
        }
        if (recursive) {
            result.append(this.object_to_trace_string(w.value));
        } else {
            result.append(String.format("%s", w.value));
        }
    }

    private void add_trace_for_attribute_path(SymbolImpl object, List<Symbol> path, StringBuilder result, boolean print_attributes, boolean recursive) {
        StringBuilder values = new StringBuilder();
        if (path.isEmpty()) {
            WmeImpl w;
            IdentifierImpl id = object.asIdentifier();
            if (id == null) {
                return;
            }
            Slot s = id.slots;
            while (s != null) {
                WmeImpl w2 = s.getWmes();
                while (w2 != null) {
                    this.add_trace_for_wme(values, w2, print_attributes, recursive);
                    w2 = w2.next;
                }
                s = s.next;
            }
            WmeImpl wmeImpl = w = id.goalInfo != null ? id.goalInfo.getImpasseWmes() : null;
            while (w != null) {
                this.add_trace_for_wme(values, w, print_attributes, recursive);
                w = w.next;
            }
            w = id.getInputWmes();
            while (w != null) {
                this.add_trace_for_wme(values, w, print_attributes, recursive);
                w = w.next;
            }
            if (values.length() > 0) {
                result.append(values.substring(1));
            }
            return;
        }
        int count = 0;
        if ((count = this.add_values_of_attribute_path(object, path, 0, values, recursive, count)) == 0) {
            this.found_undefined = true;
            return;
        }
        if (print_attributes) {
            result.append("^");
            Iterator<Symbol> it = path.iterator();
            while (it.hasNext()) {
                Symbol c = it.next();
                result.append(String.format("%s", c));
                if (!it.hasNext()) continue;
                result.append(".");
            }
            result.append(" ");
        }
        if (values.length() > 0) {
            result.append(values.substring(1));
        }
    }

    public String trace_format_list_to_string(TraceFormat tf, SymbolImpl object) {
        StringBuilder result = new StringBuilder();
        while (tf != null) {
            switch (tf.type) {
                case STRING_TFT: {
                    result.append(tf.data_string);
                    break;
                }
                case PERCENT_TFT: {
                    result.append("%");
                    break;
                }
                case L_BRACKET_TFT: {
                    result.append("[");
                    break;
                }
                case R_BRACKET_TFT: {
                    result.append("]");
                    break;
                }
                case VALUES_TFT: {
                    this.add_trace_for_attribute_path(object, tf.data_attribute_path, result, false, false);
                    break;
                }
                case VALUES_RECURSIVELY_TFT: {
                    this.add_trace_for_attribute_path(object, tf.data_attribute_path, result, false, true);
                    break;
                }
                case ATTS_AND_VALUES_TFT: {
                    this.add_trace_for_attribute_path(object, tf.data_attribute_path, result, true, false);
                    break;
                }
                case ATTS_AND_VALUES_RECURSIVELY_TFT: {
                    this.add_trace_for_attribute_path(object, tf.data_attribute_path, result, true, true);
                    break;
                }
                case CURRENT_STATE_TFT: {
                    if (this.tparams.current_s == null) {
                        this.found_undefined = true;
                        break;
                    }
                    String temp_gs = this.object_to_trace_string(this.tparams.current_s);
                    result.append(temp_gs);
                    break;
                }
                case CURRENT_OPERATOR_TFT: {
                    if (this.tparams.current_o == null) {
                        this.found_undefined = true;
                        break;
                    }
                    String temp_gs = this.object_to_trace_string(this.tparams.current_o);
                    result.append(temp_gs);
                    break;
                }
                case DECISION_CYCLE_COUNT_TFT: {
                    if (this.tparams.allow_cycle_counts) {
                        result.append(this.decisionCycle.d_cycle_count);
                        break;
                    }
                    this.found_undefined = true;
                    break;
                }
                case ELABORATION_CYCLE_COUNT_TFT: {
                    if (this.tparams.allow_cycle_counts) {
                        result.append(this.context.getProperties().get(SoarProperties.E_CYCLE_COUNT));
                        break;
                    }
                    this.found_undefined = true;
                    break;
                }
                case IDENTIFIER_TFT: {
                    result.append(String.format("%s", object));
                    break;
                }
                case IF_ALL_DEFINED_TFT: {
                    boolean saved_found_undefined = this.found_undefined;
                    this.found_undefined = false;
                    String temp_gs = this.trace_format_list_to_string(tf.data_subformat, object);
                    if (!this.found_undefined) {
                        result.append(temp_gs);
                    }
                    this.found_undefined = saved_found_undefined;
                    break;
                }
                case LEFT_JUSTIFY_TFT: {
                    String temp_gs = this.trace_format_list_to_string(tf.data_subformat, object);
                    result.append(temp_gs);
                    for (int i = tf.num - temp_gs.length(); i > 0; --i) {
                        result.append(" ");
                    }
                    break;
                }
                case RIGHT_JUSTIFY_TFT: {
                    String temp_gs = this.trace_format_list_to_string(tf.data_subformat, object);
                    for (int i = tf.num - temp_gs.length(); i > 0; --i) {
                        result.append(" ");
                    }
                    result.append(temp_gs);
                    break;
                }
                case SUBGOAL_DEPTH_TFT: {
                    if (this.tparams.current_s != null) {
                        result.append(this.tparams.current_s.level - 1);
                        break;
                    }
                    this.found_undefined = true;
                    break;
                }
                case REPEAT_SUBGOAL_DEPTH_TFT: {
                    if (this.tparams.current_s != null) {
                        String temp_gs = this.trace_format_list_to_string(tf.data_subformat, object);
                        for (int i = this.tparams.current_s.level - 1; i > 0; --i) {
                            result.append(temp_gs);
                        }
                        break;
                    }
                    this.found_undefined = true;
                    break;
                }
                case NEWLINE_TFT: {
                    result.append("\n");
                    break;
                }
                default: {
                    throw new IllegalStateException("Internal error: bad trace format type: " + (Object)((Object)tf.type));
                }
            }
            tf = tf.next;
        }
        return result.toString();
    }

    private TraceFormat find_appropriate_trace_format(boolean stack_trace, TraceFormatRestriction type, SymbolImpl name) {
        TraceFormat tf = this.lookup_trace_format(stack_trace, type, name);
        if (tf != null) {
            return tf;
        }
        if (type != TraceFormatRestriction.FOR_ANYTHING_TF && (tf = this.lookup_trace_format(stack_trace, TraceFormatRestriction.FOR_ANYTHING_TF, name)) != null) {
            return tf;
        }
        if (name != null && (tf = this.lookup_trace_format(stack_trace, type, null)) != null) {
            return tf;
        }
        return this.lookup_trace_format(stack_trace, TraceFormatRestriction.FOR_ANYTHING_TF, null);
    }

    private String object_to_trace_string(SymbolImpl object) {
        IdentifierImpl id = object.asIdentifier();
        if (id == null || id.tc_number == this.tf_printing_tc) {
            return String.format("%s", object);
        }
        id.tc_number = this.tf_printing_tc;
        TraceFormatRestriction type_of_object = id.isGoal() ? TraceFormatRestriction.FOR_STATES_TF : (id.isa_operator != 0 ? TraceFormatRestriction.FOR_OPERATORS_TF : TraceFormatRestriction.FOR_ANYTHING_TF);
        SymbolImpl name = TraceFormats.find_name_of_object(object, this.predefinedSyms.name_symbol);
        TraceFormat tf = this.find_appropriate_trace_format(false, type_of_object, name);
        String gs = null;
        if (tf != null) {
            TracingParameters saved_tparams = new TracingParameters(this.tparams);
            this.tparams.current_o = null;
            this.tparams.current_s = null;
            this.tparams.allow_cycle_counts = false;
            gs = this.trace_format_list_to_string(tf, object);
            this.tparams = saved_tparams;
        } else {
            gs = String.format("%s", object);
        }
        id.tc_number = null;
        return gs;
    }

    private String selection_to_trace_string(SymbolImpl object, IdentifierImpl current_state, TraceFormatRestriction selection_type, boolean allow_cycle_counts) {
        SymbolImpl name = null;
        TraceFormat tf = this.find_appropriate_trace_format(true, selection_type, name);
        if (tf == null) {
            return "";
        }
        TracingParameters saved_tparams = new TracingParameters(this.tparams);
        this.tparams.current_o = null;
        this.tparams.current_s = null;
        if (current_state != null) {
            this.tparams.current_s = current_state;
            if (current_state.goalInfo.operator_slot.getWmes() != null) {
                this.tparams.current_o = current_state.goalInfo.operator_slot.getWmes().value.asIdentifier();
            }
        }
        this.tparams.allow_cycle_counts = allow_cycle_counts;
        String gs = this.trace_format_list_to_string(tf, object);
        this.tparams = saved_tparams;
        return gs;
    }

    public void print_object_trace(Writer writer, SymbolImpl object) throws IOException {
        this.tf_printing_tc = DefaultMarker.create();
        String gs = this.object_to_trace_string(object);
        writer.append(gs);
    }

    public void print_stack_trace(Writer writer, SymbolImpl object, IdentifierImpl state, TraceFormatRestriction slot_type, boolean allow_cycle_counts) throws IOException {
        this.tf_printing_tc = DefaultMarker.create();
        String gs = this.selection_to_trace_string(object, state, slot_type, allow_cycle_counts);
        writer.append(gs);
    }

    public void print_lowest_slot_in_context_stack(Writer writer, IdentifierImpl bottom_goal) throws IOException {
        if (bottom_goal.goalInfo.operator_slot.getWmes() != null) {
            this.print_stack_trace(writer, bottom_goal.goalInfo.operator_slot.getWmes().value, bottom_goal, TraceFormatRestriction.FOR_OPERATORS_TF, true);
        } else {
            this.print_stack_trace(writer, bottom_goal, bottom_goal, TraceFormatRestriction.FOR_STATES_TF, true);
        }
    }

    private static SymbolImpl find_name_of_object(SymbolImpl object, StringSymbolImpl name_symbol) {
        IdentifierImpl id = object.asIdentifier();
        if (id == null) {
            return null;
        }
        Slot s = Slot.find_slot(id, name_symbol);
        if (s == null) {
            return null;
        }
        return s.getWmes() != null ? s.getWmes().value : null;
    }

    private static class TracingParameters {
        IdentifierImpl current_s = null;
        IdentifierImpl current_o = null;
        boolean allow_cycle_counts = false;

        public TracingParameters() {
        }

        public TracingParameters(TracingParameters other) {
            this.current_s = other.current_s;
            this.current_o = other.current_o;
            this.allow_cycle_counts = other.allow_cycle_counts;
        }
    }
}

