/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.kernel.wma;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.kernel.memory.Wme;
import org.jsoar.kernel.rete.Rete;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivation;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivationParams;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivationStats;
import org.jsoar.kernel.wma.DefaultWorkingMemoryActivationTimers;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.adaptables.Adaptables;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommandProvider;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyManager;
import org.jsoar.util.timing.ExecutionTimer;
import picocli.CommandLine;

public class WMActivationCommand
implements SoarCommand {
    private final DefaultWorkingMemoryActivation wma;
    private final Rete rete;
    private Agent agent;

    public WMActivationCommand(Adaptable context) {
        this.agent = (Agent)context;
        this.wma = Adaptables.require(this.getClass(), this.agent, DefaultWorkingMemoryActivation.class);
        this.rete = Adaptables.adapt(this.agent, Rete.class);
    }

    @Override
    public String execute(SoarCommandContext context, String[] args) throws SoarException {
        Utils.parseAndRun(this.agent, new WM(this.wma, this.rete, this.agent), args);
        return "";
    }

    @Override
    public Object getCommand() {
        return new WM(this.wma, this.rete, this.agent);
    }

    @CommandLine.Command(name="activation", description={"Changes the behavior of and displays information about working memory activation"}, subcommands={CommandLine.HelpCommand.class})
    public static class Activation
    implements Runnable {
        @CommandLine.ParentCommand
        WM parent;
        @CommandLine.Option(names={"-g", "--get"}, description={"Print current parameter setting"})
        String getParam = null;
        @CommandLine.Option(names={"-s", "--set"}, description={"Set parameter value"})
        String setParam = null;
        @CommandLine.Option(names={"-S", "--stats"}, description={"Print statistic summary or specific statistic"})
        boolean printStats = false;
        @CommandLine.Option(names={"-t", "--timers"}, description={"Print timer summary or specific timer"})
        boolean printTimer = false;
        @CommandLine.Option(names={"-h", "--history"}, description={"Print reference history of a WME"})
        boolean printHistory = false;
        @CommandLine.Parameters(arity="0..1", description={"Set value, specific statistic, specific timer, or WME timetag"})
        String param = null;

        @Override
        public void run() {
            if (this.getParam != null) {
                this.doGet(this.getParam);
            } else if (this.setParam != null) {
                this.doSet(this.setParam, this.param);
            } else if (this.printStats) {
                this.doStats(this.param);
            } else if (this.printTimer) {
                this.doTimers(this.param);
            } else if (this.printHistory) {
                this.doHistory(this.param);
            } else {
                this.doWma();
            }
        }

        private void doGet(String param) {
            PropertyKey<?> key = DefaultWorkingMemoryActivationParams.getProperty(this.parent.wma.getParams().getProperties(), param);
            if (key == null) {
                this.parent.agent.getPrinter().startNewLine().print("Unknown parameter '" + param + "'");
                return;
            }
            this.parent.agent.getPrinter().startNewLine().print(this.parent.wma.getParams().getProperties().get(key).toString());
        }

        private void doSet(String param, String value) {
            PropertyManager props = this.parent.wma.getParams().getProperties();
            try {
                if (value == null) {
                    this.parent.agent.getPrinter().startNewLine().print("Set value not specified");
                } else if (param.equals("activation")) {
                    props.set(DefaultWorkingMemoryActivationParams.ACTIVATION, DefaultWorkingMemoryActivationParams.ActivationChoices.valueOf(value));
                } else if (param.equals("timers")) {
                    props.set(DefaultWorkingMemoryActivationParams.TIMERS, DefaultWorkingMemoryActivationParams.TimerLevels.valueOf(value));
                } else if (props.get(DefaultWorkingMemoryActivationParams.ACTIVATION) == DefaultWorkingMemoryActivationParams.ActivationChoices.on) {
                    this.parent.agent.getPrinter().startNewLine().print("This parameter is protected while WMA is on.");
                } else if (param.equals("decay-rate")) {
                    props.set(DefaultWorkingMemoryActivationParams.DECAY_RATE, -Double.valueOf(value).doubleValue());
                } else if (param.equals("decay-thresh")) {
                    props.set(DefaultWorkingMemoryActivationParams.DECAY_THRESH, -Double.valueOf(value).doubleValue());
                } else if (param.equals("forgetting")) {
                    props.set(DefaultWorkingMemoryActivationParams.FORGETTING_CHOICES, "on".equals(value) ? DefaultWorkingMemoryActivationParams.ForgettingChoices.approx : DefaultWorkingMemoryActivationParams.ForgettingChoices.valueOf(value));
                } else if (param.equals("forget-wme")) {
                    props.set(DefaultWorkingMemoryActivationParams.FORGET_WME_CHOICES, DefaultWorkingMemoryActivationParams.ForgetWmeChoices.valueOf(value));
                } else if (param.equals("fake-forgetting")) {
                    props.set(DefaultWorkingMemoryActivationParams.FAKE_FORGETTING, DefaultWorkingMemoryActivationParams.FakeForgettingChoices.valueOf(value));
                } else if (param.equals("max-pow-cache")) {
                    props.set(DefaultWorkingMemoryActivationParams.MAX_POW_CACHE, Integer.valueOf(value));
                } else if (param.equals("petrov-approx")) {
                    props.set(DefaultWorkingMemoryActivationParams.PETROV_APPROX, DefaultWorkingMemoryActivationParams.PetrovApproxChoices.valueOf(value));
                } else {
                    this.parent.agent.getPrinter().startNewLine().print("Unknown parameter '" + param + "'");
                }
            }
            catch (IllegalArgumentException e) {
                this.parent.agent.getPrinter().startNewLine().print("Invalid value.");
            }
        }

        private void doStats(String param) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DefaultWorkingMemoryActivationStats p = this.parent.wma.getStats();
            if (param == null) {
                pw.printf("Forgotten WMEs: %d%n", p.forgotten_wmes.get());
            } else {
                PropertyKey<?> key = DefaultWorkingMemoryActivationStats.getProperty(this.parent.wma.getParams().getProperties(), param);
                if (key == null) {
                    this.parent.agent.getPrinter().startNewLine().print("Unknown stat '" + param + "'");
                    return;
                }
                pw.printf("%s%n", this.parent.wma.getParams().getProperties().get(key).toString());
            }
            pw.flush();
            this.parent.agent.getPrinter().startNewLine().print(sw.toString());
        }

        private void doTimers(String param) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DefaultWorkingMemoryActivationTimers t = this.parent.wma.getTimers();
            if (param == null) {
                pw.printf("timers:\n", new Object[0]);
                pw.printf("%s: %f\n", t.forgetting.getName(), t.forgetting.getTotalSeconds());
                pw.printf("%s: %f\n", t.history.getName(), t.history.getTotalSeconds());
            } else {
                ExecutionTimer timer = t.get(param);
                if (timer == null) {
                    this.parent.agent.getPrinter().startNewLine().print("Unknown timer '" + param + "'");
                    return;
                }
                pw.printf("%f", timer.getTotalSeconds());
            }
            pw.flush();
            this.parent.agent.getPrinter().startNewLine().print(sw.toString());
        }

        private void doHistory(String param) {
            long timetag;
            if (param == null) {
                this.parent.agent.getPrinter().startNewLine().print("Timetag argument required.");
                return;
            }
            try {
                timetag = Long.valueOf(param);
            }
            catch (NumberFormatException ignored) {
                this.parent.agent.getPrinter().startNewLine().print("Timetag must be a valid integer.");
                return;
            }
            if (timetag == 0L) {
                this.parent.agent.getPrinter().startNewLine().print("Invalid timetag.");
                return;
            }
            Wme wme = null;
            for (Wme wme2 : this.parent.rete.getAllWmes()) {
                if ((long)wme2.getTimetag() != timetag) continue;
                wme = wme2;
                break;
            }
            if (wme != null) {
                this.parent.agent.getPrinter().startNewLine().print(this.parent.wma.wma_get_wme_history(wme));
            }
            this.parent.agent.getPrinter().startNewLine().print("WME has no decay history");
        }

        private void doWma() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DefaultWorkingMemoryActivationParams p = this.parent.wma.getParams();
            pw.printf("WMA activation: %s%n", p.activation.get());
            pw.println();
            pw.println("Activation");
            pw.println("----------");
            pw.printf("decay-rate: %f%n", p.decay_rate.get());
            pw.printf("petrov-approx: %s%n", p.petrov_approx.get());
            pw.println();
            pw.println("Forgetting");
            pw.println("----------");
            pw.printf("decay-thresh: %f%n", p.decay_thresh.get());
            pw.printf("forgetting: %s%n", p.forgetting.get());
            pw.printf("forget-wme: %s%n", p.forget_wme.get());
            pw.printf("fake-forgetting: %s%n", p.fake_forgetting.get());
            pw.println();
            pw.println("Performance");
            pw.println("-----------");
            pw.printf("timers: %s%n", p.timers.get());
            pw.printf("max-pow-cache: %d%n", p.max_pow_cache.get());
            pw.flush();
            this.parent.agent.getPrinter().startNewLine().print(sw.toString());
        }
    }

    @CommandLine.Command(name="wm", description={"Commands and settings related to working memory"}, subcommands={CommandLine.HelpCommand.class, Activation.class})
    public static class WM
    implements Runnable {
        private final DefaultWorkingMemoryActivation wma;
        private final Rete rete;
        private Agent agent;

        public WM(DefaultWorkingMemoryActivation wma, Rete rete, Agent agent) {
            this.wma = wma;
            this.rete = rete;
            this.agent = agent;
        }

        @Override
        public void run() {
            this.agent.getPrinter().startNewLine().print("The 'wm' commands interact with working memory contents and settings.");
        }
    }

    public static class Provider
    implements SoarCommandProvider {
        @Override
        public void registerCommands(SoarCommandInterpreter interp, Adaptable context) {
            interp.addCommand("wm", new WMActivationCommand(context));
        }
    }
}

