/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegilimensStarter {
    private static final Logger logger = LoggerFactory.getLogger(LegilimensStarter.class);
    public static final String AUTO_START_PROPERTY = "jsoar.legilimens.autoStart";

    public static void startIfAutoStartEnabled() {
        String property = System.getProperty(AUTO_START_PROPERTY, "false");
        if (Boolean.valueOf(property).booleanValue()) {
            LegilimensStarter.start();
        }
    }

    public static void start() {
        logger.info("Attempting to start Legilimens server, if available");
        Class<?> serverClass = LegilimensStarter.getServerClass();
        if (serverClass == null) {
            return;
        }
        Method startMethod = LegilimensStarter.getStartMethod(serverClass);
        if (startMethod == null) {
            return;
        }
        try {
            startMethod.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Failed to start Legilimens: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.warn("Failed to start Legilimens: " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn("Failed to start Legilimens: " + e.getMessage(), (Throwable)e);
        }
    }

    public static Class<?> getServerClass() {
        try {
            return Class.forName("org.jsoar.legilimens.LegilimensServer");
        }
        catch (ClassNotFoundException e) {
            logger.warn("Could not locate LegilimensServer class.");
            return null;
        }
    }

    public static Method getStartMethod(Class<?> serverClass) {
        try {
            return serverClass.getMethod("start", new Class[0]);
        }
        catch (SecurityException e) {
            logger.warn("Could not find start() method on LegilimensServer class: " + e.getMessage());
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.warn("Could not find start() method on LegilimensServer class: " + e.getMessage());
            return null;
        }
    }
}

