/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.runtime;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.AgentRunController;
import org.jsoar.kernel.DebuggerProvider;
import org.jsoar.kernel.Phase;
import org.jsoar.kernel.ProductionManager;
import org.jsoar.kernel.RunType;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.commands.RunCommand;
import org.jsoar.kernel.commands.SoarSettingsCommand;
import org.jsoar.kernel.events.RunLoopEvent;
import org.jsoar.kernel.events.StartEvent;
import org.jsoar.kernel.events.StopEvent;
import org.jsoar.kernel.events.UncaughtExceptionEvent;
import org.jsoar.kernel.io.InputOutput;
import org.jsoar.kernel.rhs.functions.RhsFunctionManager;
import org.jsoar.kernel.symbols.SymbolFactory;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.kernel.tracing.Trace;
import org.jsoar.runtime.CompletionHandler;
import org.jsoar.runtime.ThreadedAgentManager;
import org.jsoar.runtime.WaitManager;
import org.jsoar.runtime.WaitRhsFunction;
import org.jsoar.util.StringTools;
import org.jsoar.util.adaptables.AbstractAdaptable;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;
import org.jsoar.util.events.SoarEventManager;
import org.jsoar.util.properties.PropertyManager;
import org.jsoar.util.properties.PropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedAgent
extends AbstractAdaptable
implements AgentRunController {
    private static final Logger logger = LoggerFactory.getLogger(ThreadedAgent.class);
    private final Agent agent;
    private final BlockingQueue<Runnable> commands = new LinkedBlockingQueue<Runnable>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean agentRunning = new AtomicBoolean(false);
    private final PropertyProvider<Boolean> agentRunningProvider = new PropertyProvider<Boolean>(){

        @Override
        public Boolean get() {
            return ThreadedAgent.this.agentRunning.get();
        }

        @Override
        public Boolean set(Boolean value) {
            throw new UnsupportedOperationException(SoarProperties.IS_RUNNING.getName() + " property is read-only");
        }
    };
    private final AgentThread agentThread = new AgentThread();
    private final WaitManager waitManager = new WaitManager();
    private final WaitRhsFunction waitFunction = new WaitRhsFunction();
    private final RunCommand runCommand = new RunCommand(this);
    private final SoarSettingsCommand soarCommand = new SoarSettingsCommand(this);

    public static ThreadedAgent create() {
        return ThreadedAgent.create(null);
    }

    public static ThreadedAgent create(String name) {
        return ThreadedAgentManager.INSTANCE.create(name);
    }

    public static ThreadedAgent find(Agent agent) {
        return ThreadedAgentManager.INSTANCE.find(agent);
    }

    public static List<ThreadedAgent> getAll() {
        return ThreadedAgentManager.INSTANCE.getAll();
    }

    public static ThreadedAgent attach(Agent agent) {
        return ThreadedAgentManager.INSTANCE.attach(agent);
    }

    public static SoarEventManager getEventManager() {
        return ThreadedAgentManager.INSTANCE.getEventManager();
    }

    ThreadedAgent(Agent agent) {
        this.agent = agent;
        this.agentThread.setName("Agent '" + this.agent + "' thread");
        this.agent.getProperties().setProvider(SoarProperties.IS_RUNNING, this.agentRunningProvider);
        this.getEvents().addListener(RunLoopEvent.class, new SoarEventListener(){

            @Override
            public void onEvent(SoarEvent event) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptAgentException();
                }
                Runnable runnable = (Runnable)ThreadedAgent.this.commands.poll();
                while (runnable != null) {
                    runnable.run();
                    runnable = (Runnable)ThreadedAgent.this.commands.poll();
                }
            }
        });
        this.waitManager.attach(this);
        this.waitFunction.attach(this.waitManager);
        SoarCommandInterpreter interp = agent.getInterpreter();
        interp.addCommand("run", this.runCommand);
        interp.addCommand("soar", this.soarCommand);
    }

    public ThreadedAgent initialize() {
        return this.initialize(null);
    }

    public ThreadedAgent initialize(CompletionHandler<Void> done) {
        if (!this.initialized.getAndSet(true)) {
            this.agentThread.start();
        }
        this.execute(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ThreadedAgent.this.agent.initialize();
                return null;
            }
        }, done);
        return this;
    }

    public void detach() {
        try {
            this.agentThread.interrupt();
            try {
                this.agentThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Interrupted while waiting for agent thread to exit", (Throwable)e);
            }
            this.waitFunction.detach();
            this.waitManager.detach();
        }
        finally {
            ThreadedAgentManager.INSTANCE.detach(this);
        }
    }

    public void dispose() {
        this.detach();
        this.agent.dispose();
    }

    public boolean isAgentThread() {
        return Thread.currentThread().equals(this.agentThread);
    }

    public Agent getAgent() {
        return this.agent;
    }

    public boolean isRunning() {
        return this.agentRunning.get();
    }

    @Override
    public Phase getStopPhase() {
        return this.agent.getStopPhase();
    }

    @Override
    public void setStopPhase(Phase phase) {
        this.agent.setStopPhase(phase);
    }

    @Override
    public void runFor(final long n, final RunType runType) {
        if (this.agentRunning.getAndSet(true)) {
            return;
        }
        this.agent.getProperties().firePropertyChanged(SoarProperties.IS_RUNNING, true, false);
        this.execute(new Callable<Void>(){

            @Override
            public Void call() {
                ThreadedAgent.this.getEvents().fireEvent(new StartEvent(ThreadedAgent.this.agent));
                try {
                    ThreadedAgent.this.agent.runFor(n, runType);
                }
                finally {
                    ThreadedAgent.this.agentRunning.set(false);
                    ThreadedAgent.this.agent.getProperties().firePropertyChanged(SoarProperties.IS_RUNNING, false, true);
                    ThreadedAgent.this.getEvents().fireEvent(new StopEvent(ThreadedAgent.this.agent));
                }
                return null;
            }
        }, null);
    }

    public void runForever() {
        this.runFor(0L, RunType.FOREVER);
    }

    public void stop() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                ThreadedAgent.this.agent.stop();
            }
        });
    }

    public String getName() {
        return this.agent.getName();
    }

    public void setName(String name) {
        this.agent.setName(name);
        this.agentThread.setName("Agent '" + this.agent + "' thread");
    }

    public SoarCommandInterpreter getInterpreter() {
        return this.agent.getInterpreter();
    }

    public Printer getPrinter() {
        return this.agent.getPrinter();
    }

    public Trace getTrace() {
        return this.agent.getTrace();
    }

    public SoarEventManager getEvents() {
        return this.agent.getEvents();
    }

    public PropertyManager getProperties() {
        return this.agent.getProperties();
    }

    public SymbolFactory getSymbols() {
        return this.agent.getSymbols();
    }

    public InputOutput getInputOutput() {
        return this.agent.getInputOutput();
    }

    public ProductionManager getProductions() {
        return this.agent.getProductions();
    }

    public RhsFunctionManager getRhsFunctions() {
        return this.agent.getRhsFunctions();
    }

    public DebuggerProvider getDebuggerProvider() {
        return this.agent.getDebuggerProvider();
    }

    public void setDebuggerProvider(DebuggerProvider p) {
        this.agent.setDebuggerProvider(p);
    }

    public void openDebugger() throws SoarException {
        this.agent.openDebugger();
    }

    public void openDebuggerAndWait() throws SoarException, InterruptedException {
        this.agent.openDebuggerAndWait();
    }

    private void execute(Runnable runnable) {
        if (!this.isAgentThread()) {
            this.commands.add(runnable);
        } else {
            runnable.run();
        }
    }

    public <V> void execute(final Callable<V> callable, final CompletionHandler<V> finish) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = callable.call();
                    if (finish != null) {
                        finish.finish(result);
                    }
                }
                catch (InterruptAgentException e) {
                    throw e;
                }
                catch (Exception e) {
                    ThreadedAgent.this.processUncaughtException(e);
                }
            }
        });
    }

    public <V> V executeAndWait(Callable<V> callable, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<V> task = new FutureTask<V>(callable);
        this.execute(task);
        return task.get(timeout, timeUnit);
    }

    BlockingQueue<Runnable> getCommandQueue() {
        return this.commands;
    }

    @Override
    public Object getAdapter(Class<?> klass) {
        if (klass.equals(WaitManager.class)) {
            return this.waitManager;
        }
        Object result = this.agent.getAdapter(klass);
        if (result != null) {
            return result;
        }
        return super.getAdapter(klass);
    }

    public String toString() {
        return this.agent.toString();
    }

    private void processUncaughtException(Exception e) {
        try {
            Throwable cause = e.getCause();
            logger.error("Agent thread caught unhandled exception", (Throwable)e);
            this.agent.getPrinter().error("Agent thread caught unhandled exception: " + (cause != null ? cause.getMessage() : e.getMessage()) + "\n" + StringTools.getStackTrace(e));
            this.getEvents().fireEvent(new UncaughtExceptionEvent(this.agent, e));
        }
        catch (Exception otherException) {
            logger.error("Exception thrown while handling uncaught exception", (Throwable)otherException);
        }
    }

    private static class InterruptAgentException
    extends RuntimeException {
        private static final long serialVersionUID = 3075897216751716278L;

        private InterruptAgentException() {
        }
    }

    private class AgentThread
    extends Thread {
        private AgentThread() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    ((Runnable)ThreadedAgent.this.commands.take()).run();
                }
                catch (InterruptAgentException e) {
                    this.interrupt();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                catch (Exception e) {
                    ThreadedAgent.this.processUncaughtException(e);
                }
            }
        }
    }
}

