/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.runtime;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.Agent;
import org.jsoar.runtime.CompletionHandler;
import org.jsoar.runtime.LegilimensStarter;
import org.jsoar.runtime.ThreadedAgent;
import org.jsoar.runtime.ThreadedAgentAttachedEvent;
import org.jsoar.runtime.ThreadedAgentDetachedEvent;
import org.jsoar.util.events.SoarEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum ThreadedAgentManager {
    INSTANCE;

    private static final Logger logger;
    private final Map<Agent, ThreadedAgent> agents = new MapMaker().weakKeys().makeMap();
    private final SoarEventManager events = new SoarEventManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadedAgent create(String name) {
        Map<Agent, ThreadedAgent> map = this.agents;
        synchronized (map) {
            ThreadedAgent agent = this.attach(new Agent(name, false)).initialize(new CompletionHandler<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void finish(Void result) {
                    Map map = ThreadedAgentManager.this.agents;
                    synchronized (map) {
                        ThreadedAgentManager.this.agents.notify();
                    }
                }
            });
            try {
                this.agents.wait();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted waiting for new ThreadedAgent to initialize.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            return agent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadedAgent find(Agent agent) {
        Map<Agent, ThreadedAgent> map = this.agents;
        synchronized (map) {
            return this.agents.get(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThreadedAgent> getAll() {
        Map<Agent, ThreadedAgent> map = this.agents;
        synchronized (map) {
            return new ArrayList<ThreadedAgent>(this.agents.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadedAgent attach(Agent agent) {
        Map<Agent, ThreadedAgent> map = this.agents;
        synchronized (map) {
            ThreadedAgent ta = this.agents.get(agent);
            if (ta == null) {
                ta = new ThreadedAgent(agent);
                this.agents.put(agent, ta);
                this.events.fireEvent(new ThreadedAgentAttachedEvent(ta));
            }
            LegilimensStarter.startIfAutoStartEnabled();
            return ta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(ThreadedAgent agent) {
        Map<Agent, ThreadedAgent> map = this.agents;
        synchronized (map) {
            this.agents.remove(agent.getAgent());
            this.events.fireEvent(new ThreadedAgentDetachedEvent(agent));
        }
    }

    public SoarEventManager getEventManager() {
        return this.events;
    }

    static {
        logger = LoggerFactory.getLogger(ThreadedAgentManager.class);
    }
}

