/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.runtime;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.jsoar.kernel.Agent;
import org.jsoar.kernel.JSoarVersion;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.events.AfterDecisionCycleEvent;
import org.jsoar.kernel.io.CycleCountInput;
import org.jsoar.kernel.tracing.Printer;
import org.jsoar.runtime.ThreadedAgent;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;

public class TinyDebugger
extends JApplet {
    private static final long serialVersionUID = 3028131188835230802L;
    private ThreadedAgent agent;
    private int sleepCounter = 0;
    private final JPanel tracePanel = new JPanel(new BorderLayout());
    private final JTextArea trace = new JTextArea();
    private final DefaultComboBoxModel promptModel = new DefaultComboBoxModel<Object>(new Object[]{"source http://darevay.com/jsoar/waterjugs.soar", "source http://darevay.com/jsoar/towers.soar", "run -d 1", "run", "stats", "p s1", "stop-soar", "init-soar", "waitsnc --on"});
    private final JComboBox prompt = new JComboBox(this.promptModel);
    private final JPanel productionPanel = new JPanel(new BorderLayout());
    private final JTextArea productionEditor = new JTextArea();
    private final JTabbedPane tabs = new JTabbedPane();
    private final Writer outputWriter = new Writer(){
        private StringBuilder buffer = new StringBuilder();

        @Override
        public void close() throws IOException {
        }

        @Override
        public synchronized void flush() throws IOException {
            final String output = this.buffer.toString();
            this.buffer.setLength(0);
            if (output.length() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TinyDebugger.this.trace.append(output);
                        int length = TinyDebugger.this.trace.getDocument().getLength();
                        if (length > 12000) {
                            try {
                                TinyDebugger.this.trace.getDocument().remove(0, length - 10000);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        TinyDebugger.this.trace.setCaretPosition(TinyDebugger.this.trace.getDocument().getLength());
                    }
                });
            }
        }

        @Override
        public synchronized void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer.append(cbuf, off, len);
        }
    };

    @Override
    public void init() {
        this.agent = ThreadedAgent.create();
        this.agent.getPrinter().pushWriter(this.outputWriter);
        new CycleCountInput(this.agent.getInputOutput());
        this.agent.getEvents().addListener(AfterDecisionCycleEvent.class, new SoarEventListener(){

            @Override
            public void onEvent(SoarEvent event) {
                TinyDebugger.this.sleepCounter = (TinyDebugger.this.sleepCounter + 1) % 100;
                if (TinyDebugger.this.sleepCounter == 0) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TinyDebugger.this.createUi();
                }
            });
        }
        catch (Exception e) {
            System.err.println("Failed to initialize: " + e);
        }
    }

    @Override
    public void destroy() {
        Agent inner = this.agent.getAgent();
        this.agent.detach();
        inner.dispose();
    }

    @Override
    public void stop() {
        this.agent.stop();
    }

    private void createUi() {
        this.trace.setFont(new Font("Monospaced", 0, 12));
        this.trace.setEditable(false);
        JSoarVersion version = JSoarVersion.getInstance();
        this.trace.setText("jsoar " + version + "\nhttp://jsoar.googlecode.com\n\n");
        this.tracePanel.add((Component)new JScrollPane(this.trace), "Center");
        JPanel promptPanel = new JPanel(new BorderLayout());
        this.prompt.setEditable(true);
        this.prompt.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TinyDebugger.this.executeCommand();
            }
        });
        promptPanel.add((Component)this.prompt, "Center");
        promptPanel.add((Component)new JButton(new AbstractAction("Stop!"){
            private static final long serialVersionUID = -8284340874152313700L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TinyDebugger.this.agent.stop();
            }
        }), "East");
        this.tracePanel.add((Component)promptPanel, "South");
        this.tabs.addTab("Trace", this.tracePanel);
        this.productionEditor.setFont(new Font("Monospaced", 0, 12));
        this.productionEditor.setText("# Enter production(s) here then click 'Load'\nsp {hello*world\n  (state <s> ^superstate nil)\n-->\n  (write (crlf) |Hello, world|)\n}\n");
        this.productionPanel.add((Component)new JScrollPane(this.productionEditor), "Center");
        this.productionPanel.add((Component)new JButton(new AbstractAction("Load"){
            private static final long serialVersionUID = -8284340874152313700L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TinyDebugger.this.loadProduction();
            }
        }), "South");
        this.tabs.addTab("Productions", this.productionPanel);
        this.setContentPane(this.tabs);
        this.agent.getPrinter().flush();
    }

    private void loadProduction() {
        final String command = this.productionEditor.getText();
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    TinyDebugger.this.agent.getInterpreter().eval(command);
                }
                catch (SoarException e) {
                    TinyDebugger.this.agent.getPrinter().print(e.getMessage()).flush();
                }
                return null;
            }
        };
        this.agent.execute(callable, null);
        this.tabs.setSelectedComponent(this.tracePanel);
    }

    private void executeCommand() {
        final String command = this.prompt.getEditor().getItem().toString().trim();
        if (command.length() == 0) {
            return;
        }
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String result;
                Printer printer = TinyDebugger.this.agent.getPrinter();
                try {
                    printer.startNewLine().print(command);
                    result = TinyDebugger.this.agent.getInterpreter().eval(command);
                }
                catch (SoarException e) {
                    result = "\n" + e.getMessage();
                }
                if (result != null && result.length() > 0) {
                    printer.print(result);
                }
                printer.flush();
                return null;
            }
        };
        this.agent.execute(callable, null);
        this.promptModel.removeElement(command);
        this.promptModel.insertElementAt(command, 0);
        this.prompt.setSelectedIndex(0);
        this.prompt.getEditor().selectAll();
    }
}

