/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.runtime;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jsoar.kernel.SoarProperties;
import org.jsoar.kernel.events.AfterDecisionCycleEvent;
import org.jsoar.kernel.events.AsynchronousInputReadyEvent;
import org.jsoar.kernel.events.PhaseEvents;
import org.jsoar.runtime.ThreadedAgent;
import org.jsoar.runtime.WaitInfo;
import org.jsoar.util.Arguments;
import org.jsoar.util.events.SoarEvent;
import org.jsoar.util.events.SoarEventListener;
import org.jsoar.util.properties.PropertyProvider;

public class WaitManager {
    private ThreadedAgent agent;
    private boolean inputReady = false;
    private SoarEventListener inputReadyListener;
    private final AsynchronousInputReadyCommand inputReadyCommand = new AsynchronousInputReadyCommand();
    private SoarEventListener afterInputListener;
    private SoarEventListener afterDecisionCycleListener;
    private WaitInfo requestedWaitInfo = WaitInfo.NOT_WAITING;
    private final AtomicReference<WaitInfo> waitInfo = new AtomicReference<WaitInfo>(WaitInfo.NOT_WAITING);
    private final PropertyProvider<WaitInfo> waitInfoProp = new PropertyProvider<WaitInfo>(){

        @Override
        public WaitInfo get() {
            return (WaitInfo)WaitManager.this.waitInfo.get();
        }

        @Override
        public WaitInfo set(WaitInfo value) {
            throw new IllegalArgumentException("Can't set wait_info property");
        }
    };

    public void attach(ThreadedAgent agent) {
        Arguments.checkNotNull(agent, "agent");
        if (this.agent != null) {
            throw new IllegalStateException("Already attached to agent");
        }
        this.agent = agent;
        this.inputReadyListener = new SoarEventListener(){

            @Override
            public void onEvent(SoarEvent event) {
                WaitManager.this.setNewInputAvailable();
            }
        };
        this.agent.getEvents().addListener(AsynchronousInputReadyEvent.class, this.inputReadyListener);
        this.afterDecisionCycleListener = new SoarEventListener(){

            @Override
            public void onEvent(SoarEvent event) {
                WaitManager.this.doWait();
            }
        };
        this.agent.getEvents().addListener(AfterDecisionCycleEvent.class, this.afterDecisionCycleListener);
        this.afterInputListener = new SoarEventListener(){

            @Override
            public void onEvent(SoarEvent event) {
                WaitManager.this.inputReady = false;
            }
        };
        this.agent.getEvents().addListener(PhaseEvents.AfterInput.class, this.afterInputListener);
        this.agent.getProperties().setProvider(SoarProperties.WAIT_INFO, this.waitInfoProp);
    }

    public void detach() {
        if (this.agent != null) {
            this.agent.getEvents().removeListener(null, this.inputReadyListener);
            this.agent.getEvents().removeListener(null, this.afterInputListener);
            this.agent.getEvents().removeListener(null, this.afterDecisionCycleListener);
            this.agent = null;
        }
    }

    public ThreadedAgent getAgent() {
        return this.agent;
    }

    public WaitInfo getWaitState() {
        return this.waitInfoProp.get();
    }

    public void requestWait(WaitInfo newWaitInfo) {
        if (!this.requestedWaitInfo.waiting || newWaitInfo.timeout < this.requestedWaitInfo.timeout) {
            this.requestedWaitInfo = newWaitInfo;
        }
    }

    public void requestResume() {
        if (this.agent != null) {
            this.agent.getInputOutput().asynchronousInputReady();
        }
    }

    private void doWait() {
        if (!this.requestedWaitInfo.waiting) {
            this.inputReady = false;
            return;
        }
        this.waitInfo.set(this.requestedWaitInfo);
        long start = System.currentTimeMillis();
        BlockingQueue<Runnable> commands = this.agent.getCommandQueue();
        boolean done = this.isDoneWaiting();
        while (!done) {
            try {
                Runnable command;
                long remaining = this.requestedWaitInfo.timeout - (System.currentTimeMillis() - start);
                if (remaining <= 0L) {
                    done = true;
                }
                if ((command = commands.poll(remaining, TimeUnit.MILLISECONDS)) != null) {
                    command.run();
                    done = this.isDoneWaiting();
                    continue;
                }
                done = true;
            }
            catch (InterruptedException e) {
                done = true;
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.requestedWaitInfo = WaitInfo.NOT_WAITING;
        this.inputReady = false;
        this.waitInfo.set(WaitInfo.NOT_WAITING);
    }

    private synchronized void setNewInputAvailable() {
        if (this.agent.isAgentThread()) {
            this.inputReady = true;
        } else {
            this.agent.execute(this.inputReadyCommand, null);
        }
    }

    private synchronized boolean isDoneWaiting() {
        return this.agent.getAgent().getReasonForStop() != null || this.inputReady || Thread.currentThread().isInterrupted();
    }

    private class AsynchronousInputReadyCommand
    implements Callable<Void> {
        private AsynchronousInputReadyCommand() {
        }

        @Override
        public Void call() throws Exception {
            WaitManager.this.inputReady = true;
            return null;
        }
    }
}

