/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.runtime;

import java.util.List;
import org.jsoar.kernel.rhs.functions.AbstractRhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctionContext;
import org.jsoar.kernel.rhs.functions.RhsFunctionException;
import org.jsoar.kernel.rhs.functions.RhsFunctionHandler;
import org.jsoar.kernel.rhs.functions.RhsFunctions;
import org.jsoar.kernel.symbols.Symbol;
import org.jsoar.runtime.ThreadedAgent;
import org.jsoar.runtime.WaitInfo;
import org.jsoar.runtime.WaitManager;
import org.jsoar.util.Arguments;

public class WaitRhsFunction
extends AbstractRhsFunctionHandler {
    private WaitManager waitManager;
    private ThreadedAgent agent;
    private RhsFunctionHandler oldHandler;

    public WaitRhsFunction() {
        super("wait", 0, 1);
    }

    public void attach(WaitManager waitManager) {
        Arguments.checkNotNull(waitManager, "waitManager");
        if (this.waitManager != null) {
            throw new IllegalStateException("Already attached to wait manager");
        }
        this.waitManager = waitManager;
        this.agent = this.waitManager.getAgent();
        if (this.agent == null) {
            throw new IllegalStateException("Wait manager is not attached to an agent");
        }
        this.oldHandler = this.agent.getRhsFunctions().registerHandler(this);
    }

    public void detach() {
        if (this.agent != null) {
            this.agent.getRhsFunctions().unregisterHandler(this.getName());
            if (this.oldHandler != null) {
                this.agent.getRhsFunctions().registerHandler(this.oldHandler);
                this.oldHandler = null;
            }
        }
        this.agent = null;
        this.waitManager = null;
    }

    @Override
    public Symbol execute(RhsFunctionContext context, List<Symbol> arguments) throws RhsFunctionException {
        RhsFunctions.checkArgumentCount(this, arguments);
        RhsFunctions.checkAllArgumentsAreNumeric(this.getName(), arguments);
        long timeout = arguments.isEmpty() ? Long.MAX_VALUE : arguments.get(0).asInteger().getValue();
        this.waitManager.requestWait(new WaitInfo(timeout, context.getProductionBeingFired()));
        return null;
    }

    @Override
    public boolean mayBeStandalone() {
        return true;
    }
}

