/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.script;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.jsoar.kernel.SoarException;
import org.jsoar.kernel.commands.Utils;
import org.jsoar.script.ScriptEngineState;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.commands.SoarCommand;
import org.jsoar.util.commands.SoarCommandContext;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommandProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class ScriptCommand
implements SoarCommand {
    private static final Logger logger = LoggerFactory.getLogger(ScriptCommand.class);
    private final Map<String, ScriptEngineState> engines = new HashMap<String, ScriptEngineState>();
    private ScriptEngineManager manager;
    private final Adaptable context;

    public ScriptCommand(Adaptable context) {
        this.context = context;
    }

    @Override
    public String execute(SoarCommandContext commandContext, String[] args) throws SoarException {
        return Utils.parseAndRun(new Script(this.context, this.engines, this.manager), args);
    }

    @Override
    public Object getCommand() {
        return new Script(this.context, this.engines, this.manager);
    }

    @CommandLine.Command(name="script", description={"Runs Javascript, Python, or Ruby code"}, subcommands={CommandLine.HelpCommand.class})
    public static class Script
    implements Callable<String> {
        @CommandLine.Spec
        private CommandLine.Model.CommandSpec spec;
        private final Map<String, ScriptEngineState> engines;
        private Adaptable context;
        private ScriptEngineManager manager;
        @CommandLine.Option(names={"-d", "--dispose"}, description={"Disposes the given script engine"})
        boolean dispose = false;
        @CommandLine.Option(names={"-r", "--reset"}, description={"Re-initializes the given script engine"})
        boolean reset = false;
        @CommandLine.Parameters(description={"The name of the engine and code to execute"})
        String[] engineNameAndCode = null;

        public Script(Adaptable context, Map<String, ScriptEngineState> engines, ScriptEngineManager manager) {
            this.context = context;
            this.engines = engines;
            this.manager = manager;
        }

        @Override
        public String call() {
            if (this.engineNameAndCode == null) {
                if (this.dispose || this.reset) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Error: engine name missing");
                }
                return this.engines.toString();
            }
            try {
                String engineName = this.engineNameAndCode[0];
                if (this.dispose) {
                    return this.disposeEngine(engineName);
                }
                ScriptEngineState state = this.getEngineByName(engineName, this.reset);
                ArrayList<String> trailing = new ArrayList<String>(Arrays.asList(this.engineNameAndCode).subList(1, this.engineNameAndCode.length));
                if (!trailing.isEmpty()) {
                    Object result = state.eval(Joiner.on((char)' ').join(trailing));
                    return result != null ? result.toString() : "";
                }
                return state.toString();
            }
            catch (SoarException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), e.getMessage(), (Throwable)e);
            }
        }

        private synchronized ScriptEngineManager getEngineManager() {
            if (this.manager == null) {
                this.manager = new ScriptEngineManager();
            }
            return this.manager;
        }

        private synchronized String disposeEngine(String name) throws SoarException {
            ScriptEngineState state = this.engines.remove(name);
            if (state != null) {
                state.dispose();
                return "Disposed '" + name + "'";
            }
            return "No engine '" + name + "'";
        }

        private synchronized ScriptEngineState getEngineByName(String name, boolean reset) throws SoarException {
            ScriptEngineState state = this.engines.get(name);
            if (state != null && reset) {
                state.dispose();
                this.engines.remove(name);
                state = null;
            }
            if (state == null) {
                ScriptEngine engine = this.getEngineManager().getEngineByName(name);
                if (engine == null) {
                    throw new SoarException("Unsupported script engine '" + name + "'");
                }
                ScriptEngineFactory f = engine.getFactory();
                logger.info(String.format("Loaded '%s' script engine for %s: %s version %s, %s version %s", name, this.context, f.getEngineName(), f.getEngineVersion(), f.getLanguageName(), f.getLanguageVersion()));
                state = new ScriptEngineState(this.context, name, engine);
                this.engines.put(name, state);
            }
            return state;
        }
    }

    public static class Provider
    implements SoarCommandProvider {
        @Override
        public void registerCommands(SoarCommandInterpreter interp, Adaptable context) {
            interp.addCommand("script", new ScriptCommand(context));
        }
    }
}

