/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util;

import java.util.ArrayList;
import java.util.List;
import org.jsoar.util.HashFunction;
import org.jsoar.util.HashTableItem;

public class HashTable<T extends HashTableItem> {
    public static final int[] masks_for_n_low_order_bits = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private int count = 0;
    private int size;
    private int log2size;
    private final int minimum_log2size;
    private HashTableItem[] buckets;
    private final HashFunction<T> h;
    private final Class<T> itemClass;

    public HashTable(int minimum_log2size, HashFunction<T> h, Class<T> itemClass) {
        this.minimum_log2size = minimum_log2size < 1 ? 1 : minimum_log2size;
        this.size = 1 << this.minimum_log2size;
        this.log2size = minimum_log2size;
        this.buckets = HashTable.allocateBuckets(this.size);
        this.h = h;
        this.itemClass = itemClass;
    }

    public List<T> getAllItems() {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.buckets.length; ++i) {
            HashTableItem item = this.buckets[i];
            while (item != null) {
                result.add(this.itemClass.cast(item));
                item = item.next_in_hash_table;
            }
        }
        return result;
    }

    public int getLog2Size() {
        return this.log2size;
    }

    public T getBucket(int hv) {
        return (T)this.buckets[hv];
    }

    public void remove_from_hash_table(T item) {
        T this_one = item;
        int hash_value = this.h.calculate(item, this.log2size);
        if (this.buckets[hash_value] == this_one) {
            this.buckets[hash_value] = ((HashTableItem)this_one).next_in_hash_table;
        } else {
            HashTableItem prev = this.buckets[hash_value];
            while (prev != null && prev.next_in_hash_table != this_one) {
                prev = prev.next_in_hash_table;
            }
            if (prev == null) {
                return;
            }
            prev.next_in_hash_table = ((HashTableItem)this_one).next_in_hash_table;
        }
        ((HashTableItem)this_one).next_in_hash_table = null;
        --this.count;
        if (this.count < this.size / 2 && this.log2size > this.minimum_log2size) {
            this.resize_hash_table(this.log2size - 1);
        }
    }

    public void add_to_hash_table(T item) {
        T this_one = item;
        ++this.count;
        if (this.count >= this.size * 2) {
            this.resize_hash_table(this.log2size + 1);
        }
        int hash_value = this.h.calculate(item, this.log2size);
        ((HashTableItem)this_one).next_in_hash_table = this.buckets[hash_value];
        this.buckets[hash_value] = this_one;
    }

    private static HashTableItem[] allocateBuckets(int size) {
        return new HashTableItem[size];
    }

    private void resize_hash_table(int new_log2size) {
        int new_size = 1 << new_log2size;
        HashTableItem[] new_buckets = HashTable.allocateBuckets(new_size);
        HashTableItem next = null;
        for (int i = 0; i < this.size; ++i) {
            HashTableItem item = this.buckets[i];
            while (item != null) {
                next = item.next_in_hash_table;
                int hash_value = this.h.calculate(item, new_log2size);
                item.next_in_hash_table = new_buckets[hash_value];
                new_buckets[hash_value] = item;
                item = next;
            }
        }
        this.buckets = new_buckets;
        this.size = new_size;
        this.log2size = new_log2size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (int hv = 0; hv < this.buckets.length; ++hv) {
            if (hv != 0) {
                builder.append(", ");
            }
            builder.append(hv);
            builder.append(" : ");
            HashTable.itemListToString(builder, this.buckets[hv]);
        }
        builder.append("}");
        return builder.toString();
    }

    private static void itemListToString(StringBuilder builder, HashTableItem first) {
        if (first == null) {
            builder.append(first);
            return;
        }
        builder.append("[");
        HashTableItem i = first;
        while (i != null) {
            if (i != first) {
                builder.append(", ");
            }
            builder.append(i);
            i = i.next_in_hash_table;
        }
        builder.append("]");
    }
}

