/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.jsoar.kernel.SoarException;

public class JdbcTools {
    public static Connection connect(String klass, String jdbcUrl) throws SoarException {
        try {
            Class.forName(klass);
        }
        catch (ClassNotFoundException e) {
            throw new SoarException("Failed to load database driver class: " + e.getMessage(), e);
        }
        try {
            return DriverManager.getConnection(jdbcUrl);
        }
        catch (SQLException e) {
            throw new SoarException("Failed to connect to database '" + jdbcUrl + "': " + e.getMessage(), e);
        }
    }

    private static String filterLine(String driverFilter, String line) {
        if (driverFilter == null || !line.startsWith("[")) {
            return line;
        }
        String prefix = "[" + driverFilter + "]";
        if (line.startsWith(prefix)) {
            return line.substring(prefix.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSql(Connection db, InputStream is, String driverFilter) throws SoarException, IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && (line = JdbcTools.filterLine(driverFilter, line)) != null) {
                    try (Statement s = db.createStatement();){
                        s.execute(line);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (SQLException e) {
            throw new SoarException("Sql error: " + e.getMessage(), e);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection db, InputStream is, String driverFilter) throws SoarException, IOException {
        try (Statement s = db.createStatement();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && (line = JdbcTools.filterLine(driverFilter, line)) != null) {
                    s.addBatch(line);
                }
                line = reader.readLine();
            }
            db.setAutoCommit(false);
            s.executeBatch();
            db.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new SoarException("Sql error: " + e.getMessage(), e);
        }
        finally {
            is.close();
        }
    }

    public static long insertAndGetRowId(PreparedStatement s) throws SQLException {
        s.executeUpdate();
        try (ResultSet keySet = s.getGeneratedKeys();){
            if (keySet.next()) {
                long l = keySet.getLong(1);
                return l;
            }
            throw new IllegalStateException("getGeneratedKeys() returned empty result set for '" + s + "'");
        }
    }

    public static boolean queryHasResults(PreparedStatement s) throws SQLException {
        try (ResultSet rs = s.executeQuery();){
            boolean bl = rs.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(Connection db, String table) throws SQLException {
        try (ResultSet rs = db.getMetaData().getTables(null, null, null, new String[]{"TABLE"});){
            while (rs.next()) {
                if (!table.equals(rs.getString("TABLE_NAME"))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void printResultSet(ResultSet rs, Writer out) throws SQLException {
        PrintWriter p = new PrintWriter(out);
        ResultSetMetaData md = rs.getMetaData();
        for (int c = 1; c <= md.getColumnCount(); ++c) {
            p.printf("| %10s ", md.getColumnLabel(c));
        }
        p.println("|");
        int rows = 0;
        while (rs.next()) {
            for (int c = 1; c <= md.getColumnCount(); ++c) {
                p.printf("| %10s ", rs.getObject(c));
            }
            p.println("|");
            ++rows;
        }
        p.printf("%d row%s", rows, rows != 1 ? "s" : "");
        p.println();
        p.flush();
    }
}

