/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jsoar.util.ListItem;

public final class ListHead<T>
implements Iterable<T> {
    public ListItem<T> first;

    public static <T> ListHead<T> newInstance() {
        return new ListHead<T>();
    }

    public static <T> ListHead<T> newInstance(ListHead<T> other) {
        return new ListHead<T>(other);
    }

    private ListHead() {
    }

    private ListHead(ListHead<T> other) {
        this.first = other.first;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public void clear() {
        this.first = null;
    }

    public T getFirstItem() {
        return !this.isEmpty() ? (T)this.first.item : null;
    }

    public int size() {
        return this.first != null ? this.first.count() : 0;
    }

    public ListItem<T> find(Object value) {
        return this.first != null ? this.first.find(value) : null;
    }

    public boolean contains(Object value) {
        return this.find(value) != null;
    }

    public ListItem<T> push(T value) {
        ListItem<T> item = new ListItem<T>(value);
        item.insertAtHead(this);
        return item;
    }

    public T pop() {
        T result = null;
        if (this.first != null) {
            result = this.first.item;
            this.first.remove(this);
        }
        return result;
    }

    public List<T> toList() {
        ArrayList<T> r = new ArrayList<T>();
        for (T member : this) {
            r.add(member);
        }
        return r;
    }

    public static <T> ListHead<T> fromCollection(Collection<T> collection) {
        ListHead<T> head = new ListHead<T>();
        ListItem<T> previous = null;
        for (T item : collection) {
            ListItem<T> member = new ListItem<T>(item);
            member.insertAfter(head, previous);
            previous = member;
        }
        return head;
    }

    boolean containsAsListItem(ListItem<T> item) {
        return this.first != null ? this.first.containsAsListItem(item) : false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.first != null ? this.first.iterator() : new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    public String toString() {
        return this.toList().toString();
    }
}

