/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util;

import java.util.Iterator;
import org.jsoar.util.ListHead;

public final class ListItem<T>
implements Iterable<T> {
    public final T item;
    public ListItem<T> next;
    public ListItem<T> previous;

    public ListItem(T item) {
        this.item = item;
        this.next = null;
        this.previous = null;
    }

    public T getNextItem() {
        return this.next != null ? (T)this.next.item : null;
    }

    public T getPreviousItem() {
        return this.previous != null ? (T)this.previous.item : null;
    }

    public void insertAtHead(ListHead<T> head) {
        assert (!head.containsAsListItem(this));
        this.next = head.first;
        this.previous = null;
        if (this.next != null) {
            this.next.previous = this;
        }
        head.first = this;
    }

    public void insertAfter(ListHead<T> head, ListItem<T> other) {
        assert (head != null);
        assert (other != this);
        assert (!head.containsAsListItem(this));
        this.previous = other;
        if (other == null) {
            head.first = this;
            this.next = null;
        } else {
            this.next = other.next;
            other.next = this;
            if (this.next != null) {
                this.next.previous = this;
            }
        }
    }

    public void remove(ListHead<T> head) {
        assert (head != null);
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        } else {
            head.first = this.next;
        }
        this.next = null;
        this.previous = null;
    }

    public int count(ListItem<T> end) {
        int n = 0;
        ListItem<T> start = this;
        while (start != end) {
            start = start.next;
            ++n;
        }
        return n;
    }

    public int count() {
        return this.count(null);
    }

    public ListItem<T> find(Object item) {
        ListItem<T> m = this;
        while (m != null) {
            if (item != null && item.equals(m.item) || item == m.item) {
                return m;
            }
            m = m.next;
        }
        return null;
    }

    boolean containsAsListItem(ListItem<T> item) {
        ListItem<T> m = this;
        while (m != null) {
            if (item == m) {
                return true;
            }
            m = m.next;
        }
        return false;
    }

    public ListHead<T> toListHead() {
        ListHead head = ListHead.newInstance();
        head.first = this;
        return head;
    }

    @Override
    public Iterator<T> iterator() {
        return new ItemIterator(this);
    }

    private static class ItemIterator<T>
    implements Iterator<T> {
        private ListItem<T> current;

        public ItemIterator(ListItem<T> current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            T r;
            T t = r = this.current != null ? (T)this.current.item : null;
            if (this.current != null) {
                this.current = this.current.next;
            }
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

