/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;

public class StringTools {
    public static String string_to_escaped_string(String s, char first_and_last_char) {
        StringBuilder dest = new StringBuilder();
        dest.append(first_and_last_char);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == first_and_last_char || c == '\\') {
                dest.append('\\');
            }
            dest.append(c);
        }
        dest.append(first_and_last_char);
        return dest.toString();
    }

    public static String createRegexFromGlob(String glob) {
        String out = "^";
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out = out + ".*";
                    continue block6;
                }
                case '?': {
                    out = out + '.';
                    continue block6;
                }
                case '.': {
                    out = out + "\\.";
                    continue block6;
                }
                case '\\': {
                    out = out + "\\\\";
                    continue block6;
                }
                default: {
                    out = out + c;
                }
            }
        }
        out = out + '$';
        return out;
    }

    public static <T> String join(Collection<T> collection, String delimiter) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (T o : collection) {
            if (!first) {
                builder.append(delimiter);
            }
            builder.append(o);
            first = false;
        }
        return builder.toString();
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        e.printStackTrace(printer);
        printer.flush();
        return writer.toString();
    }
}

