/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.adaptables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jsoar.util.adaptables.Adaptable;

public class Adaptables {
    public static <T> T adapt(Object o, Class<T> klass) {
        return Adaptables.adapt(o, klass, true);
    }

    public static <T> T adapt(Object o, Class<T> klass, boolean recurse) {
        if (o == null) {
            return null;
        }
        if (klass.isInstance(o)) {
            return klass.cast(o);
        }
        if (recurse && o instanceof Adaptable) {
            return klass.cast(((Adaptable)o).getAdapter(klass));
        }
        return null;
    }

    public static <T> List<T> adaptCollection(Collection<?> collection, Class<T> klass) {
        ArrayList<T> r = new ArrayList<T>();
        for (Object o : collection) {
            T t = Adaptables.adapt(o, klass);
            if (t == null) continue;
            r.add(t);
        }
        return r;
    }

    public static <T> T findAdapter(Collection<?> collection, Class<T> klass) {
        for (Object o : collection) {
            T t = Adaptables.adapt(o, klass);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> T require(Class<?> requiringClass, Object context, Class<T> requiredClass) {
        T t = Adaptables.adapt(context, requiredClass);
        if (t == null) {
            throw new IllegalStateException(requiringClass.getName() + " requires " + requiredClass.getCanonicalName());
        }
        return t;
    }
}

