/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.commands;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoar.kernel.SoarException;
import org.jsoar.util.commands.Option;

public class OptionProcessor<E> {
    private final Map<Character, Option<E>> shortOptions = new HashMap<Character, Option<E>>();
    private final Map<String, Option<E>> longOptions = new HashMap<String, Option<E>>();
    private Map<String, String> arguments = new HashMap<String, String>();

    public static <T> OptionProcessor<T> create() {
        return new OptionProcessor();
    }

    public OptionBuilder newOption(E longOption) {
        return new OptionBuilder(longOption);
    }

    public List<String> process(List<String> args) throws SoarException {
        this.arguments = new HashMap<String, String>();
        ArrayList<String> nonOptionArgs = new ArrayList<String>();
        if (args.isEmpty()) {
            return nonOptionArgs;
        }
        Iterator<String> iter = args.iterator();
        iter.next();
        boolean done = false;
        block0: while (iter.hasNext()) {
            String arg = iter.next();
            if (!done && arg.length() > 1 && arg.charAt(0) == '-') {
                if (arg.charAt(1) == '-') {
                    if (arg.length() == 2) {
                        done = true;
                        continue;
                    }
                    Option<E> option = this.resolveLongOption(arg.substring(2));
                    if (option == null) {
                        throw new SoarException("Unknown option: " + arg);
                    }
                    this.processOption(option, arg, iter);
                    continue;
                }
                if (!this.isNumber(arg)) {
                    for (int i = 1; i < arg.length(); ++i) {
                        Option<E> option = this.resolveShortOption(arg.charAt(i));
                        if (option == null) {
                            throw new SoarException("Unknown option: " + arg);
                        }
                        boolean consumedArg = this.processOption(option, arg, iter, i);
                        if (consumedArg) continue block0;
                    }
                    continue;
                }
            }
            nonOptionArgs.add(arg);
        }
        return nonOptionArgs;
    }

    private boolean processOption(Option<E> option, String arg, Iterator<String> iter) throws SoarException {
        return this.processOption(option, arg, iter, -1);
    }

    private boolean processOption(Option<E> option, String arg, Iterator<String> iter, int at) throws SoarException {
        boolean consumedArg = false;
        if (option.getType() == Option.ArgType.NONE) {
            this.arguments.put(option.getLongOption(), null);
        } else {
            consumedArg = true;
            String optArg = null;
            if (at >= 0 && at + 1 < arg.length()) {
                optArg = arg.substring(at + 1);
            }
            if (optArg == null) {
                String string = optArg = iter.hasNext() ? iter.next() : null;
            }
            if (option.getType() == Option.ArgType.REQUIRED && optArg == null) {
                throw new SoarException("Option requires argument: " + arg);
            }
            this.arguments.put(option.getLongOption(), optArg);
        }
        return consumedArg;
    }

    private boolean isNumber(String arg) {
        try {
            Integer.parseInt(arg);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(arg);
                return true;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    private Option<E> resolveLongOption(String arg) throws SoarException {
        String key = arg.toLowerCase();
        Option<E> ret = this.longOptions.get(key);
        if (ret != null) {
            return ret;
        }
        ArrayList<Option<E>> candidates = new ArrayList<Option<E>>();
        for (Map.Entry<String, Option<E>> entry : this.longOptions.entrySet()) {
            if (!entry.getKey().startsWith(key)) continue;
            candidates.add(entry.getValue());
        }
        if (candidates.size() == 1) {
            return (Option)candidates.get(0);
        }
        if (candidates.size() > 1) {
            throw new SoarException(arg + " matches multiple options: " + Joiner.on((char)' ').join(candidates));
        }
        return null;
    }

    private Option<E> resolveShortOption(char arg) throws SoarException {
        if (!Character.isLetter(arg)) {
            throw new SoarException("Short option is not a letter: " + arg);
        }
        return this.shortOptions.get(Character.valueOf(arg));
    }

    public boolean has(E longOption) {
        if (longOption == null || longOption.toString() == null) {
            throw new NullPointerException("Long option is null.");
        }
        if (this.arguments == null) {
            throw new IllegalStateException("Call process() before testing for options.");
        }
        return this.arguments.containsKey(longOption.toString().toLowerCase());
    }

    public void set(E longOption) {
        this.set(longOption, null);
    }

    public void unset(E longOption) {
        if (longOption == null || longOption.toString() == null) {
            throw new NullPointerException("Long option is null.");
        }
        if (this.arguments == null) {
            throw new IllegalStateException("Call process() before testing for options.");
        }
        this.arguments.remove(longOption.toString().toLowerCase());
    }

    public void set(E longOption, String argument) {
        if (longOption == null || longOption.toString() == null) {
            throw new NullPointerException("Long option is null.");
        }
        if (this.arguments == null) {
            throw new IllegalStateException("Call process() before testing for options.");
        }
        this.arguments.put(longOption.toString().toLowerCase(), argument);
    }

    public String get(E longOption) {
        if (longOption == null || longOption.toString() == null) {
            throw new NullPointerException("Long option is null.");
        }
        if (this.arguments == null) {
            throw new IllegalStateException("Call process() before testing for options.");
        }
        return this.arguments.get(longOption.toString().toLowerCase());
    }

    public int getInteger(E longOption) throws SoarException {
        String arg = this.get(longOption);
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            throw new SoarException("Invalid integer value: " + arg);
        }
    }

    public double getDouble(E longOption) throws SoarException {
        String arg = this.get(longOption);
        try {
            return Double.parseDouble(arg);
        }
        catch (NumberFormatException e) {
            throw new SoarException("Invalid double value: " + arg);
        }
    }

    public float getFloat(E longOption) throws SoarException {
        String arg = this.get(longOption);
        try {
            return Float.parseFloat(arg);
        }
        catch (NumberFormatException e) {
            throw new SoarException("Invalid float value: " + arg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (Option<E> option : this.longOptions.values()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(option);
        }
        return sb.append("]").toString();
    }

    public class OptionBuilder {
        private final E longOption;
        private char shortOption;
        private Option.ArgType type = Option.ArgType.NONE;
        private boolean registered = false;

        private OptionBuilder(E longOption) {
            if (longOption == null || longOption.toString() == null) {
                throw new NullPointerException("longOption must not be null.");
            }
            String str = longOption.toString();
            if (str.isEmpty()) {
                throw new IllegalArgumentException("Long option is empty string.");
            }
            this.shortOption(str.charAt(0));
            this.longOption = longOption;
        }

        public OptionBuilder newOption(E longOption) {
            this.done();
            return new OptionBuilder(longOption);
        }

        public OptionBuilder shortOption(char shortOption) {
            if (this.registered) {
                throw new IllegalStateException("Already registered.");
            }
            if (!Character.isLetter(shortOption)) {
                throw new IllegalArgumentException("Short option is not a single letter.");
            }
            this.shortOption = shortOption;
            return this;
        }

        public OptionBuilder noArg() {
            if (this.registered) {
                throw new IllegalStateException("Already registered.");
            }
            this.type = Option.ArgType.NONE;
            return this;
        }

        public OptionBuilder optionalArg() {
            if (this.registered) {
                throw new IllegalStateException("Already registered.");
            }
            this.type = Option.ArgType.OPTIONAL;
            return this;
        }

        public OptionBuilder requiredArg() {
            if (this.registered) {
                throw new IllegalStateException("Already registered.");
            }
            this.type = Option.ArgType.REQUIRED;
            return this;
        }

        public void done() {
            if (this.registered) {
                throw new IllegalStateException("Already registered.");
            }
            OptionProcessor.this.arguments = null;
            Option shortPrev = OptionProcessor.this.shortOptions.put(Character.valueOf(this.shortOption), Option.newInstance(this.longOption, this.type));
            if (shortPrev != null) {
                OptionProcessor.this.shortOptions.put(Character.valueOf(this.shortOption), shortPrev);
                throw new IllegalArgumentException("Already have a short option using -" + this.shortOption + ": " + shortPrev);
            }
            String longOptionString = this.longOption.toString().toLowerCase();
            Option longPrev = OptionProcessor.this.longOptions.put(longOptionString, Option.newInstance(this.longOption, this.type));
            if (longPrev != null) {
                OptionProcessor.this.shortOptions.remove(Character.valueOf(this.shortOption));
                OptionProcessor.this.longOptions.put(longOptionString, longPrev);
                throw new IllegalArgumentException("Already have a long option using --" + longOptionString + ": " + longPrev);
            }
            this.registered = true;
        }
    }
}

