/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.commands;

import java.io.File;
import java.net.URL;
import java.util.ServiceLoader;
import org.jsoar.kernel.SoarException;
import org.jsoar.util.FileTools;
import org.jsoar.util.adaptables.Adaptable;
import org.jsoar.util.commands.SoarCommandInterpreter;
import org.jsoar.util.commands.SoarCommandProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoarCommands {
    private static final Logger logger = LoggerFactory.getLogger(SoarCommands.class);

    public static void source(SoarCommandInterpreter interp, Object any) throws SoarException {
        if (any instanceof File) {
            interp.source((File)any);
        } else if (any instanceof URL) {
            interp.source((URL)any);
        } else {
            String s = any.toString();
            URL url = FileTools.asUrl(s);
            if (url != null) {
                interp.source(url);
            } else {
                interp.source(new File(s));
            }
        }
    }

    public static void registerCustomCommands(SoarCommandInterpreter interp, Adaptable context) {
        ServiceLoader<SoarCommandProvider> loader = ServiceLoader.load(SoarCommandProvider.class);
        for (SoarCommandProvider provider : loader) {
            logger.info("Registering custom commands from " + provider.getClass());
            provider.registerCommands(interp, context);
        }
    }
}

