/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.properties;

import java.util.concurrent.atomic.AtomicReference;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyProvider;

public class EnumPropertyProvider<T extends Enum<T>>
implements PropertyProvider<T> {
    public final PropertyKey<T> key;
    private final AtomicReference<T> value;

    public EnumPropertyProvider(PropertyKey<T> key) {
        this.key = key;
        this.value = new AtomicReference<T>(key.getDefaultValue());
    }

    @Override
    public T get() {
        return (T)((Enum)this.value.get());
    }

    @Override
    public T set(T newValue) {
        if (newValue == null) {
            throw new NullPointerException("newValue should not be null");
        }
        Object oldValue = this.get();
        this.value.set(newValue);
        return (T)oldValue;
    }

    public String toString() {
        return this.value.toString();
    }
}

